/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: RedisKeyConstant
 * @Package cn.freemud.constant
 * @Description: redisKey相关的常量
 * @author: song.cai
 * @date: 2018/12/17 12:48
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package com.freemud.sdk.api.assortment.shoppingcart.constant;

public class RedisKeyConstant {
    /**
     * 用户购物车在redis的key前缀
     */
    public final static String SAAS_SHOPPINGCART_KEY_PREFIX = "saas:user:info:cart:goods:";
    /**
     * 用户购物车在redis的key前缀  爱马哥蛋糕预定
     */
    public final static String SAAS_SHOPPINGCART_AIMAGE_KEY_PREFIX = "saas:user:info:advance:cart:goods:";
    /**
     * 用户购物车在redis的key前缀
     */
    public final static String SAAS_SHOPPINGCART_SENDGOODS_KEY_PREFIX = "saas:user:info:cart:sendgoods:";
    /**
     * 用户购物车在redis的key前缀
     */
    public final static String SAAS_SHOPPINGCART_COUPON_KEY_PREFIX = "saas:user:info:cart:coupon:";
    /**
     * 用户购物车在redis的key前缀
     */
    public final static String SAAS_USER_INFO_CART_CARTADDPRODUCT = "saas:user:info:cart:cartAddProduct:goods:";
    /**
     * 用户购物车总价在redis的key前缀
     */
    public final static String SAAS_SHOPPINGCART_AMOUNT_PREFIX = "saas:user:info:cart:amount:goods:";
    /**
     * 商品的信息前缀
     */
    public final static String SAAS_GOODS_KEY_PREFIX = "saas:goods:goods:";

    /**
     * 商品的缓存时间
     */
    public final static long GOODS_CACHE_SECONDS = 10;

    /**
     * kgd:meal:member:{partnerId}:{storeId}:{tableNum}
     * 围餐人员hashKey
     */
    public static final String MEAL_MEMBER_HASH_KEY = "kgd:meal:member:{0}:{1}:{2}";
    /**
     * kgd:meal:cart:ver:{partnerId}:{storeId}:{tableNum}
     * 围餐购物车版本号缓存
     */
    public static final String MEAL_CART_VER_KEY = "kgd:meal:cart:ver:{0}:{1}:{2}";
    /**
     * kgd:meal:cart:{partnerId}:{storeId}:{tableNum}
     * 购物车hashKey
     */
    public final static String MEAL_CART_BASE_HASH_KEY = "kgd:meal:cart:{0}:{1}:{2}";

    /**
     * kgd:meal:lock:{partnerId}:{storeId}:{tableNum}
     * 下单锁定购物车key
     */
    public final static String MEAL_CART_LOCK_KEY = "kgd:meal:lock:{0}:{1}:{2}";

    /**
     * 用户购物车在redis的key前缀（商城购物车）
     */
    public final static String SAAS_MALL_SHOPPINGCART_KEY_PREFIX = "saas:user:info:saasmall:cart:goods:";
    
    /**
     * 用户购物车总价在redis的key前缀(商城购物车)
     */
    public final static String SAAS_MALL_SHOPPINGCART_AMOUNT_PREFIX = "saas:user:info:saasmall:cart:amount:goods:";

    /**
     * 点餐门店绑定的商城门店redis的key前缀
     */
    public final static String OPENSTORE_MICROMALL_BIND_STOREID_PREFIX = "openstore:micromall:bind:storeId:";


    /**
     * kgd:collage:base:{partnerId}:{storeId}:{邀请用户ID}
     * 拼单基础key
     */
    public final static String COLLAGE_BASE_HASH_KEY = "kgd:collage:base:{0}:{1}:{2}";

    /**
     * kgd:collage:cart:{partnerId}:{storeId}:{邀请用户ID}
     * 拼单购物车key
     */
    public final static String COLLAGE_CART_HASH_KEY = "kgd:collage:cart:{0}:{1}:{2}";

    /**
     * kgd:collage:lock:{partnerId}:{storeId}:{邀请用户ID}
     * 拼单锁定key
     */
    public final static String COLLAGE_LOCK_HASH_KEY = "kgd:collage:lock:{0}:{1}:{2}";

    /**
     * kgd:collage:cart:ver:{partnerId}:{storeId}:{邀请用户ID}
     * 拼单购物车版本号key
     */
    public final static String COLLAGE_CART_VER_KEY = "kgd:collage:cart:ver:{0}:{1}:{2}";

    /**
     * kgd:collage:member:{partnerId}:{storeId}:{邀请用户ID}
     * 拼单点餐位缓存key
     */
    public final static String COLLAGE_MEMBER_KEY = "kgd:collage:member:{0}:{1}:{2}";

    /**
     * kgd:collage:member:state:{partnerId}:{storeId}:{邀请用户ID}
     * 拼单用户选好了状态缓存key
     */
    public final static String COLLAGE_MEMBER_STATE_KEY = "kgd:collage:member:state:{0}:{1}:{2}";

    /**
     * kgd:collage:store:member:{partnerId}
     * 商户下拼单人员缓存key
     */
    public final static String COLLAGE_PARTNER_MEMBER_KEY = "kgd:collage:partner:member:{0}";

    /**
     * kgd:collage:cart:lock:{partnerId}:{storeId}:{邀请用户ID}
     * 拼单购物车版本号key
     */
    public final static String COLLAGE_CART_LOCK_KEY = "kgd:collage:cart:lock:{0}:{1}:{2}";

}
