/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderServiceImpl
 * @Package cn.freemud.service.impl
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/17 20:55
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.impl;

import cn.freemud.adapter.*;
import cn.freemud.amp.body.MessagePushNewMqBody;
import cn.freemud.amqp.Header;
import cn.freemud.amqp.MQAction;
import cn.freemud.amqp.MQMessage;
import cn.freemud.amqp.MQService;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.base.log.LogTreadLocal;
import cn.freemud.base.util.DateUtil;
import cn.freemud.constant.RedisKeyConstant;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.controller.test.PlatformBaseRequest;
import cn.freemud.entities.dto.PayAccessResponse;
import cn.freemud.entities.dto.*;
import cn.freemud.entities.dto.QueryOrdersResponseDto.DataBean.OrderBean;
import cn.freemud.entities.dto.delivery.CancelDeliveryResponseDto;
import cn.freemud.entities.dto.order.CreateOrderOperateDto;
import cn.freemud.entities.dto.order.CreatePrepayRequestDto;
import cn.freemud.entities.dto.product.AttributeValue;
import cn.freemud.entities.dto.product.GroupDetail;
import cn.freemud.entities.dto.product.ProductAttributeGroup;
import cn.freemud.entities.dto.product.ProductGroup;
import cn.freemud.entities.dto.shoppingCart.NewShoppingCartClearDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.dto.user.SendCouponForqujiaDtoResponseDto;
import cn.freemud.entities.dto.user.SendCouponForqujiaRequestDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.*;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.management.service.OrderBaseService;
import cn.freemud.redis.RedisCache;
import cn.freemud.service.*;
import cn.freemud.service.mccafe.thirdparty.DeliveryFeiginMCCafeClient;
import cn.freemud.service.thirdparty.*;
import cn.freemud.utils.LogUtil;
import cn.freemud.utils.RedisUtil;
import cn.freemud.utils.ResponseUtil;
import cn.freemud.utils.ValidationCode;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.freemud.api.assortment.datamanager.entity.db.*;
import com.freemud.api.assortment.datamanager.entity.dto.AssortmentOpenApiEncryptDto;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.api.assortment.datamanager.enums.OpenPlatformEncryptUrlType;
import com.freemud.api.assortment.datamanager.manager.*;
import com.freemud.api.assortment.datamanager.manager.cache.CacheOpenPlatformPartnerWxappConfigManager;
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager;
import com.freemud.api.assortment.datamanager.meal.MealCacheManager;
import com.freemud.api.assortment.datamanager.openapiencrypt.CacheOpenApiEncryptManager;
import com.freemud.application.sdk.api.constant.ResponseConstant;
import com.freemud.application.sdk.api.constant.ResponseResultEnum;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponBaseResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponRedeemResponse;
import com.freemud.application.sdk.api.deliverycenter.response.CreateDeliveryOrderResponseDto;
import com.freemud.application.sdk.api.deliverycenter.service.DeliveryService;
import com.freemud.application.sdk.api.log.ApiLog;
import com.freemud.application.sdk.api.log.ErrorLog;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.ordercenter.enums.AfterSalesType;
import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import com.freemud.application.sdk.api.ordercenter.request.UpdateCouponCodeReq;
import com.freemud.application.sdk.api.ordercenter.request.UpdateDownstreamOrderCodeReq;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderCostResp;
import com.freemud.application.sdk.api.ordercenter.service.OrderSdkService;
import com.freemud.application.sdk.api.paymentcenter.client.request.CodePayRequest;
import com.freemud.application.sdk.api.paymentcenter.client.request.SVCCardAmountRequest;
import com.freemud.application.sdk.api.paymentcenter.client.response.CodePayResponse;
import com.freemud.application.sdk.api.paymentcenter.client.response.SVCCardAmountResponse;
import com.freemud.application.sdk.api.paymentcenter.client.service.PaymentNewService;
import com.freemud.application.sdk.api.service.EmailAlertService;
import com.freemud.application.sdk.api.storecenter.request.StoreInfoRequest;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.freemud.application.sdk.api.storecenter.service.StoreCenterService;
import com.freemud.application.sdk.api.structure.request.PushMessageNoticeDto;
import com.freemud.application.sdk.api.structure.service.MessageCenterClient;
import com.freemud.openstore.sdk.util.RSASignUtil;
import com.freemud.sdk.api.assortment.message.config.MessageOfficialRefundPushMqConfig;
import com.freemud.sdk.api.assortment.message.entity.MpTemplateMsg;
import com.freemud.sdk.api.assortment.message.entity.MpTemplateMsgDataValue;
import com.freemud.sdk.api.assortment.message.enums.MessageEventType;
import com.freemud.sdk.api.assortment.message.request.MessagePushOrderTemplateRequest;
import com.freemud.sdk.api.assortment.message.request.MessageTemplateRequest;
import com.freemud.sdk.api.assortment.message.service.IMessageTemplatePushService;
import com.freemud.sdk.api.assortment.order.enums.OldOrderType;
import com.freemud.sdk.api.assortment.order.request.order.*;
import com.freemud.sdk.api.assortment.order.response.order.*;
import com.freemud.sdk.api.assortment.order.response.payment.OrderPayResponse;
import cn.freemud.service.mccafe.CouponClientService;
import cn.freemud.service.mccafe.MCCafeOrderCenterSdkService;
import com.freemud.sdk.api.assortment.order.service.OrderCenterSdkService;
import com.freemud.sdk.api.assortment.order.util.MapBeanConvertUtil;
import com.freemud.sdk.api.assortment.order.vo.ProductGroupVo;
import com.freemud.sdk.api.assortment.orderdistributor.entity.dto.PaymentMqMessageDto;
import com.freemud.sdk.api.assortment.orderdistributor.service.PaymentQueueService;
import com.freemud.sdk.api.assortment.payment.request.UnifiedOrderRequest;
import com.freemud.sdk.api.assortment.payment.response.OrderRefundResponse;
import com.freemud.sdk.api.assortment.payment.response.UnifiedOrderResponse;
import com.freemud.sdk.api.assortment.payment.service.StandardPaymentService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Service
@Slf4j
public class MCCafeOrderServiceImpl implements MCCafeOrderService {

    private final Integer RESPONSE_SUCCESS_CODE = 100;

    private static Gson gson = new Gson();

    @Value("${mcCafe.reverseNotifyiDcUrl}")
    private String reverseNotifyiDcUrl;
    @Value("${mcCafe.refund.interval}")
    private String mccafeRefundInterval;
    @Value("${program.backorders_change_order_status_consumer_queue}")
    private String backOrdersChangeOrderStatusConsumerQueue;
    @Value("${program.backorders_notify_activity_exchange}")
    private String backOrdersNotifyActivityExchange;
    @Value("${mq.queue.cloud_print_queue}")
    private String cloudPrintQueue;
    @Value("${mq.cloud_print_exchange}")
    private String cloud_print_exchange;
    @Value("${saas.order.delivery.mcCafe.callBackUrl}")
    private String deliveryCallBackUrl;
    @Value("${mccafe.universal.coupon.code}")
    private String withOrderBuyCouponCode;
    @Value("${mcCafe.withOrderBuy.cardId}")
    private String withOrderBuyCardId;
    @Value("${mcCafe.fengniao.storeId}")
    private String fnStoreId;

    @Autowired
    private DeliveryFeiginClient deliveryFeiginClient;
    @Autowired
    private DeliveryAdapter deliveryAdapter;
    @Autowired
    private AssortmentCloudPrinterManager cloudPrinterManager;
    @Autowired
    private FMAssistantCloudPrintClient fmAssistantCloudPrintClient;
    @Autowired
    private MessageCenterClient messageNoticeClient;
    @Autowired
    private PromotionActivityClient promotionActivityClient;
    @Autowired
    private ShoppingCartClient shoppingCartClient;
    @Autowired
    private CustomerApplicationClient customerApplicationClient;
    @Autowired
    private ItemServiceImpl itemService;
    @Autowired
    private BuriedPointService buriedPointService;
    @Autowired
    private CouponActivityService couponActivityService;
    @Autowired
    private MessageNoticeAdapter messageNoticeAdapter;
    @Autowired
    private OrderAdapter orderAdapter;
    @Autowired
    private ActivityAdapter activityAdapter;
    @Autowired
    private CouponAdapter couponAdapter;
    @Autowired
    private MealCacheManager mealCacheManager;
    //聚合订单服务
    @Autowired
    private OrderCenterSdkService orderCenterSdkService;
    @Autowired
    private MCCafeOrderCenterSdkService mcCafeOrderCenterSdkService;
    @Autowired
    private StandardPaymentService standardPaymentService;
    //门店SDK
    @Autowired
    private StoreCenterService storeCenterService;
    @Autowired
    private DeliveryService deliveryService;
    @Autowired
    private MQService mqService;
    @Autowired
    @Qualifier("messageTemplatePushOrderService")
    private IMessageTemplatePushService<MessagePushOrderTemplateRequest> messageTemplatePushService;
    @Autowired
    private AssortmentOpenPlatformWxappManager openPlatformWxappManager;
    @Autowired
    private AssortmentOpenPlatformPartnerConfigManager openPlatformPartnerConfigManager;
    @Autowired
    private AssortmentCustomerInfoManager customerInfoManager;
    @Autowired
    private CheckMCCafeOrder checkMCCafeOrder;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private PaymentQueueService paymentQueueService;
    @Autowired
    private PaymentNewService paymentNewService;
    @Autowired
    private ActivityApplicationClient activityApplicationClient;
    @Autowired
    private AssortmentOpenPlatformWxappAuthorizerManager wxappAuthorizerManager;
    @Autowired
    private CacheOpenPlatformPartnerWxappConfigManager cacheOpenPlatformPartnerWxappConfigManager;
    @Autowired
    private OrderAdapterService orderAdapterService;
    @Autowired
    private AssortmentOpenPlatformPartnerManager assortmentOpenPlatformPartnerManager;
    @Autowired
    private CouponClientService couponClientService;
    @Autowired
    private DeliveryFeiginMCCafeClient deliveryFeiginMCCafeClient;
    @Autowired
    private OrderSdkService orderSdkService;
    @Autowired
    private EmailAlertService emailAlertService;
    @Autowired
    private OrderBaseService orderBaseService;
    @Autowired
    private CustomerExtendClient customerExtendClient;
    @Autowired
    private CacheOpenApiEncryptManager cacheOpenApiEncryptManager;

    @Override
    public BaseResponse createMCCafeOrder(CreateOrderVo createOrderVo) {
        String trackingNo = LogThreadLocal.getTrackingNo();
        // 查询用户信息,余额购物车校验
        AssortmentCustomerInfoVo userLoginInfoDto = checkMCCafeOrder.checkOrderByMember(createOrderVo, trackingNo);
        // 查询购物车（内部校验券点餐方式，券是否可用） 校验当前订单类型的下单参数
        ShoppingCartGoodsDto shoppingCartGoodsDto = checkMCCafeOrder.getMCCafeShoppingCartGoodsDto(createOrderVo, userLoginInfoDto);
        // 查询门店信息 营业时间、营业状态，服务器当前时间在营业时间内
        StoreResponse.BizVO storeResponseDto = checkMCCafeOrder.checkOrderByStore(createOrderVo, trackingNo);
        // 查询小程序自提外卖配置信息 校验当前订单类型的下单参数 校验外卖是否满足起送条件
        Integer pushOrderTime = checkMCCafeOrder.checkOrderByOrderType(createOrderVo, userLoginInfoDto, storeResponseDto, shoppingCartGoodsDto, trackingNo);
        OrderExtInfoDto extInfo = getExtInfo(userLoginInfoDto, storeResponseDto, pushOrderTime, createOrderVo);
        //1.9.2套餐需求同步优化创建订单代码
        BaseResponse createOrderOperateDtoResponse = this.sdkCreateOrder(createOrderVo, storeResponseDto, shoppingCartGoodsDto, userLoginInfoDto);
        if(createOrderOperateDtoResponse == null || !ResponseResult.SUCCESS.getCode().equals(createOrderOperateDtoResponse.getCode()) || createOrderOperateDtoResponse.getResult() == null ) {
            return createOrderOperateDtoResponse;
        }
        CreateOrderOperateDto createOrderOperateDto = (CreateOrderOperateDto)createOrderOperateDtoResponse.getResult();
        //创建支付
        CreatePrepayRequestDto createPrepayRequestDto = orderAdapter.convertToCreatePrepayRequestDto(createOrderVo.getPartnerId(), userLoginInfoDto.getWxAppId(), userLoginInfoDto.getOpenId(),
                createOrderVo.getFaceCode(), createOrderVo.getCardCode(), null,
                createOrderOperateDto.getFatherOrderBean(), createOrderOperateDto.getProductOrderBean(),
                createOrderOperateDto.getTotalAmount() == null ? 0 : createOrderOperateDto.getTotalAmount(),
                createOrderOperateDto.getCardAmount() == null ? 0 : createOrderOperateDto.getCardAmount(), extInfo,
                createOrderOperateDto.getFatherOrderBean().getOid(), null);
        createPrepayRequestDto.setNeedInvoice(createOrderVo.getNeedInvoice());
        return this.createPrepayOrder(createPrepayRequestDto);
    }


    /**
     * 获取预支付成功，将信息放入死心队列，当支付成功没有回掉的时候处理
     *
     * @param partnerId
     * @param storeId
     * @param fmId
     * @param orderId
     */
    public void putDelMq(String partnerId, String storeId, String fmId, String orderId) {
        PaymentMqMessageDto dto = new PaymentMqMessageDto();
        try {
            dto.setFmId(fmId);
            dto.setOrderId(orderId);
            dto.setPartnerId(partnerId);
            dto.setStoreId(storeId);
            dto.setTrackingNo(LogThreadLocal.getTrackingNo());
            paymentQueueService.paymentCallback(dto);
        } catch (Exception e) {
            log.info("paymentQueueService.paymentCallback" + dto + " error" + e);
        }

    }

    @Override
    public String mcCafePaySuccessCallback(NewPaysuccessNoticeMessage newMessage) {
        PaysuccessNoticeMessage message = new PaysuccessNoticeMessage();
        message.setResult_code(StringUtils.isBlank(newMessage.getResultCode()) ? 0 : Integer.valueOf(newMessage.getResultCode()));
        message.setOut_trade_no(StringUtils.isBlank(newMessage.getTransactionCode()) ? "" : newMessage.getTransactionCode());
        message.setTrans_id(StringUtils.isBlank(newMessage.getTransId()) ? "" : newMessage.getTransId());
        message.setTotal_fee(newMessage.getTotalAmount() == null ? 0 : newMessage.getTotalAmount());
        message.setOpenid(StringUtils.isBlank(newMessage.getOpenId()) ? "" : newMessage.getOpenId());
        message.setPlatform_coupon(newMessage.getPlatformCoupon() == null ? 0 : newMessage.getPlatformCoupon());
        message.setMerchant_coupon(newMessage.getPlatformCoupon() == null ? 0 : newMessage.getPlatformCoupon());
        message.setPaid_no(newMessage.getThirdPartTradeNo());
        message.setEndTransId(newMessage.getEndTransId());
        message.setPlatformMchId(newMessage.getPlatformMchId());
        message.setTerminalId(newMessage.getAppId());
        message.setRuleId(newMessage.getRuleId());
        String res = orderAdapterService.mcCafePaySuccessCallback(message);
        JSONObject jsonObject = JSONObject.parseObject(res);
        if (jsonObject.containsKey("code")) {
            Integer code = (Integer) jsonObject.get("code");
            if (Objects.equals(ResponseCodeConstant.RESPONSE_SUCCESS_0, code) || Objects.equals(ResponseCodeConstant.RESPONSE_SUCCESS, code)) {
                //  新版支付成功的情况下code为100
                return newSendPaySuccessNoticeMessage();
            } else {
                return newSendPayFaileMessage();
            }
        }
        return newSendPayFaileMessage();
    }

    public QueryRelationOrderByIdResponseDto getQueryRelationOrderByIdResponseDto(String oid) {
        QueryRelatedOrderByCodeRequest baseQueryOrderRequest = new QueryRelatedOrderByCodeRequest();
        baseQueryOrderRequest.setOrderCode(oid);
        baseQueryOrderRequest.setTrackingNo(LogTreadLocal.getTrackingNo());
        QueryRelatedOrderByCodeResp queryOrderByIdResponse;
        queryOrderByIdResponse = orderCenterSdkService.queryRelatedOrderByCode(baseQueryOrderRequest);
        String string = JSONObject.toJSONString(queryOrderByIdResponse);
        JSONObject jsonObject = JSONObject.parseObject(string);
        QueryRelationOrderByIdResponseDto queryOrderByIdResponseDto = jsonObject.toJavaObject(QueryRelationOrderByIdResponseDto.class);
        String orderString = JSONObject.toJSONString(queryOrderByIdResponse.getOrderBeanList());
        queryOrderByIdResponseDto.setData(JSONArray.parseArray(orderString, OrderBean.class));
        return queryOrderByIdResponseDto;
    }

    public void backOrdersStatusChange(String oid, Integer orderStatus) {
        if (StringUtils.isEmpty(oid)) {
            return;
        }
        ApiLog.info("backOrdersStatusChange", oid, String.valueOf(orderStatus));
        OrderStatusChangeRequestDto requestDto = new OrderStatusChangeRequestDto();
        requestDto.setOid(oid);
        requestDto.setOrderStatus(orderStatus);

        try {
            Header header = new Header(MQAction.INSERT.getAction(), "backOrdersStatusChange", oid, backOrdersChangeOrderStatusConsumerQueue);
            MQMessage<OrderStatusChangeRequestDto> message = new MQMessage<>(header, requestDto);
            mqService.convertAndSend(backOrdersNotifyActivityExchange, backOrdersChangeOrderStatusConsumerQueue, message);
        } catch (Exception e) {
            LogUtil.error("ActivityReverse", JSON.toJSONString(requestDto), "", e);
        }
    }

    private QueryOrderByIdResponseDto getQueryOrderByIdResponseDto(String oid) {
        BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
        baseQueryOrderRequest.setOrderId(oid);
        baseQueryOrderRequest.setTrackingNo(LogTreadLocal.getTrackingNo());
        QueryOrderByIdResponse queryOrderByIdResponse = orderCenterSdkService.queryOrderById(baseQueryOrderRequest);
        String string = JSONObject.toJSONString(queryOrderByIdResponse);
        JSONObject jsonObject = JSONObject.parseObject(string);
        return jsonObject.toJavaObject(QueryOrderByIdResponseDto.class);
    }

    /**
     * 支付后通知确认返回信息
     */
    public String newSendPaySuccessNoticeMessage() {
        Map<String, Object> map = Maps.newTreeMap();
        map.put("code", 100);
        map.put("message", "success");
        return gson.toJson(map);
    }

    /**
     * 支付后通知失败返回信息
     */
    public String newSendPayFaileMessage() {
        Map<String, Object> map = Maps.newTreeMap();
        map.put("code", 500);
        map.put("message", "failed");
        return gson.toJson(map);
    }


    /**
     * 发送模板消息
     *
     * @param orderBean
     * @param messageEventType
     */
    private void sendMessage(OrderBean orderBean, MessageEventType messageEventType) {
        MessageTemplateRequest<MessagePushOrderTemplateRequest> messageTemplateRequest = null;
        try {
            messageTemplateRequest = messageNoticeAdapter.convent2MessageTemplateRequest(orderBean);
            messageTemplateRequest.setMessageEventType(messageEventType);
            this.messageTemplatePushService.sendTemplateMsg(messageTemplateRequest);
        } catch (Exception e) {
            LogUtil.error("sendTemplateMsg_error", JSONObject.toJSONString(orderBean), JSONObject.toJSONString(messageTemplateRequest), e);
        }
    }

    /**
     * 获取商品第三方商品编号
     *
     * @param createOrderDto
     * @return
     */
    private BaseCreateOrderRequest getProductCustomerCode(BaseCreateOrderRequest createOrderDto) {
        List<String> spuIds = new ArrayList<>();
        for (CreateOrderProductRequest productDto : createOrderDto.getProducts()) {
            spuIds.add(productDto.getProductId());
        }
        Map<String, GetProductsVo> products = itemService.getSpuProducts(spuIds, createOrderDto.getCompanyId(), createOrderDto.getShopId(),createOrderDto.getMenuType());
        if (products.isEmpty()) {
            return createOrderDto;
        }
        for (CreateOrderProductRequest productDto : createOrderDto.getProducts()) {
            String skuId = productDto.getSpecification();
            if (products.get(skuId) != null) {
                productDto.setThirdProductSpecId(products.get(productDto.getSpecification()).getThirdProductSpecId());
                productDto.setThirdProductPropertyId(getThirdPropertyId(products.get(productDto.getSpecification()).getProductAttributeGroupList(),productDto.getAddInfo()));

                // todo 商品组信息
                setProductGroupInfo(products.get(skuId).getProductGroupList(), productDto);
            } else {
                LogUtil.error("getProducts_exception", JSONObject.toJSONString(skuId), JSONObject.toJSONString(products), null);
            }
            //套餐子商品
            if(CollectionUtils.isNotEmpty(productDto.getComboProduct())){
                for (CreateOrderProductRequest comboProduct : productDto.getComboProduct()){
                    String comboSkuId = comboProduct.getSpecification();
                    if (products.get(comboSkuId) != null) {
                        comboProduct.setThirdProductSpecId(products.get(comboSkuId).getThirdProductSpecId());
                        comboProduct.setThirdProductPropertyId(getThirdPropertyId(products.get(comboSkuId).getProductAttributeGroupList(),comboProduct.getAddInfo()));
                        comboProduct.setStapleFood(products.get(comboSkuId).getStapleFood());
                        // todo 套餐商品的商品组信息
                        setProductGroupInfo(products.get(comboSkuId).getProductGroupList(), comboProduct);
                    } else {
                        LogUtil.error("getProducts_exception", JSONObject.toJSONString(skuId), JSONObject.toJSONString(products), null);
                    }
                }
            }
        }
        return createOrderDto;
    }

    /**
     * 设置商品组信息
     * @param productGroupList
     * @param product
     */
    private void setProductGroupInfo(List<ProductGroup> productGroupList, CreateOrderProductRequest product) {
        if (CollectionUtils.isEmpty(productGroupList)) return;

        List<ProductGroupVo> targetGroupList = Lists.newArrayList();
        for (ProductGroup productGroup : productGroupList) {
            for (GroupDetail groupDetail : productGroup.getGroupDetail()) {
                ProductGroupVo productGroupVo = ProductGroupVo.builder()
                        .groupId(groupDetail.getGroupId()).groupName(productGroup.getName())
                        .thirdGroupId(productGroup.getGroupCode()).build();
                if (!targetGroupList.contains(productGroupVo)) {
                    targetGroupList.add(productGroupVo);
                }
            }
        }
        product.setProductGroupList(targetGroupList);
    }

    private String getThirdPropertyId(List<ProductAttributeGroup> productAttributeGroups, String addInfo) {
        String thirdProductPropertyId = "";
        if(StringUtils.isBlank(addInfo) || CollectionUtils.isEmpty(productAttributeGroups) ){
            return thirdProductPropertyId;
        }
        JSONObject jsonObject = JSONObject.parseObject(addInfo);
        String attributeNames = (String)jsonObject.get("attributeNames");
        List<String> list = new ArrayList<>();
        String[] split = attributeNames.split("/");

        List<AttributeValue> attributeValues = new ArrayList<>();
        for (ProductAttributeGroup attributeGroup : productAttributeGroups){
            attributeValues.addAll(attributeGroup.getAttributeValues());
        }

        for (int i= 0;i<split.length;i++){
            for (AttributeValue attributeValue : attributeValues){
                if(attributeValue.getAttributeValue().equals(split[i])){
                    list.add(attributeValue.getCustomerCode());
                    break;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(list)) {
            thirdProductPropertyId = StringUtils.join(list, ",");
        }
        return thirdProductPropertyId;
    }

    /**
     * 创建订单调用集成，不区分订单类型
     *
     * @return
     */
    public BaseResponse sdkCreateOrder(CreateOrderVo createOrderVo, StoreResponse.BizVO storeResponseDto, ShoppingCartGoodsDto shoppingCartGoodsDto,
                                                              AssortmentCustomerInfoVo userLoginInfoDto) {
        CreateOrderOperateDto response = new CreateOrderOperateDto();
        OrderExtendedReq orderExtendedReq = orderAdapter.saveStoreInfo(storeResponseDto);
        OrderClientType orderClient = OrderClientType.SAAS;
        String appId = userLoginInfoDto.getWxAppId();
        if(UserLoginChannelEnum.ALIPAY.getCode().equals(userLoginInfoDto.getChannel()) ){
            orderClient = OrderClientType.ALIPAY;
        } else if(UserLoginChannelEnum.APP.getCode().equals(userLoginInfoDto.getChannel())) {
            orderClient = OrderClientType.APP;
        }

        //麦咖啡只有普通订单
        CreateOrderResponse createOrderFlowResponse = createOrder(createOrderVo, storeResponseDto, shoppingCartGoodsDto, orderExtendedReq, orderClient,appId);
        if (ObjectUtils.notEqual(Integer.valueOf(ResponseResult.SUCCESS.getCode()), createOrderFlowResponse.getErrcode())) {
            return ResponseUtil.error(createOrderFlowResponse.getErrcode().toString(), createOrderFlowResponse.getErrmsg());
        }
        QueryOrdersResponse.DataBean.OrderBean fatherBeanListOne = createOrderFlowResponse.getData();
        QueryOrdersResponse.DataBean.OrderBean productBeanListOne = createOrderFlowResponse.getData();
        long totalAmount = createOrderFlowResponse.getData().getAmount();

        response.setTotalAmount(totalAmount);
        response.setCardAmount(0);
        response.setFatherOrderBean(fatherBeanListOne);
        response.setProductOrderBean(productBeanListOne);
        return ResponseUtil.success(response);
    }

    /**
     * 创建预支付订单
     */
    public BaseResponse createPrepayOrder(CreatePrepayRequestDto createPrepayRequestDto) {

        CreateOrderResponseVo createOrderResponse;
        OrderPayResponse orderPayResponse = null;
        PaymentRequest paymentRequest = orderBodyConvertToPaymentBody(createPrepayRequestDto.getOpenId(), createPrepayRequestDto.getPartnerId(), createPrepayRequestDto.getWxAppId(), createPrepayRequestDto.getPayCode());
        long totalAmount = createPrepayRequestDto.getTotalAmount();
        String cardCode = createPrepayRequestDto.getCardCode();
        String transId = createPrepayRequestDto.getTransId();
        //麦咖啡不支持svc卡
        if (totalAmount < 0) {
            throw new ServiceException(ResponseResult.PAY_AMOUNT_ERROR);
        } else if (totalAmount > 0) {
            orderPayResponse = getPreOrderPay(createPrepayRequestDto.getFatherOrderBean(), paymentRequest, LogThreadLocal.getTrackingNo(), createPrepayRequestDto.getCardAmount(), transId, createPrepayRequestDto.getNeedInvoice());
        } else {
            // 0元订单如果不需要支付，自定义支付单号
            orderPayResponse = getOrderPayResponse(paymentRequest, createPrepayRequestDto.getFatherOrderBean());
        }
        if (orderPayResponse == null) {
            return failPreOrderPay(LogThreadLocal.getTrackingNo(), createPrepayRequestDto.getProductOrderBean(), cardCode, createPrepayRequestDto.getOrderClient());
        }
        createOrderResponse = orderAdapter.convent2CreateFatherSonOrderResponseVo(orderPayResponse, createPrepayRequestDto.getProductOrderBean());
        BaseResponse baseEditResponse = this.updateOrderInfo(orderPayResponse, createPrepayRequestDto.getOrderExtInfoDTO(), createPrepayRequestDto.getProductOrderBean(), LogThreadLocal.getTrackingNo());
        if (baseEditResponse != null) {
            return baseEditResponse;
        }
        if (totalAmount > 0 && StringUtils.isBlank(cardCode)) {
            createOrderResponse.setPaySuccess(false);
        } else {
            createOrderResponse.setPaySuccess(true);
        }
        // 推荐优惠插件用户下单数据上报
        //wechatPushProcessor.statusOrderCreate(userLoginInfoDto, createOrderResponse.getOid(), createOrderVo.getPartnerId());
        if (!createOrderResponse.getPaySuccess()) {
            return ResponseUtil.success(createOrderResponse);
        } else {
            //如果是商品券支付0元，调用回调接口
            PaysuccessNoticeMessage message = new PaysuccessNoticeMessage();
            message.setResult_code(100);
            message.setOut_trade_no(createOrderResponse.getFmId());
            message.setTrans_id(createOrderResponse.getOid());
            message.setTotal_fee(0);
            message.setOpenid(createPrepayRequestDto.getOpenId());
            message.setPlatform_coupon(0);
            message.setMerchant_coupon(0);
            //修改为麦咖啡支付成功回调
            orderAdapterService.mcCafePaySuccessCallback(message);
            return ResponseUtil.success(createOrderResponse);
        }
    }

    /**
     * 创建普通订单
     */
    public CreateOrderResponse createOrder(CreateOrderVo createOrderVo, StoreResponse.BizVO storeResponseDto, ShoppingCartGoodsDto shoppingCartGoodsDto,
                                           OrderExtendedReq orderExtendedReq, OrderClientType orderClient,String appId) {
        BaseCreateOrderRequest baseCreateOrderRequest = orderAdapter.convent2CreateOrderDto(createOrderVo, shoppingCartGoodsDto, storeResponseDto);
        //查询第三方商品编号
        baseCreateOrderRequest = getProductCustomerCode(baseCreateOrderRequest);
        //保存门店渠道信息
        baseCreateOrderRequest.setOrderExtended(orderExtendedReq);
        baseCreateOrderRequest.setOrderClient(orderClient);
        baseCreateOrderRequest.setAppId(appId);
        CreateOrderRequest createOrderRequest = new CreateOrderRequest();
        baseCreateOrderRequest.setTrackingNo(LogThreadLocal.getTrackingNo());
        createOrderRequest.setBaseCreateOrderRequest(baseCreateOrderRequest);
        MqMessageRequest mqMessageRequest = new MqMessageRequest();
        mqMessageRequest.setBackOrdersNotifyActivityExchange(backOrdersNotifyActivityExchange);
        mqMessageRequest.setBackOrdersNotifyActivityQueue(backOrdersChangeOrderStatusConsumerQueue);
        createOrderRequest.setMqMessageRequest(mqMessageRequest);
        createOrderRequest.setTrackingNo(LogThreadLocal.getTrackingNo());
        return mcCafeOrderCenterSdkService.createMCCafeOrderFlow(createOrderRequest);
    }

    private OrderPayResponse getOrderPayResponse(PaymentRequest paymentRequest, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        OrderPayResponse orderPayResponse;
        String fmId = "SPAY" + ValidationCode.getRandomUuid();
        orderPayResponse = orderAdapter.getOrderPayResponse(orderBean.getCompanyId(), paymentRequest,
                orderBean.getOid(), fmId);
        return orderPayResponse;
    }

    private BaseResponse failPreOrderPay(String trackingNo, QueryOrdersResponse.DataBean.OrderBean orderBean, String cardCode, OrderClientType orderClient) {
        List<OrderClientType> notCancelOrderClientList = Lists.newArrayList(OrderClientType.APP);
        if(!notCancelOrderClientList.contains(orderClient)) {
            //失败冲正库存，冲正活动库存，取消订单
            CancelOrderRequest cancelOrderRequest = orderAdapter.convent2CancelOrderRequest(orderBean.getOid(), orderBean.getCompanyId(),
                    AfterSalesType.SYSTEM_CANCEL, "获取预支付失败", trackingNo, null);
            orderCenterSdkService.orderCancel(cancelOrderRequest);
            // TODO: 2019/9/10 hubowen mq推送变更
            backOrdersStatusChange(orderBean.getOid(), orderBean.getStatus());
        }
        //svc 卡支付失败
        if (StringUtils.isNotBlank(cardCode)) {
            return ResponseUtil.error(ResponseResultEnum.PAY_BACKEND_CONFIG_ERROR.getCode(), ResponseResultEnum.PAY_BACKEND_CONFIG_ERROR.getMessage(), null);
        }
        return ResponseUtil.error(ResponseResultEnum.PAY_UNIFIED_ORDER_ERROR.getCode(), ResponseResultEnum.PAY_UNIFIED_ORDER_ERROR.getMessage(), null);
    }

    public OrderPayResponse getPreOrderPay(QueryOrdersResponse.DataBean.OrderBean orderBean, PaymentRequest paymentRequest, String trackingNo, Integer cardAmount, String transId, int needInvoice) {
        try {
            UnifiedOrderRequest request = orderAdapter.convent2UnifiedOrderRequest(orderBean, paymentRequest, orderBean.getAmount(), cardAmount, transId);
            request.setInvoiceFlag(needInvoice);
            Map<String, String> extendParams = new HashMap<>();
            if(OldOrderType.TAKE_OUT.getCode().equals(orderBean.getOrderType())) {
                extendParams.put("mealType", "delivery");
            } else {
                extendParams.put("mealType", "pickup");
            }
            request.setExtendParams(extendParams);
            com.freemud.application.sdk.api.base.BaseResponse<UnifiedOrderResponse> responseBase = standardPaymentService.unifiedOrder(request, trackingNo);
            if (!ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(responseBase.getCode())) {
                log.error("支付SDK返回信息错误,trackingNo:{} request:{} response:{}", trackingNo, JSONObject.toJSONString(request), JSONObject.toJSONString(responseBase));
                return null;
            }
            putDelMq(request.getPartnerId(), request.getStoreId(), responseBase.getData().getFmId(), orderBean.getOid());
            OrderPayResponse orderPayResponse = orderAdapter.convent2OrderPayResponse(responseBase.getData());
            orderPayResponse.setWxAppid(paymentRequest.getWxAppId());
            orderPayResponse.setOpenId(paymentRequest.getOpenId());
            orderPayResponse.setPartnerId(orderBean.getCompanyId());
            orderPayResponse.setOrderId(orderBean.getOid());
            return orderPayResponse;
        } catch (Exception e) {
            LogUtil.error("getPreOrderPay_error", JSONObject.toJSONString(orderBean), JSONObject.toJSONString(paymentRequest));
            //TODO 邮件告警
            return null;
        }
    }

    public OrderPayResponse svcPay(String cardCode, QueryOrdersResponse.DataBean.OrderBean orderBean, PaymentRequest paymentRequest, String transId, String trackingNo) {
        CodePayRequest request = new CodePayRequest();
        String partnerId = orderBean.getCompanyId();
        request.setBody(orderBean.getShopName());
        request.setBusinessDate(DateUtil.convert2String(new Date(), DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
        request.setCode(cardCode);
        request.setPartnerId(partnerId);
        request.setStoreId(orderBean.getShopId());
        request.setAmount(orderBean.getAmount());
        request.setTransId(transId);
        request.setStationId("1");
        request.setOperatorId("1");
        request.setVer("2");
        SVCCardAmountRequest svcRequest = new SVCCardAmountRequest();
        svcRequest.setPartnerId(partnerId);
        svcRequest.setCardCodes(Arrays.asList(cardCode));
        //查询svc卡余额
        com.freemud.application.sdk.api.base.BaseResponse<SVCCardAmountResponse> svcCardAmountResponseBaseResponse = paymentNewService.querySVCCardAmount(svcRequest, trackingNo);
        if (svcCardAmountResponseBaseResponse == null || !ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(svcCardAmountResponseBaseResponse.getCode())
                || svcCardAmountResponseBaseResponse.getData().getData() == null || CollectionUtils.isEmpty(svcCardAmountResponseBaseResponse.getData().getData().getCardSimpleInfos())) {
            return null;
        }
        Integer amount = svcCardAmountResponseBaseResponse.getData().getData().getCardSimpleInfos().get(0).getAmount();
        Integer vamount = svcCardAmountResponseBaseResponse.getData().getData().getCardSimpleInfos().get(0).getVamount();
        if (amount + vamount < orderBean.getAmount()) {
            return null;
        }
        //svc卡支付
        com.freemud.application.sdk.api.base.BaseResponse<CodePayResponse> responseBase = paymentNewService.codePay(request, trackingNo);
        if (responseBase == null || !ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(responseBase.getCode()) || responseBase.getData().getData() == null) {
            return null;
        }
        OrderPayResponse orderPayResponse = new OrderPayResponse();
        CodePayResponse.CodePayDate codePayResponse = responseBase.getData().getData();
        orderPayResponse.setFmId(codePayResponse.getFmId());
        orderPayResponse.setPayTransId(codePayResponse.getPayTransId());
        orderPayResponse.setWxAppid(paymentRequest.getWxAppId());
        orderPayResponse.setOpenId(paymentRequest.getOpenId());
        orderPayResponse.setPartnerId(orderBean.getCompanyId());
        orderPayResponse.setOrderId(orderBean.getOid());
        return orderPayResponse;
    }

    private PaymentRequest orderBodyConvertToPaymentBody(String openId, String partnerId, String appId, String payCode) {
        //设置支付信息
        PaymentRequest paymentRequest = new PaymentRequest();
        paymentRequest.setOpenId(openId);
        paymentRequest.setWxAppId(appId);
        AssortmentOpenPlatformWxapp wxApp = openPlatformWxappManager.findByPartnerIdAndWxappId(partnerId, appId);
        AssortmentOpenPlatformPartner platformPartner = null;
        if (wxApp == null) {
            platformPartner = assortmentOpenPlatformPartnerManager.selectOpenPlatformPartner(partnerId);
        }
        paymentRequest.setPrincipalName(wxApp != null ? wxApp.getPrincipalName() : platformPartner != null ? platformPartner.getCompanyName() : "上海非码网络科技有限公司");
        paymentRequest.setReverseNotifyiDcUrl(reverseNotifyiDcUrl);
        paymentRequest.setPayCode(payCode);
        return paymentRequest;
    }

    private OrderExtInfoDto getExtInfo(AssortmentCustomerInfoVo userLoginInfoDto, StoreResponse.BizVO storeResponseDto,
                                      Integer pushOrderTime, CreateOrderVo createOrderVo) {

        Integer serviceTime = storeResponseDto.getServiceTime();
        String sessionId = createOrderVo.getSessionId();
        String version = createOrderVo.getVersion();
        CreateOrderVo.BuyMemberCard memberCard = createOrderVo.getBuyMemberCard();

        String deliveryHoursDayStart = "";
        String deliveryHoursDayEnd = "";
        if (StringUtils.isNotBlank(storeResponseDto.getDeliveryHoursDay())) {
            String[] days = storeResponseDto.getDeliveryHoursDay().split("-");
            if (days.length == 2) {
                deliveryHoursDayStart = DateUtil.convert2String(new Date(), DateUtil.FORMAT_yyyyMMdd_date) + " " + days[0] + ":00";
//                deliveryHoursDayEnd = DateUtil.convert2String(new Date(), DateUtil.FORMAT_yyyyMMdd_date) + " " + days[1] + ":00";
            }
        }

        OrderExtInfoDto orderExtInfoDto = new OrderExtInfoDto();
        orderExtInfoDto.setDeliveryHoursDayStart(deliveryHoursDayStart);
        orderExtInfoDto.setDeliveryHoursDayEnd(deliveryHoursDayEnd);
        orderExtInfoDto.setOpenid(userLoginInfoDto.getOpenId());
        orderExtInfoDto.setAppid(userLoginInfoDto.getWxAppId());
        orderExtInfoDto.setSessionId(sessionId);
        if (Objects.equals(serviceTime, null)) {
            serviceTime = 50;
        }
        orderExtInfoDto.setServiceTime(serviceTime);
        orderExtInfoDto.setPushOrderTime(pushOrderTime);
        orderExtInfoDto.setVersion(version);
        if (memberCard != null && memberCard.getRuleId() != null) {
            orderExtInfoDto.setRuleId(memberCard.getRuleId());
        }
        // 扩展字段中存储 sessionKey
        orderExtInfoDto.setSessionKey(createOrderVo.getSessionKey());
        orderExtInfoDto.setFormId(createOrderVo.getFormId());
        orderExtInfoDto.setFromAppId(userLoginInfoDto.getWxAppId());
        orderExtInfoDto.setNeedInvoice(createOrderVo.getNeedInvoice());
        orderExtInfoDto.setInvoiceTitle(createOrderVo.getInvoiceTitle());
        orderExtInfoDto.setNeedTableware(createOrderVo.getNeedTableware());
        orderExtInfoDto.setThirdPartyMemberId(userLoginInfoDto.getThirdPartyMemberID());
        if (StringUtils.isNotBlank(createOrderVo.getScene())) {
            orderExtInfoDto.setScene(createOrderVo.getScene());
        }
        return orderExtInfoDto;
    }

    /**
     * 编辑订单，保持预支付信息
     */
    public BaseResponse updateOrderInfo(OrderPayResponse orderPayResponse, OrderExtInfoDto orderExtInfo
            , QueryOrdersResponse.DataBean.OrderBean orderBean, String trackingNo) {
        orderExtInfo.setOpenid(orderPayResponse.getOpenId());
        orderExtInfo.setFmId(orderPayResponse.getFmId());
        orderExtInfo.setAppid(orderPayResponse.getWxAppid());
        String prepayId = "";
        OrderPayResponse.PayOrderBean payOrder = orderPayResponse.getPayOrder();
        // StringUtils 依赖修改
        if (payOrder != null && !StringUtils.isEmpty(payOrder.getPackageX())) {
            String[] prepayIds = payOrder.getPackageX().split("=");
            prepayId = prepayIds.length > 1 ? prepayIds[1] : "";
        }
        //支付宝保存交易流水号发送支付宝模板消息
        if (payOrder != null && !StringUtils.isEmpty(payOrder.getAliPayOrder())) {
            prepayId = payOrder.getAliPayOrder();
        }
        orderExtInfo.setPrepayId(prepayId);

        OrderEditRequest orderEditRequest = new OrderEditRequest(orderPayResponse.getPayTransId(),
                JSONObject.toJSONString(orderExtInfo));
        orderEditRequest.setOrderId(orderBean.getOid());
        orderEditRequest.setTrackingNo(trackingNo);
        BaseOrderResponse baseOrderResponse = orderCenterSdkService.orderEdit(orderEditRequest);
        if (!ObjectUtils.equals(ResponseCodeConstant.RESPONSE_SUCCESS, baseOrderResponse.getErrcode())) {
            CancelOrderRequest cancelOrderRequest = orderAdapter.convent2CancelOrderRequest(orderBean.getOid(), orderBean.getCompanyId(),
                    AfterSalesType.SYSTEM_CANCEL, "编辑订单支付信息失败", trackingNo, null);
            orderCenterSdkService.orderCancel(cancelOrderRequest);
            //如果编辑订单支付信息失败，冲正
            backOrdersStatusChange(orderBean.getOid(), orderBean.getStatus());
            return ResponseUtil.error(baseOrderResponse.getErrcode().toString(), baseOrderResponse.getErrmsg());

        }

        return null;
    }


    @Override
    public String paySuccessCallback(PaysuccessNoticeMessage message, ConfirmOrderDto confirmOrderDto, Map<String, QueryOrdersResponseDto.DataBean.OrderBean> orderBeans) {
        QueryOrdersResponseDto.DataBean.OrderBean orderBean = orderBeans.get(OrderBeanType.SAASORDER.getCode());
        String oid = StringUtils.isNotEmpty(orderBean.getParentCode()) && !"0".equals(orderBean.getParentCode()) ? orderBean.getParentCode() : orderBean.getOid();
        String partnerId = orderBean.getCompanyId();
        String userId = orderBean.getUserId();
        String storeId = orderBean.getShopId();
        orderBean.setPayVoucher(message.getOut_trade_no());
        //编辑订单信息，获取openid，用于退款
        String extInfo = orderBean.getExtInfo();
        OrderExtInfoDto orderExtInfoDto = null;
        String wxappid = "";
        String sessionId = "";
//        String openid = "";
//        String ruleId = "";
        String payCode = "";
        if (StringUtils.isNotBlank(extInfo)) {
            orderExtInfoDto = gson.fromJson(extInfo, OrderExtInfoDto.class);
            if (orderExtInfoDto != null && StringUtils.isNotBlank(orderExtInfoDto.getOpenid())) {
//                openid = orderExtInfoDto.getOpenid();
                wxappid = orderExtInfoDto.getAppid();
                sessionId = orderExtInfoDto.getSessionId();
//                ruleId = orderExtInfoDto.getRuleId();
            }
            if (orderExtInfoDto != null && StringUtils.isNotBlank(orderExtInfoDto.getPayCode())
                    && Arrays.asList(PayChannel.ALIPAY.getCode(), PayChannel.WXPAY.getCode()).contains(orderExtInfoDto.getPayCode())) {
                payCode = orderExtInfoDto.getPayCode();
            }
        }
        // 如果订单状态不是未支付，返回信息
//        if (!PayStatus.NOT_PAY.getCode().equals(orderBean.getPayStatus()) || !OrderStatus.WAIT_PAY.getCode().equals(orderBean.getStatus())) {
//            return sendPaySuccessNoticeMessage();
//        }

        //麦咖啡随单购咖啡月卡
        withOrderBuyCoupon(orderBean,sessionId);

        // 如果是到店，则冻结优惠券
        // 如果是外卖，则核销优惠券
        // 失败重试三次
        if(OldOrderType.TAKE_OUT.getCode().equals(orderBean.getType())) {
            List<CouponRedeemResponse> couponRedeemResponseList = couponClientService.redeemBatch(orderBean);

            if (CollectionUtils.isNotEmpty(couponRedeemResponseList)){
                // TODO 记录一下核销失败的券
            }

        } else if(OldOrderType.COLLECT_GOODS.getCode().equals(orderBean.getType()) || OldOrderType.EAT_IN.getCode().equals(orderBean.getType())) {
            List<CouponBaseResponse> couponBaseResponseList = couponClientService.lockBatch(orderBean);

            if (CollectionUtils.isNotEmpty(couponBaseResponseList)){
                // TODO 记录一下冻结失败的券
            }
        }
        // 订单失败后 发消息重试 待实现
        String takeCode;
        String daySeq;
        PayAccessResponse payAccessResponse;
        ConfirmOrderRequest var1 = LightApplicationConvertToAssortmentSdkAdapter.confirmOrderDtoConvertToConfirmOrderRequest(confirmOrderDto, orderBeans.get(OrderBeanType.MERMBERORDER.getCode()));
        var1.setPartnerId(partnerId);
        var1.setStoreId(storeId);
        var1.setOrderType(orderBean.getType());
        var1.setProductOrderCode(orderBean.getOid());
        var1.setPayDate(DateUtil.convert2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        var1.setPayTransId(message.getOut_trade_no());
        var1.setOperator(orderBean.getUserName());
        var1.setEndTransId(message.getEndTransId());
        if (StringUtils.isNotBlank(payCode)) {
            var1.setPayChannel(payCode);
            var1.setPayChannelName(PayChannel.getByCode(payCode).getDesc());
        }
        if (orderBean.getGmtExpect() != null && orderBean.getGmtExpect() != 0) {
            var1.setExpectTime(DateUtil.convert2String(new Date(orderBean.getGmtExpect()), DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
            if(OldOrderType.COLLECT_GOODS.getCode().equals(orderBean.getType()) || OldOrderType.EAT_IN.getCode().equals(orderBean.getType())) {
                var1.setTimeout(-5);
            }
        }
        // 订单支付成功
        com.freemud.sdk.api.assortment.order.response.order.PayAccessResponse payAccessRes = orderCenterSdkService.payAccessMCCafe(var1);

        //调用基础服务生成第三方订单号
        String downstreamThirdOrderCode = "";
        if(OldOrderType.TAKE_OUT.getCode().equals(orderBean.getType())) {
            //调用基础订单接口更新信息
            UpdateDownstreamOrderCodeReq updateDownstreamOrderCodeReq = new UpdateDownstreamOrderCodeReq();
            updateDownstreamOrderCodeReq.setOrderCode(orderBean.getOid());
            com.freemud.application.sdk.api.ordercenter.response.BaseResponse baseResponse = orderSdkService.updateDownstreamThirdOrderCode(updateDownstreamOrderCodeReq, LogThreadLocal.getTrackingNo());

            LinkedHashMap<String, String> linkedHashMap = (LinkedHashMap) baseResponse.getResult();
            downstreamThirdOrderCode = linkedHashMap.get("downstreamThirdOrderCode");
        }

        String string2 = JSONObject.toJSONString(payAccessRes);
        JSONObject jsonObject2 = JSONObject.parseObject(string2);
        payAccessResponse = jsonObject2.toJavaObject(PayAccessResponse.class);
        // 添加幂等处理，若订单是已支付成功状态，直接返回成功
        if (!RESPONSE_SUCCESS_CODE.equals(payAccessResponse.getErrcode())) {
            OrderBean saasOrder = getOrderBeanByOrderId(confirmOrderDto.getOrderId()).get(OrderBeanType.SAASORDER.getCode());
            if (saasOrder != null && (!PayStatus.NOT_PAY.getCode().equals(saasOrder.getPayStatus()) || !OrderStatus.WAIT_PAY.getCode().equals(saasOrder.getStatus()))) {
                return sendPaySuccessNoticeMessage();
            }
            LogUtil.error("paySuccessCallback_payAccess_faild", gson.toJson(confirmOrderDto), gson.toJson(payAccessResponse));
            //orderRefund(orderBean, "订单异常退款", openid, oid);
            return gson.toJson(message);
        }

        //麦咖啡支付成功接单
        if(OldOrderType.TAKE_OUT.getCode().equals(orderBean.getType())) {
            BaseQueryOrderRequest var2 = new BaseQueryOrderRequest();
            var2.setOrderId(confirmOrderDto.getOrderId());
            var2.setPartnerId(partnerId);
            BaseOrderResponse baseOrderResponse = orderCenterSdkService.orderConfirmTakeMCCafe(var2);
            LogUtil.info("paySuccessCallback_orderConfirmTake", gson.toJson(var2), gson.toJson(baseOrderResponse));
        }

        // TODO 订单序号替换取餐码显示
        takeCode = payAccessResponse.getData().getTakeCode();
        daySeq = payAccessResponse.getData().getDaySeq();


        //TODO 清空购物车
        NewShoppingCartClearDto newShoppingCartClearDto = new NewShoppingCartClearDto();
        newShoppingCartClearDto.setPartnerId(partnerId);
        newShoppingCartClearDto.setShopId(storeId);
        newShoppingCartClearDto.setUserId(userId);
        newShoppingCartClearDto.setAppId(wxappid);
        newShoppingCartClearDto.setSessionId(sessionId);
        newShoppingCartClearDto.setOperationType(1);
        shoppingCartClient.clearMCCafeShoppingCart(newShoppingCartClearDto);
        if (StringUtils.isNotBlank(daySeq) && orderExtInfoDto != null && !OrderType.TAKE_OUT.getCode().equals(orderBean.getType())) {
            String storeAddress = StringUtils.isNotBlank(orderBean.getAddress()) ? orderBean.getAddress() : "";
            orderBean.setAddress(storeAddress);
            orderBean.setOtherCode(takeCode);
            //发送支付成功模板消息
            this.sendPaySuccessMessage(orderBean);
        }
        // 有云打印机 打印小票，杯贴
        try {
            List<AssortmentCloudPrinter> storePrinters = cloudPrinterManager.getStorePrinters(partnerId, storeId);
            if (null != storePrinters && storePrinters.size() > 0) {
                boolean printerStatus = false;
                for (AssortmentCloudPrinter cloudPrinter : storePrinters) {
                    if (null != cloudPrinter.getStatus() && cloudPrinter.getStatus() == 1) {
                        printerStatus = true;
                    }
                }
                //在线打印
                if (printerStatus) {
                    OrderPrintDto orderPrintDto = orderAdapter.convert2OrderPrintDto(orderBean);
                    orderPrintDto.setDaySeq(daySeq);
                    orderPrintDto.setOtherCode(takeCode);
                    asynchronousPrint(orderPrintDto);
                }
            }
        } catch (Exception e) {
            LogUtil.error("cloudPrint_error", null, null, e);
        }
        //TODO 埋点支付行为
        BuriedPointPaymentRequestDto requestDto = new BuriedPointPaymentRequestDto();
        requestDto.setStoreId(storeId);
        requestDto.setPartnerId(partnerId);
        requestDto.setWxAppId(wxappid);
        requestDto.setSessionId(sessionId);
        requestDto.setOpenId(orderExtInfoDto != null ? orderExtInfoDto.getOpenid() : "");
        buriedPointService.BuriedPointPayment(requestDto, orderBean);

        if(OldOrderType.TAKE_OUT.getCode().equals(orderBean.getType())) {
            //获取门店信息
            StoreResponse storeInfo = storeCenterService.getStoreInfo(new StoreInfoRequest(orderBean.getCompanyId(), orderBean.getShopId()), "");
            if (storeInfo == null || ObjectUtils.notEqual(cn.freemud.management.enums.ResponseResult.SUCCESS.getCode(), storeInfo.getStatusCode().toString()) || storeInfo.getBizVO() == null) {
                return sendPaySuccessNoticeMessage();
            }
            CreateDeliveryVo createDeliveryVo = deliveryAdapter.buildDeliveryOrderRequestDto(orderBean, storeInfo, deliveryCallBackUrl, downstreamThirdOrderCode);
            //创建配送单
            CreateDeliveryOrderResponseDto deliveryResponse = deliveryFeiginClient.deliveryOrderAdd(createDeliveryVo);
            //创建配送单失败，更新订单为异常单
            if (deliveryResponse == null || RESPONSE_SUCCESS_CODE != deliveryResponse.getCode() || deliveryResponse.getData() == null) {
                String deliveryId = deliveryResponse != null && deliveryResponse.getData() != null ? deliveryResponse.getData().getDeliveryId() : "";
                String operator =  "系统" ;
                String abnormalDesc = "配送异常";
                if(null != deliveryResponse && StringUtils.isNotBlank(deliveryResponse.getMsg())) {
                    abnormalDesc = deliveryResponse.getMsg();
                }
                updateDeliveryAbnormal(orderBean.getCompanyId(), orderBean.getOid(), deliveryId, operator, abnormalDesc);
                emailAlertService.sendEmailAlert("创建配送单失败", String.format("request:%s \r\nresponse:%s", JSONObject.toJSONString(createDeliveryVo), JSONObject.toJSONString(deliveryResponse)));
                return sendPaySuccessNoticeMessage();
            } else {
                orderBaseService.updateDeliverySuccess(orderBean.getOid(), deliveryResponse.getData().getDeliveryId(), "系统");
            }
        }

        //支付回掉成功标记
        redisCache.save(RedisKeyConstant.KGD_PAYMENT_CALLBACK_FMID + message.getOut_trade_no(), message.getOut_trade_no(), 10L, TimeUnit.MINUTES);
        return sendPaySuccessNoticeMessage();
    }

    /**
     * 创建配送单一车 -> 更新订单为异常单
     *
     * @param partnerId
     * @param orderCode
     * @param deliveryId
     */
    public void updateDeliveryAbnormal(String partnerId, String orderCode, String deliveryId, String operator, String abnormalDesc) {
        AssortmentUpdateDeliveryAbnormalRequest request = AssortmentUpdateDeliveryAbnormalRequest.builder()
                .abnormalDesc(abnormalDesc)
                .deliveryId(deliveryId)
                .orderCode(orderCode)
                .partnerId(partnerId)
                .operator(StringUtils.isNotBlank(operator) ? operator : "sys")
                .build();
        orderCenterSdkService.updateDeliveryAbnormal(request);
    }


    @Override
    public BaseResponse orderRefund(OrderRefundVo orderRefundVo) {
        if (StringUtils.isEmpty(orderRefundVo.getReason())) {
            orderRefundVo.setReason("用户申请退款");
        }
        AssortmentCustomerInfoVo userInfo = customerInfoManager.getCustomerInfoByObject(orderRefundVo.getSessionId());
        if (userInfo == null || StringUtils.isEmpty(userInfo.getMemberId())) {
            return ResponseUtil.error(ResponseResult.NOT_LOGIN);
        }
        String memberId = userInfo.getMemberId();
        String partnerId = userInfo.getPartnerId();

        if (StringUtils.isBlank(orderRefundVo.getOid())) {
            return ResponseUtil.error(ResponseResult.PARAMETER_MISSING.getCode(), "oid不能为空");
        }

        BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
        baseQueryOrderRequest.setOrderId(orderRefundVo.getOid());
        baseQueryOrderRequest.setTrackingNo(LogTreadLocal.getTrackingNo());
        QueryOrderByIdResponse queryOrderByIdResponse = orderCenterSdkService.queryOrderById(baseQueryOrderRequest);
        String string = JSONObject.toJSONString(queryOrderByIdResponse);
        JSONObject jsonObject = JSONObject.parseObject(string);
        QueryOrderByIdResponseDto orderByIdResponseDto = jsonObject.toJavaObject(QueryOrderByIdResponseDto.class);
        boolean isSon = StringUtils.isEmpty(orderByIdResponseDto.getData().getParentCode()) || "0".equals(orderByIdResponseDto.getData().getParentCode());
        String orderId = isSon ? orderByIdResponseDto.getData().getOid() : orderByIdResponseDto.getData().getParentCode();
        if (!RESPONSE_SUCCESS_CODE.equals(orderByIdResponseDto.getErrcode()) || orderByIdResponseDto.getData() == null) {
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR.getCode(), "订单信息不存在");
        }
        if (!memberId.equals(orderByIdResponseDto.getData().getUserId())) {
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR.getCode(), "不能操作非本人的订单");
        }
        OrderBean orderBean = orderByIdResponseDto.getData();
        if (PayStatus.NOT_PAY.getCode().equals(orderByIdResponseDto.getData().getPayStatus())
                || OrderStatus.WAIT_PAY.getCode().equals(orderBean.getStatus())) {
            return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "订单未支付，无法退款");
        }
        if (OrderStatus.CALCEL.getCode().equals(orderBean.getStatus())) {
            return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "订单已取消，无法退款");
        }
        if (OrderStatus.COMPLETE.getCode().equals(orderBean.getStatus())) {
            return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "订单已完成，无法退款");
        }
        if(OldOrderType.COLLECT_GOODS.getCode().equals(orderBean.getOrderType()) || OldOrderType.EAT_IN.getCode().equals(orderBean.getOrderType())) {
            if(null == orderBean.getGmtExpect() || orderBean.getGmtExpect().equals(0l)) {
                return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "实时到店订单无法退款");
            } else {
                Date expectTime = new Date(orderBean.getGmtExpect());
                if(expectTime.before(new Date())) {
                    return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "预约到店订单超过预约时间后无法退款");
                }
            }
        }

        /**
         * 已接单，制作完成，配送中,未接单，用户可申请退款
         *
         * v1.9.3.1 支持已完成订单可申请退款(通过b端后台控制)
         */
        List<Integer> enableRefundCodes = Lists.newArrayList(Arrays.asList(
                OrderStatus.TAKE_ORDER.getCode(),
                OrderStatus.RECEIPT.getCode(),
                OrderStatus.COMPLETE_MAKE.getCode(),
                OrderStatus.DISTRIBUTION.getCode()
//                ,OrderStatus.COMPLETE.getCode()
        ));

        if (enableRefundCodes.contains(orderBean.getStatus()) && PayStatus.HAVE_PAID.getCode().equals(orderBean.getPayStatus())) {
            if (CollectionUtils.isNotEmpty(orderBean.getRefundList())) {

                for(int i=0;i<orderBean.getRefundList().size();i++) {
                    OrderBean.RefundBean refundBean = orderBean.getRefundList().get(i);
                    if (RefundStatus.COMPLETE_REFUND.getCode().equals(refundBean.getStatus())) {
                        return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "订单已退款完成，无法再次退款");
                    }
                    if (RefundStatus.APPLY_REFUND.getCode().equals(refundBean.getStatus())) {
                        return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "商家正在处理中，请稍后……");
                    }
                    if(new Date().getTime() - Long.valueOf(refundBean.getCreateTime()) < Long.valueOf(mccafeRefundInterval)) {
                        return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "退款请求太频繁，请稍后再试");
                    }
                }
//                if (RefundStatus.REFUSE_REFUND.getCode().equals(refundBean.getStatus())) {
//                    return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "您的申请已被商家拒绝，请联系门店沟通。");
//                }
            }
//            List<AssortmentOpenPlatformPartnerWxappConfig> partnerWxappConfigs = cacheOpenPlatformPartnerWxappConfigManager.cacheSelectDefaultPage(userInfo.getWxAppId(), "2");

//            Map<String, AssortmentOpenPlatformPartnerWxappConfig> configMap = partnerWxappConfigs.stream().collect(Collectors.toMap(AssortmentOpenPlatformPartnerWxappConfig::getAppKey, Function.identity()));

            //是否退配送费  麦咖啡必退配送费
            boolean isRefundDeliveryFee = true;
//            AssortmentOpenPlatformPartnerWxappConfig refundDeliveryFeeConfig = configMap.get(OrderRefundEnum.REFUND_DELIVERY_FEE_ENABLE.getKeyValue());
//            LogUtil.info("orderRefund of oid:{}, {}, {}", orderBean.getOid(),orderBean.getStatus(), (null != refundDeliveryFeeConfig ? ToStringBuilder.reflectionToString(refundDeliveryFeeConfig) : null));
//            // 0、null表示 关闭 ; 1 表示开启
//            if (null != refundDeliveryFeeConfig
//                    && Arrays.asList(OrderStatus.DISTRIBUTION.getCode()).contains(orderBean.getStatus())
//                    && !ALLOW_REFUND.equals(refundDeliveryFeeConfig.getAppValue())) {
//                isRefundDeliveryFee = false;
//            }

            //申请取消配送单/取消配送单
            BaseResponseDto deliveryBaseResponse = new BaseResponseDto();
            if(OldOrderType.TAKE_OUT.getCode().equals(orderBean.getOrderType())) {
                deliveryBaseResponse = cancelDelivery(orderBean);
                if(!ResponseConstant.SUCCESS_RESPONSE_CODE.equals(deliveryBaseResponse.getErrcode())) {
                    return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "取消配送单失败，退款失败");
                }
            }

            //
            if ((OldOrderType.TAKE_OUT.getCode().equals(orderBean.getOrderType()) && CancelDeliveryResponseDto.notCollectMsg.equals(deliveryBaseResponse.getErrmsg()))
                    || OldOrderType.COLLECT_GOODS.getCode().equals(orderBean.getOrderType())
                    || OldOrderType.EAT_IN.getCode().equals(orderBean.getOrderType())) {
                //商家未接单逻辑处理    1.调用支付退款 2.根据支付退款返回状态组装订单取消参数,调用订单取消接口
                BaseResponse baseResponse = partnerNoTakeOrder(orderRefundVo, orderBean, orderId,AfterSalesType.USER_CANCEL,isRefundDeliveryFee);
                if (baseResponse != null) {
                    return baseResponse;
                }
                // 删除订单 通知活动添加商品库存
                backOrdersStatusChange(orderBean.getOid(), orderBean.getStatus());
            } else if(OldOrderType.TAKE_OUT.getCode().equals(orderBean.getOrderType()) && CancelDeliveryResponseDto.hasCollectMsg.equals(deliveryBaseResponse.getErrmsg())) {

                OrderRefundRequest orderRefundRequest = new OrderRefundRequest();
                orderRefundRequest.setPartnerId(orderBean.getCompanyId());
                orderRefundRequest.setStoreId(orderBean.getShopId());
                orderRefundRequest.setOrderId(orderBean.getOid());
                orderRefundRequest.setOrderClient(OrderClientType.SAAS.getIndex());

                orderRefundRequest.setAfterSalesType(AfterSalesType.USER_CANCEL);
                orderRefundRequest.setReason(orderRefundVo.getReason());
                orderRefundRequest.setRemark(orderRefundVo.getRemarks());
                orderRefundRequest.setOperator(orderBean.getUserName());
                orderRefundRequest.setOrderStatus(orderBean.getStatus());
                orderRefundRequest.setActualAmount(orderBean.getAmount());
                orderRefundRequest.setReqAmount(orderBean.getAmount());

                BaseOrderResponse baseOrderResponse = orderCenterSdkService.orderRefund(orderRefundRequest);
                if (baseOrderResponse == null || baseOrderResponse.getData() == null || !ObjectUtils.equals(ResponseConstant.SUCCESS_RESPONSE_CODE, baseOrderResponse.getErrcode())) {
                    return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "创建售后单失败");
                }
//                if (orderBean.getAmount() > 0) {
//                    sendPosMessage(partnerId, orderBean.getShopId());
//                }
                //通知小助手发送申请退款公众号订阅消息
                sendApplyRefundSubscriptionNotice(orderBean, orderRefundVo);
                //已接单可发起退款申请，查询门店有无云打印机，有则打印退款申请小票
                printApplyRefundSmallTicket(orderBean, orderRefundVo);
            } else {
                return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "订单状态异常，退款失败");
            }
        }
        return ResponseUtil.success();
    }

    /**
     * 商家未接单,取消订单逻辑处理    1.调用支付退款 2.根据支付退款返回状态组装订单取消参数,调用订单取消接口
     *
     * @param orderRefundVo
     * @param orderBean
     */
    private BaseResponse partnerNoTakeOrder(OrderRefundVo orderRefundVo, OrderBean orderBean, String fatherOrderId,AfterSalesType afterSalesType,Boolean isRefundDeliveryFee) {
        com.freemud.application.sdk.api.base.BaseResponse<OrderRefundResponse> response = null;
        Long refundId = System.currentTimeMillis();
        String partnerId = orderBean.getCompanyId();
        int state = PayRefundStatus.SUCCESS.getCode();

        if (orderBean.getAmount() != 0) {
            //调用支付退款
            com.freemud.sdk.api.assortment.payment.request.OrderRefundRequest orderPayRefundRequest = orderAdapter.getOrderPayRefundRequest(orderBean, refundId, fatherOrderId);
            Map<String, String> extendParams = new HashMap<>();
            if(OldOrderType.TAKE_OUT.getCode().equals(orderBean.getOrderType())) {
                extendParams.put("mealType", "delivery");
            } else {
                extendParams.put("mealType", "pickup");
            }
            orderPayRefundRequest.setExtendParams(extendParams);
            response = standardPaymentService.orderRefund(orderPayRefundRequest, LogTreadLocal.getTrackingNo());
            if (response == null || response.getData() == null || !com.freemud.sdk.api.assortment.order.domain.ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(response.getCode())) {
                return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "orderRefund_failed");
            }
            //获取支付返回退款状态
            state = response.getData().getRefundStatus() == null ? PayRefundStatus.SUCCESS.getCode() : response.getData().getRefundStatus();
        }
        CancelOrderRequest cancelOrderRequest = orderAdapter.convent2CancelOrderRequest(orderBean.getOid(),
                partnerId, afterSalesType, orderRefundVo.getReason(), LogTreadLocal.getTrackingNo(), refundId.toString());
        cancelOrderRequest.setOperator(orderBean.getUserName());
        cancelOrderRequest.setPartnerId(orderBean.getCompanyId());
        if (PayRefundStatus.SUCCESS.getCode().intValue() == state) {
            //退款成功
            cancelOrderRequest.setCreateEvent(AfterSalesOrderCreateEventEnum.REFUND_COMPLETE.getCreateEvent());
        }
        cancelOrderRequest.setReqRemark(orderRefundVo.getRemarks());
        cancelOrderRequest.setRefundDeliveryAmount(isRefundDeliveryFee);
        BaseOrderResponse baseOrderResponse = orderCenterSdkService.orderCancel(cancelOrderRequest);
        if (baseOrderResponse == null || baseOrderResponse.getData() == null || !ObjectUtils.equals(ResponseConstant.SUCCESS_RESPONSE_CODE, baseOrderResponse.getErrcode())) {
            return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "orderRefund_failed");
        }
        return null;
    }

    @Override
    public String mcCafeRefundNotifyCallback(RefundNotifyCallbackRequestVo requestVo) {
        if (StringUtils.isEmpty(requestVo.getTransId())) {
            //订单号不能为空
            return refundFaileMessage("transId is can not empty");
        }
        //混合支付需要从缓存中获取订单号码，正常支付TransId = orderId
        String orderId = redisCache.getValue(RedisUtil.getPaymentTransIdOrderKey(requestVo.getTransId()));
        if(StringUtils.isNotEmpty(orderId)){
            requestVo.setTransId(orderId);
        }
        String trackingNo = LogTreadLocal.getTrackingNo();
        Integer refundStatus = requestVo.getRefundStatus();
        if (!Objects.equals(refundStatus, ResponseCodeConstant.RESPONSE_SUCCESS)) {
            //只有退款成功更新状态.其他情况不处理
            return refundFaileMessage("pay refundStatus is not 100,refundStatus=" + refundStatus);
        }
        // 如果transId为空,返回失败
        if (StringUtils.isBlank(requestVo.getTransId())) {
            return refundFaileMessage("transId is empty " + requestVo);
        }
        //查询订单详情
        QueryRelationOrderByIdResponseDto queryOrderByIdResponseDto = getQueryRelationOrderByIdResponseDto(requestVo.getTransId());
        if (queryOrderByIdResponseDto.getData() == null || !Objects.equals(ResponseCodeConstant.RESPONSE_SUCCESS, queryOrderByIdResponseDto.getErrcode())) {
            return refundFaileMessage("order query fail " + queryOrderByIdResponseDto);
        }

        OrderBean orderBean = new OrderBean();
        if (1 == queryOrderByIdResponseDto.getData().size()) {
            orderBean = queryOrderByIdResponseDto.getData().get(0);
        } else {
            List<OrderBean> orderBeans = queryOrderByIdResponseDto.getData().stream().filter(order -> order.getBizType().equals(1)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(orderBeans)) {
                orderBean = orderBeans.get(0);
            }
        }

//        PlatformBaseRequest platformBaseRequest = getRequest(orderBean);

        OrderRefundRequest orderRefundRequest = new OrderRefundRequest();
        orderRefundRequest.setPartnerId(orderBean.getCompanyId());
        orderRefundRequest.setStoreId(orderBean.getShopId());
        orderRefundRequest.setOrderId(orderBean.getOid());
        orderRefundRequest.setOrderClient(OrderClientType.SAAS.getIndex());

        orderRefundRequest.setAfterSalesType(AfterSalesType.USER_CANCEL);
        orderRefundRequest.setReason("门店线下退款");
        orderRefundRequest.setOperator("门店营业人员");
        orderRefundRequest.setOrderStatus(orderBean.getStatus());
        orderRefundRequest.setActualAmount(orderBean.getAmount());
        orderRefundRequest.setReqAmount(orderBean.getAmount());
        orderRefundRequest.setTrackingNo(trackingNo);
        orderRefundRequest.setCreateEvent(AfterSalesOrderCreateEventEnum.REFUND_COMPLETE.getCreateEvent());

        BaseOrderResponse baseOrderResponse = orderCenterSdkService.orderRefund(orderRefundRequest);

        if (baseOrderResponse == null || baseOrderResponse.getData() == null || !ObjectUtils.equals(ResponseConstant.SUCCESS_RESPONSE_CODE, baseOrderResponse.getErrcode())) {
            LogUtil.error("mcCafeRefundNotifyCallback", orderRefundRequest, baseOrderResponse);
            return refundFaileMessage("create after sale order failed");
        }



        return newSendPaySuccessNoticeMessage();
    }

    private PlatformBaseRequest getRequest(OrderBean orderInfo) {
        PlatformBaseRequest request = new PlatformBaseRequest();
        AssortmentOpenApiEncryptDto openApiEncrypts = cacheOpenApiEncryptManager.getAssortmentOpenApiEncrypt(orderInfo.getCompanyId(), OpenPlatformEncryptUrlType.REFUND_STATUS_CHANGE_NOTIFY_URL);
        request.setAppId(openApiEncrypts.getAppId());
        request.setPartnerId(orderInfo.getCompanyId());
        request.setVer("1");
        OrderRefundStatusChangeRequestBody orderBody = new OrderRefundStatusChangeRequestBody();
        orderBody.setOrderCode(orderInfo.getOid());
        orderBody.setTimeStamp(System.currentTimeMillis()+"");
        orderBody.setRefundType(AfterSalesType.OTHER.getIndex().toString());
        orderBody.setRefundStatus(com.freemud.sdk.api.assortment.order.enums.RefundStatus.COMPLETE_REFUND.getCode().toString());
        orderBody.setRefundReason("门店线下退款");
        request.setRequestBody(JSON.toJSONString(orderBody));
        String content = MapBeanConvertUtil.sortObjWithoutSign(request);
        try {
            request.setSign(RSASignUtil.getSign(content, openApiEncrypts.getServerPrivateKey(), "UTF-8"));
        } catch (Exception e) {
            LogUtil.error("getPlatformBaseRequest", content, JSON.toJSONString(openApiEncrypts), e);
        }
        return request;
    }

    /**
     * 取消配送
     *
     * @param orderBean
     * @return
     */
    public BaseResponseDto cancelDelivery(OrderBean orderBean) {
        BaseResponseDto baseResponseDto = new BaseResponseDto();
        baseResponseDto.setErrcode(100);
        if (orderBean.getType() == 1 && orderBean.getAddInfo() != null) {
            Integer deliverStatus = orderBean.getDeliverStatus();
            if (ObjectUtils.equals(cn.freemud.management.enums.DeliveryStatus.DELIVERYERROR.getCode(), deliverStatus)) {
                baseResponseDto.setErrmsg(CancelDeliveryResponseDto.notCollectMsg);
                return baseResponseDto;
            }
            if (ObjectUtils.equals(cn.freemud.management.enums.DeliveryStatus.DELIVERYCANCEL.getCode(), deliverStatus)
                    || ObjectUtils.equals(cn.freemud.management.enums.DeliveryStatus.DELIVERYARRIVED.getCode(), deliverStatus)) {
                return baseResponseDto;
            }

            CancelDeliveryRequest cancelDeliveryRequest = CancelDeliveryRequest.builder()
                    .displayOrderId(orderBean.getDownstreamThirdOrderCode())
                    .orderId(orderBean.getOid())
                    .orderCancelCode("4")
                    .orderCancelDescription("用户申请退款")
                    .storeId(orderBean.getShopId())
                    .deliveryId(orderBean.getAddInfo().getDeliveryId())
                    .reviewId(orderBean.getOid().substring(0, 20))
                    .build();
            CancelDeliveryResponseDto deliveryBaseResponse = deliveryFeiginMCCafeClient.cancelRequest(cancelDeliveryRequest);
            baseResponseDto.setErrcode(deliveryBaseResponse.getCode());
            baseResponseDto.setErrmsg(deliveryBaseResponse.getMsg());

            if (deliveryBaseResponse == null || !ResponseConstant.SUCCESS_RESPONSE_CODE.equals(deliveryBaseResponse.getCode())) {
                LogUtil.error("申请取消配送单失败", cancelDeliveryRequest, deliveryBaseResponse);
                return baseResponseDto;
            }
        }
        return baseResponseDto;
    }

    /**
     * 退款中回调失败返回信息
     */
    public String refundFaileMessage(String errorMes) {
        Map<String, Object> map = Maps.newTreeMap();
        map.put("code", 500);
        map.put("message", "failed:" + errorMes);
        return gson.toJson(map);
    }

    /**
     * 通知小助手发送申请退款公众号订阅消息
     * @param orderBean
     */
    public void sendApplyRefundSubscriptionNotice(OrderBean orderBean,OrderRefundVo request) {
        LogUtil.debug("sendApplyRefundSubscriptionNotice", JSONObject.toJSONString(request), null);
        String partnerId = orderBean.getCompanyId();
        String shopId = orderBean.getShopId();
        if(orderBean.getExtInfo() == null){
            return;
        }
        OrderExtInfoDto extInfo = JSONObject.parseObject(orderBean.getExtInfo(), OrderExtInfoDto.class);
        if(extInfo == null || extInfo.getAppid() == null){
            return;
        }
        AssortmentOpenPlatformWxappAuthorizer authorizerAppid = wxappAuthorizerManager.findAuthorizerByWxAppId(extInfo.getAppid());
        if(authorizerAppid == null){
            return;
        }
        String accessToken = authorizerAppid.getAuthorizerAccessToken();
        String orderId = orderBean.getOid();
        MpTemplateMsg template = new MpTemplateMsg();
        MpTemplateMsg.TemplateMsgData data = new MpTemplateMsg.TemplateMsgData();
        MpTemplateMsgDataValue first = new MpTemplateMsgDataValue();
        first.setValue("用户申请退款");
        MpTemplateMsgDataValue keyword1 = new MpTemplateMsgDataValue();
        keyword1.setValue(orderId);
        MpTemplateMsgDataValue keyword2 = new MpTemplateMsgDataValue();
        Double amount = orderBean.getAmount() / 100.0D;
        keyword2.setValue(amount.toString()+ " 元");
        MpTemplateMsgDataValue keyword3 = new MpTemplateMsgDataValue();
        keyword3.setValue(orderBean.getGmtPay() == null ? "" : DateUtil.convert2String(new Date(orderBean.getGmtPay()), "yyyy-MM-dd HH:mm:ss"));
        MpTemplateMsgDataValue keyword4 = new MpTemplateMsgDataValue();
        keyword4.setValue(orderBean.getUserName());
        MpTemplateMsgDataValue keyword5 = new MpTemplateMsgDataValue();
        keyword5.setValue(orderBean.getPhone());
        MpTemplateMsgDataValue remark = new MpTemplateMsgDataValue();
        remark.setValue(request.getReason()+","+request.getRemarks());
        data.setFirst(first);
        data.setKeyword1(keyword1);
        data.setKeyword2(keyword2);
        data.setKeyword3(keyword3);
        data.setKeyword4(keyword4);
        data.setKeyword5(keyword5);
        data.setRemark(remark);
        template.setData(data);
        MessagePushNewMqBody messagePushMqBody = new MessagePushNewMqBody();
        messagePushMqBody.setPartnerId(partnerId);
        messagePushMqBody.setAccessToken(accessToken);
        messagePushMqBody.setTemplate(template);
        messagePushMqBody.setStoreId(shopId);
        messagePushMqBody.setOrderId(orderId);
        messagePushMqBody.setWxappid(extInfo.getAppid());
        Header header = new Header(MQAction.INSERT.getAction(), "order-application-service-api", orderId, MessageOfficialRefundPushMqConfig.MESSAGE_PUSH_ORDER_REFUND_QUEUE);
        MQMessage<MessagePushNewMqBody> message = new MQMessage<>(header, messagePushMqBody);
        mqService.convertAndSend(MessageOfficialRefundPushMqConfig.MESSAGE_PUSH_EXCHANGE_TOPIC, MessageOfficialRefundPushMqConfig.MESSAGE_PUSH_ORDER_REFUND_QUEUE_EKY, message);
    }

    /**
     * 申请退款小票打印
     *
     * @param orderBean
     * @param orderRefundVo
     */
    private void printApplyRefundSmallTicket(OrderBean orderBean, OrderRefundVo orderRefundVo) {
        // 有云打印机 打印小票，杯贴
        try {
            List<AssortmentCloudPrinter> storePrinters = cloudPrinterManager.getStorePrinters(orderBean.getCompanyId(), orderBean.getShopId());
            if (null != storePrinters && storePrinters.size() > 0) {
                boolean printerStatus = false;
                for (AssortmentCloudPrinter cloudPrinter : storePrinters) {
                    if (null != cloudPrinter.getStatus() && cloudPrinter.getStatus() == 1) {
                        printerStatus = true;
                    }
                }
                //在线打印
                if (printerStatus) {
                    OrderPrintDto orderPrintDto = orderAdapter.convert2OrderPrintDto(orderBean);
                    String reason = orderRefundVo.getReason();
                    if (StringUtils.isNotBlank(orderRefundVo.getRemarks())) {
                        reason = reason + "," + orderRefundVo.getRemarks();
                    }
                    orderPrintDto.setRemark(reason);
                    fmAssistantCloudPrintClient.applyRefundPrint(orderPrintDto);
                }
            }
        } catch (Exception e) {
            LogUtil.error("applyRefundPrint_error", null, null, e);
        }
    }

    /**
     * 支付后通知确认返回信息
     */
    public String sendPaySuccessNoticeMessage() {
        Map<String, Object> map = Maps.newTreeMap();
        map.put("code", 0);
        map.put("message", "success");
        return gson.toJson(map);
    }


    public Map<String, OrderBean> getOrderBeanByOrderId(String orderId) {
        // 订单查询：若结果集只有一个orderBean，则为普通订单，否则为会员卡订单（父子订单）
        Map<String, OrderBean> result = new HashMap<>();
        QueryRelationOrderByIdResponseDto queryOrderByIdResponseDto = getQueryRelationOrderByIdResponseDto(orderId);
        if (CollectionUtils.isEmpty(queryOrderByIdResponseDto.getData())) {
            return result;
        }
        if (1 == queryOrderByIdResponseDto.getData().size()) {
            result.put(OrderBeanType.SAASORDER.getCode(), queryOrderByIdResponseDto.getData().get(0));
        } else {
            List<OrderBean> saasOrderBeans = queryOrderByIdResponseDto.getData().stream().filter(order -> order.getBizType().equals(1)).collect(Collectors.toList());
            List<OrderBean> memberOrderBeans = queryOrderByIdResponseDto.getData().stream().filter(order -> order.getBizType().equals(3) && !order.isParent()).collect(Collectors.toList());
            List<OrderBean> fatherOrderBeans = queryOrderByIdResponseDto.getData().stream().filter(order -> order.getBizType().equals(2) && order.isParent()).collect(Collectors.toList());
            result.put(OrderBeanType.SAASORDER.getCode(), CollectionUtils.isNotEmpty(saasOrderBeans) ? saasOrderBeans.get(0) : null);
            result.put(OrderBeanType.MERMBERORDER.getCode(), CollectionUtils.isNotEmpty(memberOrderBeans) ? memberOrderBeans.get(0) : null);
            result.put(OrderBeanType.FATHERORDER.getCode(), CollectionUtils.isNotEmpty(fatherOrderBeans) ? fatherOrderBeans.get(0) : null);
        }
        return result;
    }


    /**
     * 发送支付成功模板消息
     *
     * @param orderBean
     */
    private void sendPaySuccessMessage(QueryOrdersResponseDto.DataBean.OrderBean orderBean) {
        Long gmtExpect = orderBean.getGmtExpect();
        if (gmtExpect != null) {
            // 预约下单
            this.sendMessage(orderBean, MessageEventType.PAYORDEREXPECT);
        } else {
            // 非预约下单
            this.sendMessage(orderBean, MessageEventType.PAYORDER);
        }
    }


    /**
     * 发MQ去打印
     *
     * @param request
     */
    public void asynchronousPrint(OrderPrintDto request) {
        LogUtil.debug("OrderPrintDto", JSONObject.toJSONString(request), null);
        Header header = new Header(MQAction.INSERT.getAction(), "asynchronous-print-api", request.getOid() + "", cloudPrintQueue);
        MQMessage<OrderPrintDto> message = new MQMessage<>(header, request);
        mqService.convertAndSend(cloud_print_exchange, cloudPrintQueue, message);
    }

    /**
     * 开通会员卡
     *
     * @param partnerId 商户号
     * @param ruleId    会员规则ID
     * @param oid       订单号
     * @param userId    用户ID
     */
    private void activateMemberCard(String partnerId, String ruleId, String oid, String userId) {
        PurchasePaidRequestDto purchasePaidRequestDto = new PurchasePaidRequestDto();
        purchasePaidRequestDto.setPartnerId(partnerId);
        purchasePaidRequestDto.setOperatorType(0);
        purchasePaidRequestDto.setRuleId(ruleId);
        purchasePaidRequestDto.setOrderId(oid);
        purchasePaidRequestDto.setMemberId(userId);
        // 尝试三次开通会员卡，中途成功则跳出
        int count = 3;
        for (int i = 1; i <= count; i++) {
            BaseResponse baseResponse = customerApplicationClient.purchasePaid(purchasePaidRequestDto);
            // 不以响应码为判断是否开通会员卡成功的标准
            if (baseResponse != null && "SUCCESS".equals(baseResponse.getResult())) {
                break;
            }
            // 尝试开通会员卡失败三次
            if (i >= count) {
                LogUtil.error("尝试开通会员卡失败" + count + "次", JSON.toJSONString(purchasePaidRequestDto), JSON.toJSONString(baseResponse));
            }
        }
    }

    /**
     * 随单购月卡调会员发券与更新订单使用的优惠券与买的优惠券
     * @param orderBean
     */
    private void withOrderBuyCoupon(QueryOrdersResponseDto.DataBean.OrderBean orderBean,String sessionId){
        AssortmentCustomerInfoVo assortmentCustomerInfoVo = customerInfoManager.getCustomerInfoByObject(sessionId);
        try{
            boolean isWithOrderBuyCoupon = false;

            if(CollectionUtils.isNotEmpty(orderBean.getOrderCostDetailList())){
                for (OrderCostResp accountBean : orderBean.getOrderCostDetailList()){
                    if(accountBean.getCostType() == 10){
                        isWithOrderBuyCoupon = true;
                    }
                }
            }

            if(!isWithOrderBuyCoupon){
                return;
            }

            String notBuyCouponCode = withOrderBuyCouponCode;
            String cardId = withOrderBuyCardId;
            SendCouponForqujiaRequestDto request = new SendCouponForqujiaRequestDto();
            request.setReceivedId(orderBean.getOid());
            request.setCardIds(Arrays.asList(cardId));
            request.setThirdPartyMemberId(assortmentCustomerInfoVo.getThirdPartyMemberID());
            SendCouponForqujiaDtoResponseDto responseDto = customerExtendClient.sendCouponForqujia(request);
            if(!Objects.equals(responseDto.getCode(), ResponseResult.SUCCESS.getCode())){
                LogUtil.error("sendCouponForqujia", JSON.toJSONString(request), JSON.toJSONString(responseDto),null);
                return;
            }

            if(responseDto.getData() == null || CollectionUtils.isEmpty(responseDto.getData().getCard_list())){
                return;
            }
            String buyCouponCode = responseDto.getData().getCard_list().get(0).getCard_code();

            boolean useDiscount = false;
            if(CollectionUtils.isNotEmpty(orderBean.getProductList())){
                for (QueryOrdersResponseDto.DataBean.OrderBean.ProductBean productBean : orderBean.getProductList()){
                    if(CollectionUtils.isNotEmpty(productBean.getDiscountList())){
                        for (QueryOrdersResponseDto.DataBean.OrderBean.ProductBean.ProductDiscount discount : productBean.getDiscountList()){
                            if(notBuyCouponCode.equals(discount.getDiscountId())){
                                discount.setDiscountId(buyCouponCode);
                                useDiscount = true;
                            }
                        }
                    }
                }
            }

            UpdateCouponCodeReq req = new  UpdateCouponCodeReq();
            req.setCouponCode(buyCouponCode);
            if(useDiscount){
                req.setOldCouponCode(notBuyCouponCode);
            }
            req.setOrderCode(orderBean.getOid());

            orderSdkService.updateCostCouponCode(req,LogTreadLocal.getTrackingNo());

            List<OrderBean.AccountBean> accountList = orderBean.getAccountList().stream().filter(
                    account -> (withOrderBuyCouponCode.equals(account.getAccountId()))
            ).collect(Collectors.toList());

            if(CollectionUtils.isNotEmpty(accountList)) {
                accountList.forEach(o -> o.setAccountId(buyCouponCode));
            }
        } catch (Exception e){
            LogUtil.error("买券异常", null, null, e);
        }
    }

}
