package cn.freemud.order.entity;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;


@Data
@Table(name = "open_platform_partner")
public class OpenPlatformPartner implements Serializable {
    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 品牌ID
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * 认证状态（1：微信认证）
     */
    private Integer status;

    /**
     * 开放平台appid
     */
    @Column(name = "open_appid")
    private String openAppid;

    /**
     * 品牌名称
     */
    @Column(name = "partner_name")
    private String partnerName;

    /**
     * 主体名称
     */
    @Column(name = "subject_name")
    private String subjectName;

    /**
     * 品牌logo
     */
    @Column(name = "partner_logo")
    private String partnerLogo;

    /**
     * 公司名称
     */
    @Column(name = "company_name")
    private String companyName;

    /**
     * 创建人
     */
    @Column(name = "create_name")
    private String createName;

    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;
}