
package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;

@Data
@ApiModel
public class QueryOrderByConditionsRequestVo {
    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;
    @NotNull(message = "业务类型 不能为空")
    @ApiModelProperty(value = "业务类型 1:普通订单 2:虚拟订单 3:会员订单 4:积分商城订单 5:储值卡订单 6:卖券订单 98:农工商停车手工录单 99:农工商停车订单")
    private Integer bizType;
    @NotNull(message = "页码 不能为空")
    private int pageNum;
    @NotNull(message = "分页大小 不能为空")
    private int pageSize;
    @NotEmpty(message = "商户号 不能为空")
    private String partnerId;
    @ApiModelProperty(value = "开始时间")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private String startDate;
    @ApiModelProperty(value = "结束时间")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private String endDate;

}
