package cn.freemud.service.thirdparty;

import cn.freemud.annotations.LogIgnoreFeign;
import cn.freemud.entities.dto.order.McCafePushOrderDto;
import cn.freemud.entities.dto.McCafePushOrderResponseDto;
import feign.Headers;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "MCD-ORDER-DATA-PUSH-SERVICE", url = "${mccafe.push.order.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface McCafePushOrderClient {


    @LogIgnoreFeign(logMessage="mcCafePushOrder")
    @PostMapping(value="/mp/order",headers={"ContentType=application/json","Provider=WX","Version=1.0"})
    @Headers(value={"ContentType=application/json","Provider=WX","Version=1.0"})
    McCafePushOrderResponseDto mcCafePushOrder(@RequestBody McCafePushOrderDto mcCafePushOrderDto);
}
