/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/10 16:06
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.annotations.LogIgnoreFeign;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.coupon.CouponAvailableReqVo;
import cn.freemud.entities.coupon.CouponAvailableRespDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;


@FeignClient(name = "OPEN-STORE-COUPON-ADAPTER-SERVICE", url = "${saas.couponadapterclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CouponAdapterClient {

    /**
     * 获取可用券信息
     *
     * @param couponAvailableReqVo
     * @return
     */
    @LogIgnoreFeign(logMessage="getCouponsAvailable",statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE_result)
    @PostMapping("/getCouponsAvailable")
    CouponAvailableRespDto getCouponsAvailable(CouponAvailableReqVo couponAvailableReqVo);

}
