package cn.freemud.aop;

import cn.freemud.base.entity.BaseResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Optional;

/**
 * 判断返回message是否转换为英文
 *
 * @author wanghanghang
 * @date 2021/04/01
 */
@Aspect
@Component
public class IsConvertEnAspect implements Ordered {
    @Pointcut("@annotation(cn.freemud.annotations.IsConvertEN)")
    public void pointcut() {
    }

    @Around("pointcut()")
    public Object convertMessage(ProceedingJoinPoint joinPoint) throws Throwable {
        HttpServletRequest request = currentRequest();
        String language = request.getHeader("lang");
        BaseResponse baseResponse = (BaseResponse) joinPoint.proceed();
        //表示返回英文提示 本次变更3个提示 手动直接转换
        if ("en-US".equals(language)) {
            switch (baseResponse.getCode()) {
                case "44013":
                    //购物车商品有变动，请手动刷新再修改
                    baseResponse.setMessage("Shopping cart items have changed, please refresh and modify manually");
                    break;
                case "44014":
                    //没有绑定桌号，无法加入购物车
                    baseResponse.setMessage("There is no binding table number, unable to join the shopping cart");
                    break;
                case "44003":
                    //添加购物车失败
                    baseResponse.setMessage("Failed to add shopping cart");
                    break;
                case "43005":
                    //门店商品校验失败
                    baseResponse.setMessage("Store product verification failed");
                    break;
                case "43003":
                    //门店商品信息不存在
                    baseResponse.setMessage("Store product information does not exist");
                    break;
            }
        }
        return baseResponse;
    }


    private HttpServletRequest currentRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        return Optional.ofNullable(servletRequestAttributes).map(ServletRequestAttributes::getRequest).orElse(null);
    }


    /**
     * 备用方法，避免code或者message信息不统一
     * 过滤返参code是否在excludeStatusCodes存在
     *
     * @param excludeStatusCodes
     * @param statusCodeValue
     * @return
     */
    private boolean containStatusCode(String[] excludeStatusCodes, String statusCodeValue) {
        if (excludeStatusCodes == null || excludeStatusCodes.length == 0) {
            return false;
        }
        for (int i = 0; i < excludeStatusCodes.length; i++) {
            if (excludeStatusCodes[i].equals(statusCodeValue)) {
                return true;
            }
        }
        return false;
    }


    @Override
    public int getOrder() {
        return 0;
    }
}
