package cn.freemud.service.thirdparty;

import cn.freemud.annotations.IgnoreFeignLogAnnotation;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.BatchQueryActivityInfoRequestDto;
import cn.freemud.entities.dto.BatchQueryActivityInfoResponseDto;
import cn.freemud.entities.dto.GetAppKeyRequestDto;
import cn.freemud.entities.dto.GetAppKeyResponseDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

//测试环境：http://115.159.65.101:8082 生产环境：https://onlinecoupon.sandload.cn
@FeignClient(name = "OPEN-STORE-ONLINE-COUPON-SERVICE",url="${saas.cardbinclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CardBinClient {
    /**
     * 获取密钥
     * @param requestDto
     * @return
     */
    @PostMapping("/getAppKey")
    @IgnoreFeignLogAnnotation(logMessage = "getAppKey",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MEG)
    GetAppKeyResponseDto getAppKey(GetAppKeyRequestDto requestDto);

    /**
     * 活动信息批量查询    疑似黑白名单接口但是出参没有商品信息
     * @param requestDto
     * @return
     */
    @PostMapping(value = "/batchQueryActivityInfo")
    @IgnoreFeignLogAnnotation(logMessage = "batchQueryActivityInfo",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MEG)
    BatchQueryActivityInfoResponseDto batchQueryActivityInfo(BatchQueryActivityInfoRequestDto requestDto);


}
