package cn.freemud.entities.dto.store;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: GetStoreListbyCodesRequest
 * @Package cn.freemud.console.domain.request
 * @Description:
 * @author: hangw
 * @date: 12/18 0018 11:14
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class GetStoreListbyCodesRequest {
    @NotBlank
    @ApiModelProperty("商户编号")
    private String partnerId;
    @NotBlank
    @ApiModelProperty("门店codes,多个逗号隔开")
    private String storeCodes;
    @ApiModelProperty("经度")
    private String longitude;
    @ApiModelProperty("纬度")
    private String latitude;
    @ApiModelProperty("城市")
    private String city;

    @ApiModelProperty(value = "页码")
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示条数")
    private Integer pageSize;
    @ApiModelProperty(value = "activeFlag")
    private Integer activeFlag;
    @ApiModelProperty("微信appid")
    private String	wxAppid;
    @ApiModelProperty("距离（单位：km）")
    private String distance;
}
