
package cn.freemud.service.thirdparty;
import cn.freemud.entities.dto.GetSvcInfoByMemberIdResponse;
import cn.freemud.entities.dto.StatisticalPropertyRequest;
import com.freemud.application.sdk.api.base.BaseResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * @author yuanyuan.jing
 */
@FeignClient(name = "customer-property-service", url = "${customer.property.service.url:}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CustomerPropertyClient {



    @PostMapping(value = "/propertyservice/card/getMemberCards")
    BaseResponse<List<GetSvcInfoByMemberIdResponse>> getMemberCards(@RequestBody StatisticalPropertyRequest statisticalPropertyRequest);
}
