package cn.freemud.controller;

import cn.freemud.ShoppingCartApplication;
import cn.freemud.entities.vo.GetMenuCategoryVo;
import cn.freemud.entities.vo.GetProductValidateVo;
import cn.freemud.entities.vo.GetProductVo;
import com.alibaba.fastjson.JSONObject;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ItemController
 * @Package cn.freemud.controller
 * @Description: 测试类
 * @author: zhenghuan.yang
 * @date: 2018/6/22 17:06
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = ShoppingCartApplication.class)
public class ItemControllerTest {
    @Autowired
    private WebApplicationContext wac;
    private MockMvc mockMvc;

    @Before
    public void setUp() {
        mockMvc = MockMvcBuilders.webAppContextSetup(wac).build();
    }

    /**
     * 获取商品分类和商品信息
     */
    @Test
    public void getMenuCategory () {
        GetMenuCategoryVo request = new GetMenuCategoryVo();
        request.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        request.setShopId("1036");
        request.setChannelType("beiguo");
        request.setInfoLevel(1);
        String str = JSONObject.toJSONString(request);
        try {
            mockMvc.perform(post("/item/getMenuCategory").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * 获取分类的具体商品
     */
    @Test
    public void getProducts () {
        GetProductVo request = new GetProductVo();
        request.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        request.setShopId("1036");
        request.setMenuId("107000624750526977");
        request.setNodeId("0102");
        String str = JSONObject.toJSONString(request);
        try {
            mockMvc.perform(post("/item/getProducts").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * 校验商品是否有效
     */
    @Test
    public void checkProductValidate () {
        GetProductValidateVo request = new GetProductValidateVo();
        String str = JSONObject.toJSONString(request);
        try {
            mockMvc.perform(post("/item/checkProductValidate").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
