/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartAddRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/21 19:52
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@NoArgsConstructor
public class ShoppingCartSkuAddRequestVo {

    @NotEmpty(message = "sessionId不能为空")
    private String sessionId;

    @NotEmpty(message = "partnerId不能为空")
    private String partnerId;

    @NotEmpty(message = "shopId不能为空")
    private String shopId;

    private String nickName;
    /**
     * 用户头像
     */
    private String avatarUrl;
    /**
     * 检测是否需要校验   1 需要  0 不需要 默认是1
     */
    private Integer nickNameCheck;

    @Valid
    private List<ShoppingCartSkuProductVo> products;


    @Data
    @NoArgsConstructor
    public static class ShoppingCartSkuProductVo {

        private String productId;
        /**
         * spuId 商品原始id
         */
        private String spuId;

        /**
         * skuId 如果是多规格 skuId 不能为空
         */
        private String skuId;

        /**
         * 商品名称
         */
        private String productName;

        @NotNull(message = "商品数量不能为空")
        private Integer qty;

        /**
         * sku 状态
         */
        private Integer status;

        /**
         * sku 状态描述
         */
        private String statusDesc;


        @Valid
        private List<AttributeVo> extra;


        @Data
        @NoArgsConstructor
        public static class AttributeVo {

            /**
             * 属性ID
             */
            private String attributeId;

            /**
             * 属性名称
             */
            private String attributeName;

            /**
             * 兼容之前参数
             */
            private String productId;

            private String productName;

            private String groupId;

            private Integer qty;

            private Integer status;

            private String statusDesc;

        }

    }


}
