package cn.freemud.aop;

import org.springframework.stereotype.Component;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ThreadLocalMap
 * @Package cn.freemud.aop
 * @Description: 保存起始时间
 * @author: zhenghuan.yang
 * @date: 2018/5/28 8:58
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class ThreadLocalMap {
    private final ThreadLocal<Long> threadLocalControl = new ThreadLocal();
    private final ThreadLocal<Long> threadLocalClient = new ThreadLocal();

    public long setControlStartTime() {
        long startTime = System.currentTimeMillis();
        this.threadLocalControl.set(startTime);
        return startTime;
    }

    public long getControlStartTime() {
        long startTime = this.threadLocalControl.get();
        threadLocalControl.remove();
        return startTime;
    }

    public long setClientStartTime() {
        long startTime = System.currentTimeMillis();
        this.threadLocalClient.set(startTime);
        return startTime;
    }

    public long getClientStartTime() {
        long startTime = this.threadLocalClient.get();
        threadLocalClient.remove();
        return startTime;
    }
}
