package cn.freemud.order.test;

import cn.freemud.amp.body.OrderBody;
import cn.freemud.consumer.PushOrderApplication;
import cn.freemud.service.SendExperienceHandleServiceImpl;
import com.freemud.application.sdk.api.membercenter.request.GradeRight;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.card.sdk.vo.coupon.Active;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.List;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = PushOrderApplication.class)
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
@Slf4j
public class SendExperienceHandleServiceTest {

    @Autowired
    private SendExperienceHandleServiceImpl sendExperience;

    @Test
    public void upGradeTest() {
        OrderInfoReqs orderBean = new OrderInfoReqs();
        orderBean.setPartnerId("23423");
        orderBean.setOrderCode("3242");
        List<GradeRight> gradeRightList = new ArrayList<>();
        GradeRight gradeRight = new GradeRight();
        gradeRight.setActivityCode("123");
        gradeRight.setCouponName("342323");
        gradeRight.setCouponNum(1);
        gradeRight.setCouponType(2);
        gradeRight.setScoreValue("12");
        gradeRightList.add(gradeRight);
        String ruleCode = "324234";

        boolean result = sendExperience.sendCoupon(orderBean, gradeRightList, ruleCode);
        log.info("单元测试:{}", result);
        Assert.assertTrue(result);
    }

    @Test
    public void sendCouponTest() {

        OrderInfoReqs orderBody = new OrderInfoReqs();
        List<GradeRight> gradeRightList = new ArrayList<>();
        String promotionActiveCode = "186437659341";
        GradeRight gradeRight = new GradeRight();
        gradeRight.setActivityCode("V1556453409386700");
        gradeRight.setCouponName("代金券shz");
        gradeRight.setCouponNum(1);
        gradeRight.setCouponType(1);
        gradeRight.setRightType(2);
        gradeRightList.add(gradeRight);
        OrderBody.OrderBean orderBean = new OrderBody.OrderBean();

        orderBean.setOid("143043109237823762");
        orderBean.setCompanyId("1864");
        orderBean.setUserId("115469445255820774");

        Assert.assertTrue(sendExperience.sendCoupon(orderBody, gradeRightList, promotionActiveCode));
    }

    @Test
    public void buildCreateCouponTest() {

        OrderInfoReqs orderBody = new OrderInfoReqs();
        List<GradeRight> gradeRightList = new ArrayList<>();
        String promotionActiveCode = "186437659341";
        GradeRight gradeRight = new GradeRight();
        gradeRight.setActivityCode("V1556453409386700");
        gradeRight.setCouponName("代金券shz");
        gradeRight.setCouponNum(1);
        gradeRight.setCouponType(1);
        gradeRight.setRightType(2);
        gradeRightList.add(gradeRight);
        OrderBody.OrderBean orderBean = new OrderBody.OrderBean();
        orderBean.setOid("143043109237823762");
        orderBean.setCompanyId("1864");
        orderBean.setUserId("115469445255820774");
        Active active = new Active();
        active.setStartDate("2019-04-30 23:59:59");
        active.setEndDate("2019-04-30 23:59:59");
        sendExperience.buildCreateCoupons(active, orderBody, gradeRight, promotionActiveCode);

    }

}
