package cn.freemud.order.test;

import cn.freemud.constant.ServiceConstants;
import cn.freemud.consumer.PushOrderApplication;
import com.freemud.application.sdk.api.base.BaseResponse;
import com.freemud.application.sdk.api.membercenter.request.SendScoreRequest;
import com.freemud.application.sdk.api.membercenter.service.MemberPropertyService;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = PushOrderApplication.class)
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
@Slf4j
public class MemberPropertyServiceTest {
    @Autowired
    private MemberPropertyService memberPropertyService;

    @Test
    public void sendScoreTest() {
        SendScoreRequest sendScoreRequest = new SendScoreRequest();
        String trackingNo = "ba00c5c113644c918d83f2c16470a843";
        sendScoreRequest.setPartnerId("1864");
        sendScoreRequest.setMemberId("115469445255820774");
         sendScoreRequest.setScore(String.valueOf(100/100));
        sendScoreRequest.setOperationType(ServiceConstants.SCORE_OPERATION_TYPE_5);
         sendScoreRequest.setIdempotencyBussinessId("143109803637479715");
        sendScoreRequest.setIdempotencyBussinessType("3");
         BaseResponse baseResponse = memberPropertyService.sendScore(sendScoreRequest,trackingNo);
        log.info("单元测试:{}", baseResponse);
        Assert.assertEquals(baseResponse.getCode(), "100");
    }


}
