package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.BatchQueryActivityInfoRequestDto;
import cn.freemud.entities.dto.BatchQueryActivityInfoResponseDto;
import cn.freemud.entities.dto.GetAppKeyRequestDto;
import cn.freemud.entities.dto.GetAppKeyResponseDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

//测试环境：http://115.159.65.101:8082 生产环境：https://onlinecoupon.sandload.cn
@FeignClient(name = "CARDBINCLIENT",url="${saas.cardbinclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CardBinClient {
    /**
     * 获取密钥
     * @param requestDto
     * @return
     */
    @PostMapping("/getAppKey")
    GetAppKeyResponseDto getAppKey(GetAppKeyRequestDto requestDto);


    /**
     * 活动信息批量查询
     * @param requestDto
     * @return
     */
    @PostMapping(value = "/batchQueryActivityInfo")
    BatchQueryActivityInfoResponseDto batchQueryActivityInfo(BatchQueryActivityInfoRequestDto requestDto);


}
