package cn.freemud.order.entity;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

@Table(name = "order_push_log")
public class OrderPushLog implements Serializable {
    @Id
    private Long id;

    /**
     * 订单id
     */
    @Column(name = "order_id")
    private String orderId;

    /**
     * 追溯id
     */
    @Column(name = "trace_id")
    private String traceId;

    /**
     * 推单时间
     */
    @Column(name = "push_date")
    private Date pushDate;

    /**
     * 请求报文
     */
    @Column(name = "request_body")
    private String requestBody;

    /**
     * 推单失败原因
     */
    @Column(name = "failure_reasons")
    private String failureReasons;

    /**
     * 平台标识
     */
    @Column(name = "platform_sign")
    private String platformSign;

    @Column(name = "partner_id")
    private String partnerId;

    @Column(name = "platform_partner_id")
    private String platformPartnerId;

    @Column(name = "platform_store_id")
    private String platformStoreId;

    @Column(name = "business")
    private String business;

    private static final long serialVersionUID = 1L;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取订单id
     *
     * @return order_id - 订单id
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * 设置订单id
     *
     * @param orderId 订单id
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId == null ? null : orderId.trim();
    }

    /**
     * 获取追溯id
     *
     * @return trace_id - 追溯id
     */
    public String getTraceId() {
        return traceId;
    }

    /**
     * 设置追溯id
     *
     * @param traceId 追溯id
     */
    public void setTraceId(String traceId) {
        this.traceId = traceId == null ? null : traceId.trim();
    }

    /**
     * 获取推单时间
     *
     * @return push_date - 推单时间
     */
    public Date getPushDate() {
        return pushDate;
    }

    /**
     * 设置推单时间
     *
     * @param pushDate 推单时间
     */
    public void setPushDate(Date pushDate) {
        this.pushDate = pushDate;
    }

    /**
     * 获取请求报文
     *
     * @return request_body - 请求报文
     */
    public String getRequestBody() {
        return requestBody;
    }

    /**
     * 设置请求报文
     *
     * @param requestBody 请求报文
     */
    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody == null ? null : requestBody.trim();
    }

    /**
     * 获取推单失败原因
     *
     * @return failure_reasons - 推单失败原因
     */
    public String getFailureReasons() {
        return failureReasons;
    }

    /**
     * 设置推单失败原因
     *
     * @param failureReasons 推单失败原因
     */
    public void setFailureReasons(String failureReasons) {
        this.failureReasons = failureReasons == null ? null : failureReasons.trim();
    }

    /**
     * 获取平台标识
     *
     * @return platform_sign - 平台标识
     */
    public String getPlatformSign() {
        return platformSign;
    }

    /**
     * 设置平台标识
     *
     * @param platformSign 平台标识
     */
    public void setPlatformSign(String platformSign) {
        this.platformSign = platformSign == null ? null : platformSign.trim();
    }

    /**
     * @return partner_id
     */
    public String getPartnerId() {
        return partnerId;
    }

    /**
     * @param partnerId
     */
    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId == null ? null : partnerId.trim();
    }

    /**
     * @return platform_partner_id
     */
    public String getPlatformPartnerId() {
        return platformPartnerId;
    }

    /**
     * @param platformPartnerId
     */
    public void setPlatformPartnerId(String platformPartnerId) {
        this.platformPartnerId = platformPartnerId == null ? null : platformPartnerId.trim();
    }

    /**
     * @return platform_store_id
     */
    public String getPlatformStoreId() {
        return platformStoreId;
    }

    /**
     * @param platformStoreId
     */
    public void setPlatformStoreId(String platformStoreId) {
        this.platformStoreId = platformStoreId == null ? null : platformStoreId.trim();
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", orderId=").append(orderId);
        sb.append(", traceId=").append(traceId);
        sb.append(", pushDate=").append(pushDate);
        sb.append(", requestBody=").append(requestBody);
        sb.append(", failureReasons=").append(failureReasons);
        sb.append(", platformSign=").append(platformSign);
        sb.append(", partnerId=").append(partnerId);
        sb.append(", platformPartnerId=").append(platformPartnerId);
        sb.append(", platformStoreId=").append(platformStoreId);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}