package cn.freemud.order.entity;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

@Data
@Table(name = "open_platform_parntner_payment_config")
public class OpenPlatformPartnerPaymentConfig {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 开个店商户号
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * 支付渠道商户号
     */
    @Column(name = "sub_mchid")
    private String subMchid;

    /**
     * 关联应用id
     */
    @Column(name = "app_id")
    private String appId;

    /**
     * 上报类型，1:预支付，2：支付完成
     */
    @Column(name = "report_type")
    private Byte reportType;

    /**
     * 状态，0:不可用，1：可用
     */
    @Column(name = "status")
    private Byte status;

    @Column(name = "auth_id")
    private Long authId;

    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_updated")
    private Date gmtModified;
}