package cn.freemud.consumer;

import cn.freemud.amp.PushOrderConfig;
import cn.freemud.core.db.DataSourcesConfig;
import cn.freemud.platform.sdk.hualala.HualalaConfig;
import com.freemud.application.sdk.api.log.ApiLog;
import com.freemud.application.sdk.api.log.ApiLogAop;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;

import java.net.Proxy;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.mail.core
 * @Description: ${TODO}(用一句话描述该文件做什么)
 * @author: aiqi.gong
 * @date: 2019/3/21 14:01
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@ImportAutoConfiguration(value = {PushOrderConfig.class, HualalaConfig.class, DataSourcesConfig.class})
@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class })
@MapperScan({"cn.freemud.order.mapper", "cn.freemud.manager.dao"})
@ComponentScan(value = {"cn.freemud.*", "com.freemud.*"},excludeFilters =@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE,
        classes = {ApiLogAop.class}))
@EnableFeignClients(value = "cn.freemud.*")
@EnableDiscoveryClient
public class PushOrderApplication {
    public static void main(String[] args) {
        SpringApplication.run(PushOrderApplication.class, args);
    }


}
