package cn.freemud.config;

import cn.freemud.annotations.OrderReportType;
import cn.freemud.enums.OrderReportEnum;
import cn.freemud.service.SynchronizedOrderService;
import cn.freemud.util.SpringBeanUtil;
import com.google.common.collect.Maps;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
@DependsOn("springBeanUtil")
public class OrderReportFactory {

    private static Map<OrderReportEnum, SynchronizedOrderService> userRelatedMap = Maps.newConcurrentMap();


    public OrderReportFactory(){
        ApplicationContext context = SpringBeanUtil.getContext();
        Map<String, Object> beanMap = context.getBeansWithAnnotation(OrderReportType.class);

        for(Object categoryService : beanMap.values()) {
            OrderReportType annotation = categoryService.getClass().getAnnotation(OrderReportType.class);
            userRelatedMap.put(annotation.value(), (SynchronizedOrderService)categoryService);
        }
    }

    public static SynchronizedOrderService getSynchronizedOrderService(OrderReportEnum orderReportEnum) {
        return userRelatedMap.get(orderReportEnum);
    }

}
