package cn.freemud.central.service.response;

import cn.freemud.base.constant.Version;
import cn.freemud.central.service.constant.FmStatusCode;

public class BaseResponse<T> {
    /**
     * 版本号
     */
    protected String ver = Version.VERSION_1;
    /**
     * 响应状态码
     */

    protected int statusCode = FmStatusCode.SUCCESS.getStatusCode();
    /**
     * 返回信息
     */
    protected String msg = FmStatusCode.SUCCESS.getMessage();
    protected T data;

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public BaseResponse() {
    }

    public BaseResponse(T data) {
        this.data = data;
    }

    public BaseResponse(String ver, FmStatusCode fmStatusCode) {
        this.ver = ver;
        this.statusCode = fmStatusCode.getStatusCode();
        this.msg = fmStatusCode.getMessage();
    }

    public BaseResponse(FmStatusCode fmStatusCode) {
        this.ver = Version.VERSION_1;
        this.statusCode = fmStatusCode.getStatusCode();
        this.msg = fmStatusCode.getMessage();
    }

    public BaseResponse(String ver, int statusCode, String msg) {
        this.ver = ver;
        this.statusCode = statusCode;
        this.msg = msg;
    }

    public BaseResponse(int statusCode, String msg) {
        this.statusCode = statusCode;
        this.msg = msg;
    }

    public BaseResponse(String ver, FmStatusCode fmStatusCode, String msg) {
        this.ver = ver;
        this.statusCode = fmStatusCode.getStatusCode();
        this.msg = fmStatusCode.getMessage() + "(" + msg + ")";
    }

    public BaseResponse(FmStatusCode fmStatusCode, String msg) {
        this.ver = Version.VERSION_1;
        this.statusCode = fmStatusCode.getStatusCode();
        this.msg = fmStatusCode.getMessage() + "(" + msg + ")";
    }

    public BaseResponse(String msg) {
        this.msg = msg;
    }

    public String getVer() {
        return ver;
    }

    public void setVer(String ver) {
        this.ver = ver;
    }

    public int getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}