package cn.freemud.central.service.constant;

public enum FmStatusCode {
    COUPON_NORMAL(10, "该券正常"),
    COUPON_EXISTORNOTSTART(11, "优惠券不存在或者活动未开始"),
    COUPON_EXPIRED(12, "优惠券已过期"),
    STATUS_RECOVERY(14, "优惠券已经核销或者不存在"),
    STATUS_CODE_15(15, "优惠券未激活"),
    STATUS_CODE_16(16, "该优惠券不能和其它优惠券混合使用"),
    COUPON_DOES_NOT_EXISTS_POS(18,"该pos不能核销此码"),
    STATUS_CODE_21(21, "参数错误"),
    STATUS_CODE_31(31, "商品不匹配或核销数量超出可用数量"),
    STATUS_CODE_32(32, "优惠券必须一次性核销"),
    TRANS_NOT_EXIST(41, "交易不存在"),
    STATUS_CODE_51(51, "该门店不适用此券"),
    STATUS_CODE_52(52, "商品类别不能使用优惠券"),
    MAX_REDEEM_TIMES(53,"超出使用次数受限"),
    TIME_REDEEM_LIMIT(54,"券码使用间隔受限"),
    DAILY_REDEEM_LIMIT(55,"每日核销次数受限"),
    SUCCESS(100, "成功"),
    STATUS_CODE_101(101, "部分凭证码核销失败"),
    STATUS_CODE_201(201, "支付账号不存在"),
    STATUS_CODE_202(202, "账户异常"),
    STATUS_CODE_203(203, "账号余额不足"),
    STATUS_CODE_204(204, "交易超时或者支付平台异常"),
    STATUS_CODE_205(205, "条码无效"),
    STATUS_CODE_206(206, "退款金额高于支付金额"),
    STATUS_CODE_207(207, "操作不支持"),
    STATUS_CODE_500(500, "系统错误"),
    STATUS_CODE_505(505, "未知返回码"),
    STATUS_CODE_506(506, "验证失败");

    FmStatusCode(int statusCode, String message) {
        this.statusCode = statusCode;
        this.message = message;
    }

    private int statusCode;
    private String message;

    public int getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static FmStatusCode getInfoByCode(int code) {
        for (FmStatusCode fmStatusCode : values()) {
            if (code == fmStatusCode.getStatusCode()) {
                return fmStatusCode;
            }
        }
        return null;
    }
}