package cn.freemud.platform.sdk.hualala;

import cn.freemud.platform.sdk.common.service.CloudService;
import cn.freemud.platform.sdk.common.util.AesCBCNoPaddingUtil;
import cn.freemud.platform.sdk.common.util.HualalaSignUtil;
import cn.freemud.platform.sdk.hualala.request.*;
import cn.freemud.platform.sdk.hualala.response.GetPaySubjectResponse;
import cn.freemud.platform.sdk.hualala.response.SubmitOrderNewResponse;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.mail.core
 * @Description: ${TODO}(用一句话描述该文件做什么)
 * @author: aiqi.gong
 * @date: 2019/3/19 10:44
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

@Slf4j
public class HualalaSdkService {
    @Autowired
    private CloudService cloudService;
    private Logger logger = LoggerFactory.getLogger(getClass());

    public HualalaSdkService(CloudService cloudService) {
        this.cloudService = cloudService;
    }

    public SubmitOrderNewResponse submitOrder(String trackingNo, HualalaBaseConfig baseConfig, HuaLaLaCommonRequest requestHeader, SubmitOrderNewRequest requestBody) {
        //根据版本区分requestBody
        Object finalRequest = requestBody;
        if (requestHeader.getVersion() > 1L) {
            SubmitOrderNewV2Request requestV2Body = new SubmitOrderNewV2Request();
            BeanUtils.copyProperties(requestBody, requestV2Body);
            requestV2Body.setGroupID(requestHeader.getGroupID());
            requestV2Body.setShopID(requestHeader.getShopID());
            finalRequest = requestV2Body;
        }
        String sign = null;
        try {
            sign = HualalaSignUtil.getSignature(requestHeader, finalRequest, baseConfig.getDevPwd(), "下单签名");
        } catch (Exception e) {
            e.printStackTrace();
        }
        String body = getRequestBodyStr(finalRequest, baseConfig.getMerchantSecret());
        requestHeader.setRequestBody(body);
        requestHeader.setSignature(sign);
        logger.info("桂源铺推送哗啦啦请求体：{} trackingNo:{}，orderCode：{}，requestHeader：{}",
                JSONObject.toJSONString(finalRequest), trackingNo, requestBody.getThirdOrderID(), JSONObject.toJSONString(requestHeader));
        SubmitOrderNewResponse submitOrderNewResponse = cloudService.doSend(trackingNo, "https://www-openapi.hualala.com/order/submitordernew", requestHeader, SubmitOrderNewResponse.class);
        logger.info("桂源铺推送哗啦啦响应体：{} trackingNo:{}，orderCode：{}", JSONObject.toJSONString(submitOrderNewResponse), trackingNo, requestBody.getThirdOrderID());
        return submitOrderNewResponse;
    }

    public GetPaySubjectResponse getPaySubject(String trackingNo, HuaLaLaCommonRequest requestHeader, GetPaySubjectRequest requestBody) {
        String sign = null;
        try {
            sign = HualalaSignUtil.getSignature(requestHeader, requestBody, "nI83qiNK", "下单签名");
        } catch (Exception e) {
            e.printStackTrace();
        }
        String body = getRequestBodyStr(requestBody, "i28cUu3v");
        requestHeader.setRequestBody(body);
        requestHeader.setSignature(sign);
        logger.info("requestBody:{} trackingNo:{}", JSONObject.toJSONString(requestBody), trackingNo);
        GetPaySubjectResponse submitOrderNewResponse = cloudService.doSend(trackingNo, "https://www-openapi.hualala.com/doc/getPaySubject", requestHeader, GetPaySubjectResponse.class);
        return submitOrderNewResponse;
    }

    private static <T> String getRequestBodyStr(T requestBody, String merchantAppSecret) {
        String reqString = JSONObject.toJSONString(requestBody);
        String key = merchantAppSecret + merchantAppSecret;
        return AesCBCNoPaddingUtil.encrypt(reqString, key, key);
    }

}
