package cn.freemud.controller;

import cn.freemud.OrderApplication;
import cn.freemud.entities.vo.*;
import com.alibaba.fastjson.JSONObject;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: UserControllerTest
 * @Package cn.freemud.controller
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/6/25 19:13
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = OrderApplication.class)
public class UserControllerTest {
    @Autowired
    private WebApplicationContext wac;
    private MockMvc mockMvc;

    @Before
    public void setUp() {
        mockMvc = MockMvcBuilders.webAppContextSetup(wac).build();
    }
    /**
     * 获取用户会话sessionId
     */
    @Test
    public void getSessionid () {
        GetUserLoginSessionIdVo getUserLoginSessionIdVo = new GetUserLoginSessionIdVo();
        getUserLoginSessionIdVo.setAppId("wx2eba2ce69704a6c7");
        getUserLoginSessionIdVo.setCode("011tVzeT1nUFy61nFGiT1AoIeT1tVzee");
        getUserLoginSessionIdVo.setPartnerId("360bb48b-5316-458a-903e-9a44c7f339b1");
        String str = JSONObject.toJSONString(getUserLoginSessionIdVo);
        try {
            mockMvc.perform(post("/user/getSessionId").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取用户手机号一键授权登陆
     */
    @Test
    public void getPhoneNumber () {
        GetPhoneNumberVo getPhoneNumberVo = new GetPhoneNumberVo();
        getPhoneNumberVo.setEncryptedData("322432423asfs");
        getPhoneNumberVo.setIv("sfddsf");
        getPhoneNumberVo.setSessionId("0090381c894ac949e413d0e0bc8aac28e734fb8b");
        String str = JSONObject.toJSONString(getPhoneNumberVo);
        try {
            mockMvc.perform(post("/user/getMobile").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * 发送验证码
     */
    @Test
    public void sendSmsCode () {
        SendSmsCodeVo sendSmsCodeVo = new SendSmsCodeVo();
        sendSmsCodeVo.setMobile("13656899654");
        sendSmsCodeVo.setSessionId("0090381c894ac949e413d0e0bc8aac28e734fb8b");
        String str = JSONObject.toJSONString(sendSmsCodeVo);
        try {
            mockMvc.perform(post("/user/sendSmsCode").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * 用户通过手机号注册
     */
    @Test
    public void registerByMobile () {
        RegisterByMobileVo registerByMobileVo = new RegisterByMobileVo();
        registerByMobileVo.setMobile("12365899658");
        registerByMobileVo.setSessionId("0090381c894ac949e413d0e0bc8aac28e734fb8b");
        registerByMobileVo.setSmsCode("156325");
        String str = JSONObject.toJSONString(registerByMobileVo);
        try {
            mockMvc.perform(post("/user/registerByMobile").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * 用户修改手机号
     */
    @Test
    public void editMobile () {
        EditMobileVo editMobileVo = new EditMobileVo();
        editMobileVo.setMobile("16895896456");
        editMobileVo.setSessionId("0090381c894ac949e413d0e0bc8aac28e734fb8b");
        editMobileVo.setSmsCode("123658");
        String str = JSONObject.toJSONString(editMobileVo);
        try {
            mockMvc.perform(post("/user/editMobile").content(str).
                    contentType(MediaType.APPLICATION_JSON_UTF8).accept(MediaType.APPLICATION_JSON_UTF8)).andDo(print()).
                    andExpect(jsonPath("$.code").value("100"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
