package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.RecommendProductRequestDto;
import cn.freemud.entities.dto.RecommendProductResponseDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: RecommendClient
 * @Package cn.freemud.service.thirdparty
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/9/27 16:23
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
//测试：http://115.159.187.179:9966 //生产:  http://10.10.3.41:9966
@FeignClient(value = "RECOMMEND-SERVICE",url="${saas.recommendclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface RecommendClient {
    /**
     * 商品推荐接口
     */
    @PostMapping(value = "/rec/product/recommend")
    RecommendProductResponseDto recommendProduct(@RequestBody RecommendProductRequestDto dto);
}
