/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: UserRegisterResponse
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/24 11:12
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@NoArgsConstructor
@Data
public class UserRegisterResponse  {

    /**
     * code : 100
     * message :
     * result : {"account":"13914748165","memberId":"72057594039927937"}
     * ver : 1
     */
    /**
     *  返回100 请求成功
     */
    private String code;

    private String message;

    private ResultBean result;

    private String ver;


    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @NoArgsConstructor
    @Data
    public static class ResultBean {
        /**
         * account : 13914748165
         * memberId : 72057594039927937
         */

        /**
         * 用户手机号
         */
        private String account;
        /**
         * 会员信息
         */
        private String memberId;
    }
}
