/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: StoreResponseDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/28 19:22
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import cn.freemud.entities.db.OpenPlatformPartnerStoreDeliveryConfig;
import lombok.Data;

import java.util.Date;


@Data
public class StoreResponseDto {

    /* 组织编号 */
    private String storeId;
    /* 组织编码，用于标识父子逻辑关系、排序 */
    private String storeCode;
    /* 名称 */
    private String storeName;
    /* 合作伙伴编号 商户编号*/
    private String parentId;
    /* 商户编码 */
    private String parentCode;
    /* 商户编码 商户名称*/
    private String parentName;
    /* 父编码 */
    private String partnerId;
    /* 简称 */
    private String briefName;
    /* 经度 */
    private String longitude;
    /* 纬度 */
    private String latitude;
    /* 营业时间（格式：9:00~20:00） */
    private String businessHours;
    /* 营业时间（格式：9:00~20:00） */
    private String businessHoursDay;
    /**
     * 营业开始时间
     */
    private Date businessHoursDayStartTime;
    /**
     * 营业结束时间
     */
    private Date businessHoursDayEndTime;
    /* 营业状态{1:营业2:歇业3:停业} */
    private String state;
    /* 电话 */
    private String phone;
    /* 地址 */
    private String address;
    /* 类型（1总公司 2公司3门店） */
    private Integer typeFlag;
    /* 状态（1有效 0无效） */
    private Integer activeFlag;
    /* 距离 */
    private String distance;
    /* 备注 */
    private String remark;
    /* 省，文字，非编码 */
    private String province;
    /* 市，文字，非编码 */
    private String city;
    /* 区，文字，非编码 */
    private String region;
    /* 是否开通下单平台{1.是；2.否}*/
    private String placeOrderFlag;
    /**
     * 门店首页图片
     */
    private String imageUrl;
    /**
     * 门店log图片 v.1.6.2增加
     */
    private String logoUrl;
    /**
     * 门店配送信息
     */
    private OpenPlatformPartnerStoreDeliveryConfig storeDeliveryConfig;
    /**
     * 是否开通外卖配送 1.是；2.否}
     */
    private Integer delivery;
    /**
     * 是否开通到店自取（1是 2否） v1.5.4新增
     */
    private Integer isSelfMention;
    /**
     * 配送时间段
     */
    private String deliveryHours;
    /**
     * 当天配送时间
     */
    private String deliveryHoursDay;
    /**
     * 配送价格
     */
    private double deliveryPrice;
    /**
     * 配送半径,单位米
     */
    private String deliveryRadius;
    /**
     * 起送价格，或者免配送费价格
     */
    private double freeDeliveryPrice;
    private String scopeTagIds;
    //适用标签Name串，汉子半角逗号间隔
    private String scopeTagNames;
    //2018年1月5日 15:04:57
    /**
     * 地图配送范围 经纬度集合，用逗号隔开 121.417688,31.219334,121.356802,31.220252,121.343863,31.241462
     */
    private String distributionScope;

    /**
     * 预计送达时间
     */
    private Integer serviceTime;
    /**
     * 配送范围绘制{1：自定义；2：按半径},默认为1
     */
    private String scopeConfig;
    /**
     * 预订单提醒时间{1:15分钟;2:30分钟;3:45分钟;4:60分钟} 默认为1
     */
    private String orderWarnTime;
    /**
     * 预订单打印时间{1：提醒时打印；2：接单时打印} 默认为1
     */
    private String orderPrintConfig;
    /**
     * 最大接单量,单位笔
     */
    private Integer maxOrderQuantity;
}
