package cn.freemud.entities.dto;

import lombok.*;

import java.util.List;

@NoArgsConstructor
@Data
@AllArgsConstructor
@Builder
public class ActivityQueryRequestDto {
    /**
     * 接口版本
     */
    private String ver;
    /**
     * 商户号
     */
    private String partnerCode;
    /**
     * 商家门店编号
     */
    private String storeId;
    /**
     * 区域
     */
    private String area;
    /**
     * 多个活动code
     */
    private List<String> activityCodes;
    /**
     * 渠道 pickup-到店取餐 deliver-外卖
     */
    private String channel;
    /**
     * 绑定的小程序id
     */
    private String appId;
    /**
     * 活动类型
     * 1-整单满减
     * 11-每满减
     * 12-阶梯满减
     * 2-单品特价
     * 21-单品折扣
     * 3-优惠券
     * 5-整单满金额折
     * 51-每满金额折
     * 52-阶梯满金额折
     * 53-第M件/杯N折
     * 6-买M赠N
     * 7-满额赠券
     * 8-满N件换购
     * 81-满额换购
     * 82-满额阶梯换购（满多少金额，加价换购）
     * 100-阶梯满数量打折
     * 101-整单满数量打折
     * 不传查询所有活动
     */
    private Integer activityType;
    /**
     * 用户id，传入该参数会过滤掉该用户已领取了的活动（适用于优惠券活动列表）
     */
    private String userId;

    /**
     * 接入方名称，主要用于使用不同的模板
     * i应用传isaas，快中台传fast
     */
    private String application;

    private List<QueryGoodsBeanDto> goods;

    @Data
    @RequiredArgsConstructor
    public static class QueryGoodsBeanDto {
        /**
         * 商品ID
         */
        @NonNull
        private String goodsId;
        /**
         * 商品数量
         */
        @NonNull
        private Integer goodsQuantity;
        /**
         * 原价
         */
        @NonNull
        private Long originalPrice;
    }

}
