//
///**
// * All rights Reserved, Designed By www.freemud.cn
// *
// * @Title: BarcodeUtil
// * @Package cn.freemud.utils
// * @Description:条形码工具类
// * @author: song.cai
// * @date: 2018/5/16 14:40
// * @version V1.0
// * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
// * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
// */
//package cn.freemud.utils;
//
//import org.apache.commons.lang.ObjectUtils;
//import org.krysalis.barcode4j.HumanReadablePlacement;
//import org.krysalis.barcode4j.impl.code128.Code128Bean;
//import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
//
//import java.awt.image.BufferedImage;
//import java.io.ByteArrayOutputStream;
//import java.io.IOException;
//
//public class BarcodeUtil {
//
//    public static byte[] generateBarCode128(String message, Double height, Double width, boolean withQuietZone, boolean hideText) {
//        Code128Bean bean = new Code128Bean();
//        // 分辨率
//        int dpi = 256;
//        // 设置两侧是否留白
//        bean.doQuietZone(withQuietZone);
//
//        // 设置条形码高度和宽度
//        bean.setBarHeight((double) ObjectUtils.defaultIfNull(height, 9.0D));
//        if (width != null) {
//            bean.setModuleWidth(width);
//        }
//        // 设置文本位置（包括是否显示）
//        if (hideText) {
//            bean.setMsgPosition(HumanReadablePlacement.HRP_NONE);
//        }
//        bean.setFontSize(2.2D);
//        // 设置图片类型
//        String format = "image/png";
//
//        ByteArrayOutputStream ous = new ByteArrayOutputStream();
//        BitmapCanvasProvider canvas = new BitmapCanvasProvider(ous, format, dpi,
//                BufferedImage.TYPE_BYTE_BINARY, false, 0);
//
//        // 生产条形码
//        bean.generateBarcode(canvas, message);
//        try {
//            canvas.finish();
//        } catch (IOException e) {
//            //ByteArrayOutputStream won't happen
//        }
//        return ous.toByteArray();
//    }
//}