package cn.freemud.service.impl

import cn.freemud.adapter.ActivityAdapter
import cn.freemud.adapter.CouponAdapter
import cn.freemud.adapter.ShoppingCartConvertAdapter
import cn.freemud.adapter.StoreItemAdapter
import cn.freemud.base.entity.BaseResponse
import cn.freemud.entities.dto.GetCouponDetailResponseDto
import cn.freemud.entities.dto.ProductBaseResponse
import cn.freemud.entities.dto.ProductInfosDto
import cn.freemud.entities.dto.activity.ActivityQueryResponseDto
import cn.freemud.entities.dto.calculate.ActivityCalculationDiscountResponseDto
import cn.freemud.entities.dto.order.PackAmountConfig
import cn.freemud.entities.dto.product.ValiadShopProductResponse
import cn.freemud.entities.vo.GetShoppingCartGoodsApportionRequestVo
import cn.freemud.enums.ShoppingCartPromotionEnum
import cn.freemud.handle.CommonFunctionHandle
import cn.freemud.handle.PromotionCommonMethodHandle
import cn.freemud.service.ActivityService
import cn.freemud.service.CommonService
import cn.freemud.service.active.ActiveFactory
import cn.freemud.service.active.impl.PlatformActiveServiceImpl
import cn.freemud.service.impl.calculate.CalculationCommonService
import cn.freemud.service.impl.calculate.CalculationSharingCartService
import cn.freemud.service.impl.calculate.CalculationSharingDiscountService
import cn.freemud.service.impl.calculate.promotion.*
import cn.freemud.service.shoppingCart.ShoppingCartRelationFactory
import cn.freemud.service.thirdparty.ActivityClient
import cn.freemud.service.thirdparty.CouponOnlineClient
import cn.freemud.service.thirdparty.CustomerApplicationClient
import cn.freemud.service.thirdparty.ProductClient
import cn.freemud.utils.PromotionFactory
import com.alibaba.fastjson.JSON
import com.alibaba.fastjson.TypeReference
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.ShoppingCartBaseServiceImpl
import org.junit.runner.RunWith
import org.mockito.Mockito
import org.powermock.api.mockito.PowerMockito
import org.powermock.core.classloader.annotations.PrepareForTest
import org.powermock.modules.junit4.PowerMockRunner
import org.powermock.modules.junit4.PowerMockRunnerDelegate
import org.spockframework.runtime.Sputnik
import spock.lang.Specification
/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/3/4 16:56
 * @description : 购物车 老算价
 */
@RunWith(PowerMockRunner.class)
@PowerMockRunnerDelegate(Sputnik.class)
@PrepareForTest(PromotionFactory.class)
class ShoppingCartOldDiscountSpock extends Specification {
    def shoppingCartNewServiceImpl = new ShoppingCartNewServiceImpl()
    def activityAdapter = new ActivityAdapter()
    def couponAdapter = new CouponAdapter()
    def productServiceImpl = new ProductServiceImpl()
    def sharingDiscountService = new CalculationSharingDiscountService()
    def couponService = new CouponServiceImpl()
    def itemService = new ItemServiceImpl()
    def storeItemAdapter = new StoreItemAdapter()
    def defaultPromotionService = new DefaultPromotionService()
    def couponPromotionService = new CouponPromotionService()
    def buySendPromotionService = new BuySendPromotionService()
    def additionalPromotionService = new AdditionalPromotionService()
    def timeSalePromotionService = new TimeSalePromotionService()
    def setMealService = new SetMealServiceImpl()
    def customerScoreService = new CustomerScoreService()
    def xyDiscountService = new XyDiscountServiceImpl()
    def buyAndGiftsPromotionService = new BuyAndGiftsPromotionService()
    def materialPromotionService = new MaterialPromotionService()
    def fullPromotionService = new FullPromotionService()
    def memberDiscountService = new MemberDiscountServiceImpl()
    def platformActiveServiceImpl = new PlatformActiveServiceImpl()
    def fullMCountNFoldService = new FullMCountNFoldPromotionService()
    def buyMSendNCouponDiscountService = new BuyMSendNCouponDiscountServiceImpl()
    def gatherSpotPromotionService = new GatherSpotPromotionService()
    def memberDiscountServiceNew = new MemberDiscountServiceImpl()
    def sharingCartService = new CalculationSharingCartService()
    def shoppingCartConvertAdapter = new ShoppingCartConvertAdapter()


//    def assortmentSdkService = PowerMockito.mock(cn.freemud.service.impl.AssortmentSdkService)
    def assortmentSdkService = new AssortmentSdkService()
    def customerInfoManager = PowerMockito.mock(AssortmentCustomerInfoManager.class)
    def productService = PowerMockito.mock(ProductServiceImpl.class)
    def productClient = PowerMockito.mock(ProductClient.class)
    def activityClient = PowerMockito.mock(ActivityClient.class)
    def couponOnlineClient = PowerMockito.mock(CouponOnlineClient.class)
    def commonService = PowerMockito.mock(CommonService.class)
    def shoppingCartBaseService = PowerMockito.mock(ShoppingCartBaseServiceImpl)
    def activityService = PowerMockito.mock(ActivityService)
    def activeFactory = PowerMockito.mock(ActiveFactory)

    // 组装计算活动参数对象
    def calculationCommonService = new CalculationCommonService()
    def commonFunctionHandle = PowerMockito.mock(CommonFunctionHandle)
    def promotionSharingService = new CouponSharingService()
    def fullSharingService = new FullSharingService()
    def giftSharingService = new GiftSharingService()
    def additionSharingService = new AdditionSharingService()
    def scoreSharingService = new ScoreSharingService()
    def deliverySharingService = new DeliverySharingService()
    def buyOneGiveOneSendService = new BuyOneGiveOneSendService()
    def promotionCommonMethodHandle = new PromotionCommonMethodHandle()
    def customScoreClient = PowerMockito.mock(CustomerApplicationClient)
    def shoppingCartRelationFactory = PowerMockito.mock(ShoppingCartRelationFactory)

    void setup() {
        assortmentSdkService.mcCafePartnerId = "1206"
        assortmentSdkService.mcCafeUniversalShopId = "1"
        defaultPromotionService.shoppingCartConvertAdapter = shoppingCartConvertAdapter
        defaultPromotionService.promotionCommonMethodHandle = promotionCommonMethodHandle
        shoppingCartConvertAdapter.mcCafeTablewareSkuId = 1
        shoppingCartNewServiceImpl.customerInfoManager = customerInfoManager
        shoppingCartNewServiceImpl.shoppingCartRelationFactory = shoppingCartRelationFactory
        shoppingCartNewServiceImpl.productService = productService
        shoppingCartNewServiceImpl.assortmentSdkService = assortmentSdkService
        shoppingCartNewServiceImpl.activityAdapter = activityAdapter
        shoppingCartNewServiceImpl.couponAdapter = couponAdapter
        shoppingCartNewServiceImpl.couponService = couponService
        shoppingCartNewServiceImpl.commonFunctionHandle = commonFunctionHandle
        shoppingCartNewServiceImpl.sharingCartService = sharingCartService
        setMealService.shoppingCartConvertAdapter = shoppingCartConvertAdapter
        productServiceImpl.shoppingCartConvertAdapter = shoppingCartConvertAdapter
        // fisherman  测试过程中, 需要测试 新老算价需要自己 控制开关
        shoppingCartNewServiceImpl.newSharing = "{\"type\":1,\"grayList\":\"2692\",\"enable\":true}"
        shoppingCartNewServiceImpl.activityClient = activityClient
        shoppingCartNewServiceImpl.commonService = commonService
        shoppingCartNewServiceImpl.sharingDiscountService = sharingDiscountService
        assortmentSdkService.productServiceImpl = productServiceImpl
        productServiceImpl.productClient = productClient
        sharingDiscountService.activityClient = activityClient
        sharingDiscountService.couponService = couponService
        sharingDiscountService.commonService = commonService
        sharingDiscountService.activeFactory = activeFactory
        couponService.couponOnlineClient = couponOnlineClient
        couponService.commonService = commonService
        couponService.itemService = itemService
        couponService.storeItemClient = productClient
        itemService.storeItemAdapter = storeItemAdapter
        itemService.storeItemClient = productClient
        fullPromotionService.activityService = activityService
        // mock静态类
        PowerMockito.mockStatic(PromotionFactory.class)
        shoppingCartNewServiceImpl.shoppingCartBaseService = shoppingCartBaseService
        // 组装计算活动参数对象
        sharingCartService.calculationCommonService = calculationCommonService
        calculationCommonService.commonFunctionHandle = commonFunctionHandle
        sharingCartService.promotionSharingService = promotionSharingService
        promotionSharingService.assortmentSdkService = assortmentSdkService
        sharingCartService.fullSharingService = fullSharingService
        sharingCartService.giftSharingService = giftSharingService
        sharingCartService.additionSharingService = additionSharingService
        sharingCartService.scoreSharingService = scoreSharingService
        sharingCartService.deliverySharingService = deliverySharingService
        sharingCartService.buyOneGiveOneSendService = buyOneGiveOneSendService
        fullSharingService.activityService = activityService
        scoreSharingService.customScoreClient = customScoreClient
    }


    def "测试 getShoppingCartGoods 订单调用购物车获取结算金额 老算价"() {
        given: "参数设置"
        def getShoppingCartGoodsApportionRequestVo = JSON.parseObject("{\"shoppingCartInfoRequestVo\":{\"buyType\":0,\"couponCodes\":[],\"enableSharing\":1,\"flag\":0,\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"2692\",\"reachStoreType\":4,\"sessionId\":\"849ee19d37d8b6e3c454b943dd8d9c2181e6252a\",\"shopId\":\"1001\",\"trackingNo\":\"073caa9f24944f3f84ed5d4f8dd3cf7a\",\"useCouponFlag\":1,\"useCustomerScore\":2,\"version\":\"2.0.70\"}}"
                , GetShoppingCartGoodsApportionRequestVo.class)
        def premiumExchangeActivity = getShoppingCartGoodsApportionRequestVo.getPremiumExchangeActivity()
        def shoppingCartInfoRequestVo = getShoppingCartGoodsApportionRequestVo.getShoppingCartInfoRequestVo()

        def customerInfoVo = JSON.parseObject("{\"accessToken\":\"\",\"alipayUserId\":\"\",\"appId\":\"wx3f7ca0c75b213380\",\"appSecret\":\"\",\"appsecret\":\"\",\"channel\":\"1\",\"customerId\":\"\",\"devBrand\":\"\",\"devModel\":\"\",\"iappId\":\"7\",\"memberId\":\"3614319825989629832\",\"mobile\":\"17327190802\",\"newMember\":false,\"nickName\":\"SWEET SUGA\",\"openId\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"openid\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"partnerId\":\"2581\",\"photoUrl\":\"https://thirdwx.qlogo.cn/mmopen/vi_32/zahIlicTNSM0IA0qjOryv6s0SzIhlwW9EpQKvL63GbPhBwficMAibDohDEibSCQU0I5KohibIpp0yL57TWRcVKrRH2A/132\",\"registerTime\":\"2021-02-26 14:10:26\",\"sessionId\":\"eac53a53f8ae62def7f40cb1e47a1bd9791d95a8\",\"sessionKey\":\"GCyyapzbBSM4yXh9AduGOw==\",\"session_key\":\"GCyyapzbBSM4yXh9AduGOw==\",\"storeId\":\"\",\"tableNumber\":\"\",\"thirdPartyMemberID\":\"\",\"thirdPartyPartnerID\":\"\",\"unionId\":\"o7cEm68JPFhbrzqb0a0BcQE-dDVA\",\"wxAppId\":\"wx3f7ca0c75b213380\",\"wxAppid\":\"wx3f7ca0c75b213380\"}"
                , AssortmentCustomerInfoVo.class)

        def activityCalculationDiscountResponseDto = JSON.parseObject("{\"msg\":\"成功\",\"result\":{\"apportionGoods\":[],\"couponDiscounts\":[],\"discounts\":[{\"activityCode\":\"88710125853421364485\",\"activityName\":\"预发布俩套餐\",\"discount\":100,\"type\":32}],\"distributionFee\":0,\"goods\":[{\"cartGoodType\":0,\"cartGoodsUid\":\"9c0f5a6b-ac21-4c58-8b4f-ef28511ab04a\",\"discountAmount\":0,\"discounts\":[],\"gift\":false,\"goodsId\":\"245793855683830582\",\"goodsQuantity\":1,\"meal\":false,\"nowPrice\":100,\"originalPrice\":100,\"realAmount\":100,\"score\":0,\"smallMaterial\":[]},{\"actualGoodsNumber\":1,\"cartGoodType\":0,\"cartGoodsUid\":\"d7398995-5e75-445e-8fd3-d17bee2ac571\",\"discountAmount\":100,\"discounts\":[{\"activityCode\":\"88710125853421364485\",\"activityName\":\"预发布俩套餐\",\"actualGoodsNumber\":1,\"addOnQuantity\":0,\"discount\":100,\"goodsId\":\"241152650474924095\",\"signleDiscount\":100,\"type\":32}],\"gift\":false,\"goodsId\":\"241152650474924095\",\"goodsQuantity\":1,\"meal\":false,\"nowPrice\":100,\"originalPrice\":100,\"realAmount\":0,\"score\":0,\"smallMaterial\":[]}],\"isScoreLimit\":0,\"nightDistributionFee\":0,\"originalTotalAmount\":200,\"stocks\":[],\"totalAmount\":100,\"totalDiscountAmount\":100,\"v3Promotion\":false},\"statusCode\":\"100\",\"ver\":1}"
                , ActivityCalculationDiscountResponseDto.class)


        BaseResponse<List<com.freemud.sdk.api.assortment.shoppingcart.domain.CartGoods>> baseResponseShoppcartGoods = new BaseResponse<>()
        baseResponseShoppcartGoods.setCode("100")
        def goodList = JSON.parseArray("[{\"addCartTime\":1667290148648,\"amount\":300,\"canUseCoupon\":1,\"cartGoodsUid\":\"df984600-492d-451f-80b5-7c25dae35f54\",\"categoryName\":\"套餐\",\"classificationForeignName\":\"\",\"classificationId\":\"\",\"classificationName\":\"\",\"createTimeMili\":1667290148648,\"customerCode\":\"bnjui875\",\"finalPrice\":100,\"foreignName\":\"\",\"goodsId\":\"241152650474924095\",\"goodsType\":3,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isUseMonthCard\":0,\"linkedId\":\"\",\"materialAmount\":0,\"memberDiscount\":100,\"name\":\"只有固定套餐\",\"originalAmount\":300,\"originalMaterialAmount\":0,\"originalPrice\":300,\"originalProductType\":7,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1652755219677.png\",\"productComboList\":[{\"amount\":100,\"customerCode\":\"hlsnmc001\",\"extra\":[],\"finalPrice\":100,\"foreignName\":\"\",\"goodsId\":\"218530585442843686\",\"linkedId\":\"\",\"name\":\"柠檬茶\",\"originalAmount\":100,\"originalPrice\":100,\"originalProductType\":1,\"pic\":\"https://picture.sandload.cn/1631171610655.png\",\"qty\":1,\"skuId\":\"218530585442843686\",\"spuForeignName\":\"\",\"spuName\":\"柠檬茶\",\"tax\":0.0,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false},{\"amount\":100,\"customerCode\":\"903\",\"extra\":[],\"finalPrice\":100,\"foreignName\":\"\",\"goodsId\":\"215058511331065876\",\"linkedId\":\"\",\"name\":\"柚子茶\",\"originalAmount\":100,\"originalPrice\":100,\"originalProductType\":1,\"pic\":\"https://picture.sandload.cn/1627894433448.png\",\"qty\":1,\"skuId\":\"215058511331065876\",\"spuForeignName\":\"\",\"spuName\":\"柚子茶\",\"tax\":0.0,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false},{\"amount\":100,\"customerCode\":\"xy66\",\"extra\":[{\"attributeId\":\"245793500277383947\",\"attributeName\":\"正常糖\"},{\"attributeId\":\"245793437248529157\",\"attributeName\":\"☆[微笑]🌶️辣\"},{\"attributeId\":\"218527006041635865\",\"attributeName\":\"花生酱\"}],\"finalPrice\":100,\"foreignName\":\"\",\"goodsId\":\"245793855683830582\",\"linkedId\":\"\",\"name\":\"薯条🌶\",\"originalAmount\":100,\"originalPrice\":100,\"originalProductType\":1,\"pic\":\"https://picture.sandload.cn/1657160747233.png\",\"qty\":1,\"skuId\":\"245793855683830582\",\"specProductId\":\"245793500277383947/245793437248529157/218527006041635865\",\"spuForeignName\":\"\",\"spuName\":\"薯条🌶\",\"subName\":\"正常糖/☆[微笑]🌶️辣/花生酱\",\"tax\":0.0,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false}],\"productGroupList\":[],\"productMaterialList\":[],\"qty\":1,\"riseSell\":1,\"singleOrder\":0,\"skuForeignName\":\"\",\"skuId\":\"241152650474924095\",\"skuName\":\"只有固定套餐\",\"spuForeignName\":\"\",\"spuId\":\"241152650474924095\",\"spuName\":\"只有固定套餐\",\"stockLimit\":false,\"subForeignName\":\"\",\"subName\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false},{\"addCartTime\":1667290152261,\"amount\":100,\"canUseCoupon\":1,\"cartGoodsUid\":\"9c0f5a6b-ac21-4c58-8b4f-ef28511ab04a\",\"classificationForeignName\":\"\",\"classificationId\":\"\",\"classificationName\":\"\",\"createTimeMili\":1667290152261,\"customerCode\":\"xy66\",\"extra\":[{\"attributeId\":\"245793500277383947\",\"attributeName\":\"正常糖\"},{\"attributeId\":\"245793437248529157\",\"attributeName\":\"☆[微笑]🌶️辣\"},{\"attributeId\":\"218527006041635865\",\"attributeName\":\"花生酱\"}],\"finalPrice\":100,\"foreignName\":\"\",\"goodsId\":\"245793855683830582\",\"goodsType\":5,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isUseMonthCard\":0,\"linkedId\":\"\",\"materialAmount\":0,\"memberDiscount\":100,\"name\":\"薯条🌶\",\"originalAmount\":100,\"originalMaterialAmount\":0,\"originalPrice\":100,\"originalProductType\":1,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1657160747233.png\",\"productComboList\":[],\"productGroupList\":[],\"productMaterialList\":[],\"qty\":1,\"riseSell\":1,\"singleOrder\":0,\"skuForeignName\":\"\",\"skuId\":\"\",\"skuName\":\"薯条🌶\",\"specProductId\":\"245793500277383947/245793437248529157/218527006041635865\",\"spuForeignName\":\"\",\"spuId\":\"245793855683830582\",\"spuName\":\"薯条🌶\",\"stockLimit\":true,\"subForeignName\":\"\",\"subName\":\"正常糖/☆[微笑]🌶️辣/花生酱\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false}]"
                , com.freemud.sdk.api.assortment.shoppingcart.domain.CartGoods.class)
        baseResponseShoppcartGoods.setResult(goodList)

        def responseDto = JSON.parseObject("{\"details\":[{\"active\":{\"ActiveCode\":\"G1643164091158349\",\"ActiveDesc\":\"\\\"优惠券规则：\\n\\n券有效时间：领取后当日生效，有效期45天（具体以门店营业时间为准）\\n\\n使用范围：全国范围内已上线华莱士官方点餐小程序的华莱士门店（湖南省、湖北省、吉林省、新疆自治区除外，广东省、河北省、安徽省、海南省、北京市部分门店可用）\\n\\n活动规则：\\n1、在券有效期内，可凭本券在“华莱士官方点餐”小程序获得一次鸡米花买一送一权益。\\n2、本代金券仅限在“华莱士官方点餐”小程序上使用，与特价折扣商品不可同享，且不支持任何形式的核销后退款、变现、找零或转让。\\n3、产品规格以门店售卖为准。\\n4、 若因不可抗力因素致使本活动因故无法进行，主办方将在法律允许范围内取消、终止、修改或暂停本活动，且不承担任何违约或赔偿责任，尽管有上述约定，主办方将采取合理行动积极促使活动恢复正常。\\n如有疑问，可联系电话：4008899096。\\\"\\n\",\"ActiveId\":158770339,\"ActiveName\":\"鸡米花买一送一券\",\"AppId\":\"{\\\"apps\\\":[{\\\"appId\\\":\\\"wx3f7ca0c75b213380\\\",\\\"appName\\\":\\\"华莱士官方点餐\\\"},{\\\"appId\\\":\\\"2021002109662866\\\",\\\"appName\\\":\\\"华莱士官方点餐支付宝\\\"}]}\",\"BuyCount\":2,\"CreateDate\":\"2022-01-26 10:28:11\",\"CreateUser\":\"Rena\",\"DailyRedeemTimes\":1,\"EBCode\":\"\",\"Effective\":45,\"EffectiveEnd\":1676476799000,\"EffectiveStart\":1643126400000,\"EndDate\":\"2032-01-24 15:35:23\",\"EndString\":\"2032-01-24 15:35:23\",\"FromDayEffective\":0,\"GiftCount\":1,\"Inventory\":0,\"LastEditDate\":\"2022-03-02 13:53:16\",\"LastEditUser\":\"Rena\",\"LimitType\":1,\"MaxDiscount\":0,\"MaxRedeemTimes\":1,\"MerchantDiscountPrice\":0.00,\"MinAmount\":0.00,\"NoticeType\":0,\"OriginalPrice\":0,\"OtherDiscountPrice\":0.00,\"PartnerID\":2581,\"PlatformDiscountPrice\":0.00,\"RedeemChannel\":\"pickup,delivery\",\"Remain\":0,\"SalePrice\":0,\"StartDate\":\"2022-01-24 15:35:23\",\"StartString\":\"2022-01-24 15:35:23\",\"State\":1,\"Type\":7,\"VoucherFaceValue\":0.00,\"couponKind\":0,\"createType\":0,\"exemptionRule\":21,\"isDonate\":0,\"isMarketingTransfer\":0,\"logo\":\"https://picture.sandload.cn/1643095730650.jpg\",\"productScopeDesc\":\"全场通用\",\"promotionSharing\":0,\"remark\":\"\",\"storeScopeDesc\":\"全门店通用\"},\"activeCode\":\"G1643164091158349\",\"activeOrganizes\":[],\"activeProduct\":[{\"ActiveID\":158770339,\"Amount\":2,\"ID\":101092250,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210794556366562343\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210794556366562343},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":102707818,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202721754691430443\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202721754691430443},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":106896658,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210401734183578909\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210401734183578909},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":108664259,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201892530732737281\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201892530732737281},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":109930762,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"196181856362935850\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":196181856362935850},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":110136846,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"205739042253494553\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":205739042253494553},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":111281004,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202543005601654827\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202543005601654827},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":114626445,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201893297779668538\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201893297779668538},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":115395628,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202522421465524768\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202522421465524768},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":115820199,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"200624575557483286\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":200624575557483286},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":117240395,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202011967089649173\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202011967089649173},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":117999939,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201889966261817090\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201889966261817090},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":123936211,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201271922131126554\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201271922131126554},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":124066993,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210802942716994352\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210802942716994352},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":125896835,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"205705620076274750\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":205705620076274750},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":126390048,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201274763745872130\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201274763745872130},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":126672465,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202529859526748216\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202529859526748216},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":127065845,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202539418023664675\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202539418023664675},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":128117060,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210243929020483597\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210243929020483597},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":129635517,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"206150230788338465\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":206150230788338465},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":134711312,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"200463475075688706\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":200463475075688706},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":136288590,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201897415072052794\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201897415072052794},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":137630535,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202540819597675521\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202540819597675521},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":140530255,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201897810603308572\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201897810603308572},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":146050161,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"208982785000576831\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":208982785000576831},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":147751575,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202523893002430477\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202523893002430477},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":148992322,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"218142359735548461\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":218142359735548461},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":156830621,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"196180894333253140\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":196180894333253140},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":160705326,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202538605917268002\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202538605917268002},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":162463116,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202529566968801295\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202529566968801295},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":169597458,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"209226684733332798\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":209226684733332798},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":171307549,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"213420606371245629\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":213420606371245629},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":173136602,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202526680993012751\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202526680993012751},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":176003576,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202526989498738731\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202526989498738731},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":176541223,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202530381634771974\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202530381634771974},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":178377691,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202809932735654450\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202809932735654450},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":180645301,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201276161287901451\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201276161287901451},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":184234583,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"205116588443264314\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":205116588443264314},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":186250294,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210240193529248544\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210240193529248544},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":187829982,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"202985175152355391\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":202985175152355391},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":188803312,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201890450460747316\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201890450460747316},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":189633316,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"201904128631273001\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":201904128631273001},{\"ActiveID\":158770339,\"Amount\":2,\"ID\":199438172,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"210137445573931030\",\"Remain\":0,\"exchangePrice\":0,\"kgdProductId\":210137445573931030},{\"ActiveID\":158770339,\"Amount\":1,\"ID\":1724328479,\"MerchantDiscountPrice\":0.00,\"OtherDiscountPrice\":0,\"Paid\":0.00,\"PlatformDiscountPrice\":0.00,\"Price_Discount\":0.00,\"Price_Original\":0.00,\"ProductID\":1234567,\"ProductID_Partner\":\"233056712980957721\",\"Remain\":0,\"exchangePrice\":0.00,\"kgdProductId\":233056712980957721}],\"activeProductSetting\":[],\"activeRedeemTimeIntervalList\":[],\"activeRestrictionVOS\":[],\"code\":\"88709227085491207040\",\"create_time\":\"2022-02-20 15:10:42\",\"limitStoreId\":null,\"lockStatus\":false,\"minAmount\":\"0\",\"sendReason\":\"手动送券，SWEET SUGA，17327190802\",\"status\":0,\"storelimit\":0,\"storeChannelLimit\":0,\"storeLimitLevel\":1,\"title\":\"鸡米花买一送一券\",\"today_available_times\":1,\"total_available_times\":1,\"type\":7,\"valid_ends\":\"2022-04-05 23:59:59\",\"valid_start\":\"2022-02-20 00:00:00\"}],\"errors\":[],\"result\":1,\"statusCode\":0,\"ver\":1}"
                , GetCouponDetailResponseDto.class)


        def hasRequiredProducts = false


        def productInfosDto = JSON.parseObject("{\"data\":{\"count\":1,\"products\":[{\"barcode\":\"\",\"brandId\":\"\",\"brandName\":\"\",\"category\":\"\",\"categoryName\":\"\",\"companyId\":\"2692\",\"customerCode\":\"bnjui875\",\"finalPrice\":100,\"foreignName\":\"\",\"isSkuProduct\":0,\"labelNames\":[],\"linkedId\":\"\",\"maxNum\":0,\"minNum\":0,\"name\":\"只有固定套餐\",\"originalPrice\":100,\"packPrice\":0,\"picture\":\"https://picture.sandload.cn/1652755219677.png\",\"pid\":\"241152650474924095\",\"pknumber\":0,\"productAttributeGroupList\":[],\"productBindingCouponTypes\":[],\"productGroupList\":[],\"productPictureList\":[{\"sequence\":\"0\",\"type\":\"default\",\"url\":\"https://picture.sandload.cn/1652755219677.png\"}],\"productSpecification\":[],\"remark\":\"\",\"sellTimeList\":[],\"sequence\":0,\"singleOrder\":0,\"skuList\":[],\"skuSpecValues\":[],\"specProductId\":\"\",\"specification\":\"\",\"specificationGroupList\":[],\"specificationList\":[],\"status\":2,\"stock\":9999,\"stockLimit\":2,\"type\":7,\"unit\":\"\",\"updateStatus\":0,\"valid\":true,\"version\":0,\"weight\":0.0,\"weightType\":0}]},\"errcode\":100,\"errmsg\":\"成功\"}"
                , ProductInfosDto.class)

        def productBaseResponse = JSON.parseObject("{\"data\":{\"failureList\":[],\"successList\":[{\"code\":0,\"productType\":{\"additionalGroupList\":[],\"barcode\":\"\",\"brandId\":\"\",\"brandName\":\"\",\"businessNo\":\"\",\"category\":\"\",\"categoryName\":\"\",\"companyId\":\"2692\",\"customerCode\":\"xy66\",\"finalPrice\":100,\"foreignName\":\"\",\"isDishware\":0,\"isSkuProduct\":0,\"linkedId\":\"\",\"memberDiscount\":100,\"name\":\"薯条🌶\",\"openMemberDiscount\":0,\"originalPrice\":100,\"packPrice\":0,\"picture\":\"https://picture.sandload.cn/1657160747233.png\",\"pid\":\"245793855683830582\",\"productAttributeGroupList\":[{\"attributeName\":\"糖份\",\"attributeType\":248908,\"attributeValues\":[{\"attributeId\":\"245793500277383947\",\"attributeValue\":\"正常糖\",\"id\":255939190464874758,\"price\":0,\"sequence\":2,\"status\":2},{\"attributeId\":\"218526879321226242\",\"attributeValue\":\"不另外加糖\",\"id\":255939190464874759,\"price\":0,\"sequence\":5,\"status\":2},{\"attributeId\":\"218526872413207553\",\"attributeValue\":\"七分糖\",\"id\":255939190464874760,\"price\":0,\"sequence\":8,\"status\":2},{\"attributeId\":\"218526863033695295\",\"attributeValue\":\"五分糖\",\"id\":255939190464874761,\"price\":0,\"sequence\":11,\"status\":2},{\"attributeId\":\"218526853085854782\",\"attributeValue\":\"三分糖\",\"id\":255939190464874762,\"price\":0,\"sequence\":14,\"status\":2},{\"attributeId\":\"218526844581903421\",\"attributeValue\":\"无糖\",\"id\":255939190464874763,\"price\":0,\"sequence\":17,\"status\":2}],\"customerCode\":\"A101\",\"foreignAttributeName\":\"\",\"maxNumber\":1,\"minNumber\":1,\"must\":1,\"options\":\"\",\"sequence\":2},{\"attributeName\":\"辣度\",\"attributeType\":248910,\"attributeValues\":[{\"attributeId\":\"245793437248529157\",\"attributeValue\":\"☆[微笑]🌶️辣\",\"id\":255939190464874764,\"price\":0,\"sequence\":32,\"status\":2},{\"attributeId\":\"245793412317586179\",\"attributeValue\":\"变态辣\",\"id\":255939190464874765,\"price\":0,\"sequence\":35,\"status\":2},{\"attributeId\":\"245793400144667393\",\"attributeValue\":\"麻辣\",\"id\":255939190464874766,\"price\":0,\"sequence\":38,\"status\":2},{\"attributeId\":\"218526972654976010\",\"attributeValue\":\"重辣\",\"id\":255939190464874767,\"price\":0,\"sequence\":41,\"status\":2},{\"attributeId\":\"218526962395708425\",\"attributeValue\":\"中辣\",\"id\":255939190464874768,\"price\":0,\"sequence\":44,\"status\":2},{\"attributeId\":\"218526954094132232\",\"attributeValue\":\"微辣\",\"id\":255939190464874769,\"price\":0,\"sequence\":47,\"status\":2},{\"attributeId\":\"218526947679992839\",\"attributeValue\":\"不辣\",\"id\":255939190464874770,\"price\":0,\"sequence\":50,\"status\":2}],\"customerCode\":\"A103\",\"foreignAttributeName\":\"\",\"maxNumber\":1,\"minNumber\":1,\"must\":1,\"options\":\"\",\"sequence\":32},{\"attributeName\":\"调料\",\"attributeType\":248840,\"attributeValues\":[{\"attributeId\":\"218527006041635865\",\"attributeValue\":\"花生酱\",\"id\":255939190464874771,\"price\":0,\"sequence\":53,\"status\":2},{\"attributeId\":\"218526991815605272\",\"attributeValue\":\"芝麻酱\",\"id\":255939190464874772,\"price\":0,\"sequence\":56,\"status\":2},{\"attributeId\":\"215058820418764845\",\"attributeValue\":\"沙茶酱\",\"id\":255939190464874773,\"price\":0,\"sequence\":59,\"status\":2},{\"attributeId\":\"215058813881942060\",\"attributeValue\":\"芥末酱\",\"id\":255939190464874774,\"price\":0,\"sequence\":62,\"status\":2},{\"attributeId\":\"215058807050469419\",\"attributeValue\":\"番茄酱\",\"id\":255939190464874775,\"price\":0,\"sequence\":65,\"status\":2}],\"customerCode\":\"101\",\"foreignAttributeName\":\"\",\"maxNumber\":1,\"minNumber\":1,\"must\":1,\"options\":\"\",\"sequence\":53}],\"productBindingCouponTypes\":[],\"productCode\":\"12\",\"productComboList\":[],\"productGroupList\":[],\"productPictureList\":[{\"sequence\":\"0\",\"type\":\"default\",\"url\":\"https://picture.sandload.cn/1657160747233.png\"}],\"riseSell\":1,\"singleOrder\":0,\"skuList\":[],\"skuSpecValues\":[],\"specification\":\"\",\"status\":2,\"stock\":9999,\"stockLimit\":1,\"stockMode\":1,\"type\":1,\"unit\":\"\",\"weight\":0.0,\"weightType\":0},\"skuId\":\"245793855683830582\",\"spuId\":\"245793855683830582\",\"uuid\":\"9c0f5a6b-ac21-4c58-8b4f-ef28511ab04a\"}]},\"errcode\":100,\"errmsg\":\"获取门店必选分类商品成功\"}"
                , new TypeReference<ProductBaseResponse<ValiadShopProductResponse>>() {})

        def activityQueryResponseDto = JSON.parseObject("{\"msg\":\"成功\",\"result\":[],\"statusCode\":\"100\",\"ver\":1}"
                , new TypeReference<ActivityQueryResponseDto>() {})
        def packAmountByStoreConfig = new PackAmountConfig()
        packAmountByStoreConfig.setNewPackAmount(0L)

        and: "调三方反馈参数 为自己的参数对象 "
//        Mockito.when(assortmentSdkService.getShoppingCart(Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), shoppingCartBaseService, Mockito.any())).thenReturn(goodList)
        assortmentSdkService.getShoppingCart(_, _, _, _, _, shoppingCartBaseService, _) >> goodList
        Mockito.when(shoppingCartBaseService.getCartGoodsList(Mockito.any(), Mockito.any())).thenReturn(baseResponseShoppcartGoods)
        Mockito.when(customerInfoManager.getCustomerInfoByObject(Mockito.any())).thenReturn(customerInfoVo)
        Mockito.when(productService.hasRequiredProducts(Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any())).thenReturn(hasRequiredProducts)
//        Mockito.when(assortmentSdkService.checkShoppingCartSdk(Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any(), Mockito.any())).thenReturn(checkCartRequest)
        Mockito.when(activityClient.calculationDiscount(Mockito.any())).thenReturn(activityCalculationDiscountResponseDto)
        Mockito.when(commonService.getOrgIdsAsString(Mockito.any(), Mockito.any())).thenReturn(null)
        Mockito.when(commonService.getOrgIdsForCoupon(Mockito.any(), Mockito.any())).thenReturn(["1e906bab-1800-4b00-8e36-29049d7f4efc", "391cec83-2b60-49a9-af2c-d8d6a813ce72", "16dc665e-8e03-41a8-83ae-95e92666d266"])
        Mockito.when(couponOnlineClient.getCouponDetails(Mockito.any())).thenReturn(responseDto)
        Mockito.when(productClient.listProductInfos(Mockito.any())).thenReturn(productInfosDto)
        Mockito.when(productClient.validateShopProduct(Mockito.any())).thenReturn(productBaseResponse)
        Mockito.when(activityService.queryActivityByType(Mockito.any(), Mockito.any(), Mockito.any())).thenReturn(activityQueryResponseDto)
        Mockito.when(activeFactory.getBuildChooseGoodsService(Mockito.any())).thenReturn(platformActiveServiceImpl)
        Mockito.when(commonFunctionHandle.getPackAmountByStoreConfig(Mockito.any(), Mockito.any(), Mockito.any())).thenReturn(packAmountByStoreConfig)

        and: "静态方法mock"
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.DEFAULT_PROMOTION)).thenReturn(defaultPromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.COUPON_DISCOUNT)).thenReturn(couponPromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.BUY_ONE_SEND)).thenReturn(buySendPromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.ADDITIONAL_BUY)).thenReturn(additionalPromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.TIME_SALE)).thenReturn(timeSalePromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.SET_MEAL)).thenReturn(setMealService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.CUSTOMER_SCORE)).thenReturn(customerScoreService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.XY_DISCOUNT)).thenReturn(xyDiscountService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.BUY_GIFTS)).thenReturn(buyAndGiftsPromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.Material)).thenReturn(materialPromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.FULL_REDUCTION)).thenReturn(fullPromotionService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.MEMBER_DISCOUNT)).thenReturn(memberDiscountService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.FULL_M_COUNT_N_FOLD)).thenReturn(fullMCountNFoldService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.MEMBER_DISCOUNT_NEw)).thenReturn(memberDiscountServiceNew)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.BUY_M_SEND_N_COUPON)).thenReturn(buyMSendNCouponDiscountService)
        PowerMockito.when(PromotionFactory.getPromotionService(ShoppingCartPromotionEnum.GATHER_SPOT)).thenReturn(gatherSpotPromotionService)

        when: "调用方法逻辑"


        //   测试过程中, 需要测试 新老算价需要自己 控制开关
        def response = shoppingCartNewServiceImpl.getShoppingCartGoods(shoppingCartInfoRequestVo, premiumExchangeActivity)

        then: "验证 返回结果"
        with(response) {
            code == "100"
            message == "success"
        }

    }
}
