package cn.freemud.entities.dto.product;

import cn.freemud.entities.dto.product.info.*;
import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By sunary.site
 *
 * @version v1.0
 * @Title: IntelliJ IDEA
 * @Package cn.freemud.entities.dto.product
 * @Description: 请简单描述下这个类是做什么用的
 * @author: yu.sun
 * @date: 2020-11-25 11:51:44
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 */
@Data
public class ProductTypeBeanDTO {
    private String businessNo;
    private String barcode;
    private String brandId;
    private String brandName;
    private String category;
    private String categoryName;
    private String companyId;
    private String customerCode;
    private String productCode;
    private Long finalPrice;
    private Integer isSkuProduct;
    private String name;
    private Long originalPrice;
    private Long packPrice;
    private String picture;
    private String pid;
    private String specification;
    private Integer status;
    private Integer stock;
    private Integer stockLimit;
    private Integer type;
    private String unit;
    private Integer riseSell;
    private String rawMaterial;
    private Double tax;
    private String taxId;
    private Integer openMemberDiscount;
    private Integer memberDiscount;
    private Integer isDishware;
    private Integer weightType;
    private Double weight;
    private String foreignName;


    private List<ProductBindingCouponType> productBindingCouponTypes;
    private List<ProductAttributeGroupListBean> productAttributeGroupList;
    private List<ProductPictureListBean> productPictureList;
    private List<SkuProductBean> skuList;
    private List<ProductComboType> productComboList;
    private List<ProductGroupType> productGroupList;
    private List<SkuSpecValue> skuSpecValues;
    private List<PackageProductTypeDto> packageProductTypes;
    private List<ProductGroupType> additionalGroupList;
    private List<ProductComboDetailTypeDto> productComboInfos;
    /**
     *  【订C，“POS编码”让凌顶那边去匹配商品】 https://www.tapd.cn/43862731/prong/stories/view/1143862731001039549
     */
    private String linkedId ;
    /**
     * 商品是否可以单点
     * 0-可单点
     * 1-不可单点
     */
    private Integer singleOrder;


    /**
     * 库存模式,目前该模式只针对套餐商品会起作用
     * 1-使用套餐库存：即套餐库存和套餐中子商品品库存分别存在、互不影响
     * 2-使用联动库存：即套餐商品的库存为套餐库存和套餐中子商品的库存，当用户购买套餐商品时，同时扣减套餐库存和套餐中子商品的库存，当套餐中任一子商品库存为0或套餐商品的库存为0时，该套餐将不能购买
     */
    protected Integer stockMode = 1;


    public Integer getMemberDiscountResult() {
        return this.openMemberDiscount != null && this.openMemberDiscount == 1 ? this.memberDiscount : 100;
    }

    public ProductTypeBeanDTO() {
    }

}
