package com.freemud.application.sdk.api.ordercenter.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderClientType
 * @Package com.freemud.application.sdk.api.ordercenter.request
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/2 13:44
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 * <p>
 * <p>
 * * com.freemud.application.sdk.api.ordercenter.enums.OrderClientType
 * * 两个枚举类 需要同步加, 不然在订单业务代码中 会报错
 */
public enum OrderClientType {

//    WE_CHAT(1, "自营微信小程序"),
    SAAS(2, "微信小程序"),
    ALIPAY(3, "支付宝小程序"),
    HTML5(4, "自营H5"),
    ANDROID(5, "自营安卓APP"),
    IOS(6, "自营苹果APP"),
    PC_WEB(7, "自营PC-WEB"),
    ELEME(8, "饿了么"),
    EBAI(9, "饿百"),
    JD(10, "京东"),
    MEITUAN(11, "美团外卖"),
    APP(12, "自营APP"),
//    I_MEMBER(13, "i应用会员"),//废弃,农工商定制继续使用
    I_CARGO(14, "i应用订货"),
    POS(15, "POS"),
    WAI_MEAL(19, "i围餐"),//废弃
    JUBAOPEN(20, "美团服务商"),
    DIANPING(21, "美团点评"),
    KOUBEI(22, "口碑"),
//    SAASMALL(23, "微商城"),//废弃
    DPZHCT(24, "美团点评智慧餐厅"),
    FMWD(25, "非码微店"),
    TIKTOKPAY(27, "抖音小程序"),
//    BEAUTIFUL(28, "美业"),//废弃
    ASSISTANT(29, "非码小助手"),
    SHERPAS(30, "食派士"),
    PARKING(99, "农工商停车"),
//    CASHIER(36, "收银买单"),//废弃
//    WE_CHAT_LIVE_SELL(37, "微信视频卖券"),//废弃
    ;


    private Integer index;
    private String name;

    public Integer getIndex() {
        return index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    OrderClientType(Integer index, String name) {
        this.index = index;
        this.name = name;
    }

    public static OrderClientType getOrderClientType(Integer index) {
        for (OrderClientType orderType : values()) {
            if (index.equals(orderType.getIndex())) {
                return orderType;
            }
        }
        return null;
    }

}
