package cn.freemud.management.service.handle;

import cn.freemud.amqp.Header;
import cn.freemud.amqp.MQAction;
import cn.freemud.amqp.MQMessage;
import cn.freemud.amqp.MQService;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import com.freemud.application.sdk.api.log.ErrorLog;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.util.LogUtil;
import com.freemud.sdk.api.assortment.order.request.order.OrderStatusChangeRequestDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: InventoryService
 * @Package cn.freemud.management.service.impl
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/4/24 17:56
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class StockHandle {

    private static final String backOrdersChangeOrderStatusConsumerQueue="program.backorders_change_order_status_consumer_queue";
    private static final String backOrdersNotifyActivityExchange="program.backorders_notify_activity_exchange";

    @Autowired
    private MQService mqService;
    @Autowired
    private LogUtil logUtil;

    /**
     * 冲正库存、券码等
     * @param request
     * @param orderBean
     */
    public void revert(OrderManagerRequest request, OrderBeanV1 orderBean){
        //同意退款退款中已经发起冲正
        if(orderBean.getAfterSalesOrderResp() != null && orderBean.getAfterSalesOrderResp().getAfterSalesStatus() == 4){
            return;
        }
        logUtil.info("backOrdersStatusChange oid:{},statusV2:{}", orderBean.getOid(), String.valueOf(orderBean.getStatusV2()));
        OrderStatusChangeRequestDto requestDto = new OrderStatusChangeRequestDto();
        requestDto.setOid(orderBean.getOid());
        requestDto.setOrderStatus(orderBean.getStatus());
        requestDto.setPartnerId(orderBean.getCompanyId());
        try {
            Header header = new Header(MQAction.INSERT.getAction(), "backOrdersStatusChange", orderBean.getOid(), backOrdersChangeOrderStatusConsumerQueue);
            MQMessage<OrderStatusChangeRequestDto> message = new MQMessage<>(header, requestDto);
            mqService.convertAndSend(backOrdersNotifyActivityExchange, backOrdersChangeOrderStatusConsumerQueue, message);
        } catch (Exception e) {
            ErrorLog.errorConvertJson(this.getClass(),"activityReverseError:"+orderBean.getOid(),e);
        }
    }
}
