package cn.freemud.service.impl

import cn.freemud.management.adapter.PaymentSdkAdapter
import cn.freemud.management.controller.OrderManagerController
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest
import cn.freemud.management.entities.dto.response.pay.PayRefundData
import cn.freemud.management.entities.dto.response.pay.PaymentQueryOrderResponseDto
import cn.freemud.management.service.OrderBaseService
import cn.freemud.management.service.adapter.OrderBeanFactory
import cn.freemud.management.service.adapter.OrderManagerAdapter
import cn.freemud.management.service.handle.DeliveryHandle
import cn.freemud.management.service.handle.OrderVerifyHandle
import cn.freemud.management.service.handle.PaymentHandle
import cn.freemud.management.service.impl.SaasOrderMangerServiceImpl
import cn.freemud.management.thirdparty.MulitiPaymentClient
import cn.freemud.management.thirdparty.OMSPaymentClient
import cn.freemud.redis.RedisCache
import com.alibaba.fastjson.JSON
import com.alibaba.fastjson.TypeReference
import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformIappWxappStore
import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformIappWxappStoreManager
import com.freemud.application.sdk.api.base.BaseResponse
import com.freemud.application.sdk.api.ordercenter.adapter.OrderCenterSdkAdapter
import com.freemud.application.sdk.api.ordercenter.response.OrderBaseResp
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.AfterSalesOrderResp
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs
import com.freemud.application.sdk.api.ordercenter.service.OrderSdkService
import com.freemud.application.sdk.api.ordercenter.util.LogUtil
import com.freemud.sdk.api.assortment.order.response.order.MultiOrderRefundResponse
import spock.lang.Specification

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/7/12 10:13
 * @description : 
 */
class OMSServiceSpock extends Specification {

    def orderManagerAdapter = new OrderManagerAdapter()
    def orderBaseService = Mock(OrderBaseService)
    def orderVerifyHandle = new OrderVerifyHandle()
    def redisCache = Mock(RedisCache)
    def orderBeanFactory = Mock(OrderBeanFactory)

    def saasOrderManagerServiceImpl = new SaasOrderMangerServiceImpl()
    def deliveryHandle = Mock(DeliveryHandle)
    def paymentHandle = new PaymentHandle()
    def orderSdkService = Mock(OrderSdkService)
    def paymentSdkAdapter = new PaymentSdkAdapter()
    def orderCenterSdkAdapter = new OrderCenterSdkAdapter()
    def paymentNewClient = Mock(OMSPaymentClient)
    def assortmentOpenPlatformIappWxappStoreManager = Mock(AssortmentOpenPlatformIappWxappStoreManager)
    def logUtil = Mock(LogUtil)
    def mulitiPaymentClient = Mock(MulitiPaymentClient)

    def orderManagerController = new OrderManagerController()

    void setup() {
        orderManagerController.orderManagerAdapter = orderManagerAdapter
        orderManagerAdapter.orderBaseService = orderBaseService
        orderManagerAdapter.orderVerifyHandle = orderVerifyHandle
        orderVerifyHandle.redisCache = redisCache
        orderManagerAdapter.orderBeanFactory = orderBeanFactory
        saasOrderManagerServiceImpl.deliveryHandle = deliveryHandle
        saasOrderManagerServiceImpl.paymentHandle = paymentHandle
        paymentHandle.paymentSdkAdapter = paymentSdkAdapter
        paymentHandle.orderSdkService = orderSdkService
        paymentHandle.paymentNewClient = paymentNewClient
        paymentHandle.assortmentOpenPlatformIappWxappStoreManager = assortmentOpenPlatformIappWxappStoreManager
        paymentHandle.logUtil = logUtil
        paymentHandle.mulitiPaymentClient = mulitiPaymentClient
    }

    def "orderAgreeRefund to SaasOrder"() {
        given: "参数设置"
        def requestVo = JSON.parseObject("{\"brandVerifyAfterSales\":false,\"horseman\":false,\"operateType\":\"orderAgreeRefund\",\"operationClient\":0,\"operator\":\"admin\",\"orderId\":\"25057059417364153500004\",\"partnerId\":\"2581\"}",
                new TypeReference<OrderManagerRequest>() {})

        def orderInfo = JSON.parseObject("{\"abnormalDesc\":\"\",\"abnormalState\":0,\"acceptTime\":1659004361000,\"actualPayAmount\":1080.0,\"afterSalesOrderList\":[{\"actualAmount\":3790.0,\"actualScoreAmount\":0,\"adultRemark\":\"\",\"afterSalesApplyClient\":0,\"afterSalesCode\":\"25057073866525960500004\",\"afterSalesImages\":[],\"afterSalesOptHistoryList\":[{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"id\":250570738679939678,\"operationClient\":0,\"operationCode\":1,\"operationDesc\":\"发起售后申请\",\"operator\":\"\",\"orderCode\":\"25057059417364153500004\",\"partnerId\":\"2581\",\"targetAfterSalesState\":1,\"timeout\":0,\"updateTime\":1659004477000},{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004492000,\"id\":250570754282785835,\"operationClient\":1,\"operationCode\":4,\"operationDesc\":\"退货完成\",\"operator\":\"pos\",\"orderCode\":\"25057059417364153500004\",\"partnerId\":\"2581\",\"targetAfterSalesState\":4,\"timeout\":0,\"updateTime\":1659004492000}],\"afterSalesOrderItems\":[{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isSendGoods\\\": false, \\\"cartGoodsUid\\\": \\\"353ee7b7-98ac-4a06-942b-11995eb401fe\\\", \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"021503897\\\"}\",\"id\":250570738667356758,\"orderCode\":\"25057059417364153500004\",\"orderItemId\":250570594194613059,\"parentProductId\":\"0\",\"partnerId\":\"2581\",\"productId\":\"226650306125091606\",\"productName\":\"六个香辣小鸡腿\",\"productPicUrl\":\"https://picture.sandload.cn/1639359965618.png\",\"productPrice\":1190.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":2,\"productSpec\":\"226650306125091606\",\"productSpecName\":\"六个香辣小鸡腿\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"thirdProductId\":\"tj021503897\",\"updateTime\":1659004477000,\"weight\":0.00},{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"extInfo\":\"{\\\"tax\\\": 0, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"010300040\\\"}\",\"id\":250570738669453911,\"orderCode\":\"25057059417364153500004\",\"orderItemId\":250570594188321601,\"parentProductId\":\"0\",\"partnerId\":\"2581\",\"productId\":\"205873819584334365\",\"productName\":\"韩式炸鸡桶\",\"productPicUrl\":\"https://picture.sandload.cn/1623721168081.jpg\",\"productPrice\":500.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":1,\"productSpec\":\"205873819584334365\",\"productSpecName\":\"韩式炸鸡桶\",\"productType\":1,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"thirdProductId\":\"tj010300040\",\"updateTime\":1659004477000,\"weight\":0.00},{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"isFixedProduct\\\": true, \\\"spuProductCode\\\": \\\"010200118\\\"}\",\"id\":250570738670502488,\"orderCode\":\"25057059417364153500004\",\"orderItemId\":250570594200904517,\"parentProductId\":\"226650306125091606_2\",\"partnerId\":\"2581\",\"productId\":\"226650195045241630\",\"productName\":\"小鸡腿\",\"productPicUrl\":\"https://picture.sandload.cn/1639010644221.png\",\"productPrice\":198.0,\"productProperty\":\"\",\"productQuantity\":6,\"productScorePrice\":0,\"productSeq\":0,\"productSpec\":\"226650195045241630\",\"productSpecName\":\"小鸡腿\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"thirdProductId\":\"tj010200118\",\"updateTime\":1659004477000,\"weight\":0.00},{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isSendGoods\\\": false, \\\"cartGoodsUid\\\": \\\"f6279826-d598-4e3e-ae19-5c9f7522aedb\\\", \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"020805123\\\"}\",\"id\":250570738671551065,\"orderCode\":\"25057059417364153500004\",\"orderItemId\":250570594207195975,\"parentProductId\":\"0\",\"partnerId\":\"2581\",\"productId\":\"229893933386351900\",\"productName\":\"鸡米花2份\",\"productPicUrl\":\"https://picture.sandload.cn/1642047071104.jpg\",\"productPrice\":900.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":3,\"productSpec\":\"229893933386351900\",\"productSpecName\":\"鸡米花2份\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"thirdProductId\":\"tj020805123\",\"updateTime\":1659004477000,\"weight\":0.00},{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"isFixedProduct\\\": true, \\\"spuProductCode\\\": \\\"010100001\\\"}\",\"id\":250570738672599642,\"orderCode\":\"25057059417364153500004\",\"orderItemId\":250570594228167501,\"parentProductId\":\"229924916440378431_4\",\"partnerId\":\"2581\",\"productId\":\"205061623490055194\",\"productName\":\"香辣鸡腿堡\",\"productPicUrl\":\"https://picture.sandload.cn/1618365464768.jpg\",\"productPrice\":600.0,\"productProperty\":\"\",\"productQuantity\":2,\"productScorePrice\":0,\"productSeq\":0,\"productSpec\":\"205061623490055194\",\"productSpecName\":\"香辣鸡腿堡\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"thirdProductId\":\"tj010100001\",\"updateTime\":1659004477000,\"weight\":0.00},{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"isFixedProduct\\\": true, \\\"spuProductCode\\\": \\\"010200001\\\"}\",\"id\":250570738673648219,\"orderCode\":\"25057059417364153500004\",\"orderItemId\":250570594213487433,\"parentProductId\":\"229893933386351900_3\",\"partnerId\":\"2581\",\"productId\":\"205116588443264314\",\"productName\":\"鸡米花\",\"productPicUrl\":\"https://picture.sandload.cn/1618387408140.jpg\",\"productPrice\":450.0,\"productProperty\":\"\",\"productQuantity\":2,\"productScorePrice\":0,\"productSeq\":0,\"productSpec\":\"205116588443264314\",\"productSpecName\":\"鸡米花\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"thirdProductId\":\"tj010200001\",\"updateTime\":1659004477000,\"weight\":0.00},{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isSendGoods\\\": false, \\\"cartGoodsUid\\\": \\\"11dea04f-9dbc-4f7e-b277-5e6cf387f5cc\\\", \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"020805079\\\"}\",\"id\":250570738674696796,\"orderCode\":\"25057059417364153500004\",\"orderItemId\":250570594219778891,\"parentProductId\":\"0\",\"partnerId\":\"2581\",\"productId\":\"229924916440378431\",\"productName\":\"香辣鸡腿堡2份\",\"productPicUrl\":\"https://picture.sandload.cn/1642076939042.jpg\",\"productPrice\":1200.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":4,\"productSpec\":\"229924916440378431\",\"productSpecName\":\"香辣鸡腿堡2份\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"thirdProductId\":\"tj020805079\",\"updateTime\":1659004477000,\"weight\":0.00}],\"afterSalesReason\":\"下错单\",\"afterSalesStatus\":4,\"afterSalesType\":2,\"createTime\":1659004477000,\"deliveryAmount\":0.0,\"deliveryContactInfo\":[],\"expressChannelCode\":\"\",\"expressChannelName\":\"\",\"expressNo\":\"\",\"extInfo\":\"{\\\"lastOrderStatus\\\": 3}\",\"hasCargo\":false,\"isAllItemAfterSales\":true,\"operator\":\"pos\",\"orderCode\":\"25057059417364153500004\",\"originalShippingFee\":0.0,\"partnerId\":\"2581\",\"partnerRefundCode\":\"\",\"refundFailReason\":\"\",\"refundState\":2,\"reqAmount\":3790.0,\"reqRemark\":\"Hh \",\"reqScoreAmount\":0,\"settlementShippingFee\":0.0,\"thirdRefundCode\":\"\",\"updateTime\":1659004492000,\"weight\":0.00}],\"afterSalesState\":4,\"appId\":\"2021002109662866\",\"barCounter\":\"\",\"bizType\":1,\"businessDay\":1658937600000,\"canRefund\":true,\"cancelReason\":\"下错单\",\"companySelfCode\":\"\",\"createTime\":1659004340000,\"daySeq\":32,\"deliveryContactInfoList\":[{\"addressDetail\":\"天津市北辰区果园北道与商业局东路交口\",\"city\":\"\",\"contactsName\":\"\",\"expressNo\":\"0\",\"extInfo\":\"{}\",\"infoType\":1,\"latitude\":0E-7,\"longitude\":0E-7,\"mobile\":\"15222622053\",\"province\":\"\",\"region\":\"\",\"relateObjectType\":1,\"street\":\"\",\"telephone\":\"\",\"thirdDeliveryId\":\"0\",\"tripDist\":0}],\"deliveryPromise\":0,\"deliveryState\":-2,\"dinersNumber\":0,\"downstreamPosCode\":\"0\",\"downstreamThirdOrderCode\":\"0\",\"evaluationState\":0,\"expressChannelCode\":\"\",\"expressChannelName\":\"\",\"expressNo\":\"\",\"expressType\":0,\"extInfo\":\"{\\\"fmId\\\": \\\"8802581250570594402293008\\\", \\\"appid\\\": \\\"2021002109662866\\\", \\\"formId\\\": \\\"MjA4ODgxMjUxMzc2MTU1NF8xNjU5MDA0MzM5NjQ5XzA1OQ==\\\", \\\"openid\\\": \\\"2088812513761554\\\", \\\"payDate\\\": \\\"2022-07-28 18:32:28\\\", \\\"version\\\": \\\"2.0.651\\\", \\\"prepayId\\\": \\\"2022072822001461551417120994\\\", \\\"fromAppId\\\": \\\"2021002109662866\\\", \\\"sessionId\\\": \\\"02268690d5cf6efa2a3f9a1dc08c569a359c45f2\\\", \\\"endTransId\\\": \\\"10024066479262207281832206428006\\\", \\\"paidMember\\\": false, \\\"payTransId\\\": \\\"8802581250570594402293008\\\", \\\"sessionKey\\\": \\\"\\\", \\\"totalScore\\\": 0, \\\"memberLevel\\\": \\\"\\\", \\\"serviceTime\\\": 50, \\\"dispatchType\\\": \\\"0\\\", \\\"pushOrderTime\\\": 0, \\\"dispatchTimeout\\\": 0, \\\"deliveryHoursDayEnd\\\": \\\"\\\", \\\"deliveryHoursDayStart\\\": \\\"\\\", \\\"packageAmountCollectType\\\": 1}\",\"immediately\":true,\"isParent\":false,\"localTableKey\":\"\",\"logisticsAccessChannel\":0,\"logisticsList\":[],\"marketingCode\":\"\",\"marketingType\":0,\"needInvoice\":false,\"note\":\"\",\"operator\":\"\",\"orderArea\":\"0\",\"orderClient\":3,\"orderCode\":\"25057059417364153500004\",\"orderCostDetailList\":[],\"orderExtended\":{\"agentPayerId\":\"\",\"agentPayerName\":\"\",\"createTime\":1659004340000,\"id\":250570594173641535,\"isDeleted\":false,\"orderClientGroup\":\"督导林爽\",\"orderClientGroupCode\":\"210204\",\"orderCode\":\"25057059417364153500004\",\"orderId\":250570594173641535,\"partnerId\":\"2581\",\"sendWord\":\"\",\"spellGroupCode\":\"\",\"storeId\":\"999999_01056\",\"storeNameEn\":\"\",\"updateTime\":1659004340000,\"userPhone\":\"\",\"version\":0},\"orderInvoice\":{\"address\":\"\",\"bankCardNo\":\"\",\"content\":\"\",\"invoiceBank\":\"\",\"invoiceNo\":\"\",\"invoiceUrl\":\"\",\"itemId\":\"\",\"partnerId\":\"\",\"phoneNo\":\"\",\"pickUpNo\":\"\",\"taxNo\":\"\",\"title\":\"\",\"userId\":\"\"},\"orderItemList\":[{\"canRefund\":true,\"categoryId\":\"0\",\"categoryName\":\"0\",\"extInfo\":\"{\\\"tax\\\": 0, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"010300040\\\"}\",\"id\":250570594188321601,\"ignoreInOrderClose\":false,\"marketingCode\":\"0\",\"marketingType\":0,\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"originalProductType\":1,\"parentProductId\":\"0\",\"photoUrl\":\"\",\"productCode\":\"010300040\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"205873819584334365\",\"productName\":\"韩式炸鸡桶\",\"productPicUrl\":\"https://picture.sandload.cn/1623721168081.jpg\",\"productPrice\":1500.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":1,\"productSharePrice\":1000.0,\"productSpec\":\"205873819584334365\",\"productSpecName\":\"韩式炸鸡桶\",\"productType\":1,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"salePrice\":500.0,\"saleScorePrice\":0,\"settlementPrice\":500.0,\"settlementScorePrice\":0,\"thirdProductId\":\"tj010300040\",\"userId\":\"\",\"weight\":0.00},{\"canRefund\":true,\"categoryId\":\"0\",\"categoryName\":\"0\",\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isSendGoods\\\": false, \\\"cartGoodsUid\\\": \\\"353ee7b7-98ac-4a06-942b-11995eb401fe\\\", \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"021503897\\\"}\",\"id\":250570594194613059,\"ignoreInOrderClose\":false,\"marketingCode\":\"0\",\"marketingType\":0,\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"originalProductType\":7,\"parentProductId\":\"0\",\"photoUrl\":\"\",\"productCode\":\"021503897\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"226650306125091606\",\"productName\":\"六个香辣小鸡腿\",\"productPicUrl\":\"https://picture.sandload.cn/1639359965618.png\",\"productPrice\":2400.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":2,\"productSharePrice\":1210.0,\"productSpec\":\"226650306125091606\",\"productSpecName\":\"六个香辣小鸡腿\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"salePrice\":1190.0,\"saleScorePrice\":0,\"settlementPrice\":1190.0,\"settlementScorePrice\":0,\"thirdProductId\":\"tj021503897\",\"userId\":\"\",\"weight\":0.00},{\"canRefund\":true,\"categoryId\":\"0\",\"categoryName\":\"0\",\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"isFixedProduct\\\": true, \\\"spuProductCode\\\": \\\"010200118\\\"}\",\"id\":250570594200904517,\"ignoreInOrderClose\":false,\"marketingCode\":\"0\",\"marketingType\":0,\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"originalProductType\":1,\"parentProductId\":\"226650306125091606_2\",\"photoUrl\":\"\",\"productCode\":\"010200118\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"226650195045241630\",\"productName\":\"小鸡腿\",\"productPicUrl\":\"https://picture.sandload.cn/1639010644221.png\",\"productPrice\":400.0,\"productProperty\":\"\",\"productQuantity\":6,\"productScorePrice\":0,\"productSeq\":0,\"productSharePrice\":201.0,\"productSpec\":\"226650195045241630\",\"productSpecName\":\"小鸡腿\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"salePrice\":198.0,\"saleScorePrice\":0,\"settlementPrice\":1190.0,\"settlementScorePrice\":0,\"thirdProductId\":\"tj010200118\",\"userId\":\"\",\"weight\":0.00},{\"canRefund\":true,\"categoryId\":\"0\",\"categoryName\":\"0\",\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isSendGoods\\\": false, \\\"cartGoodsUid\\\": \\\"f6279826-d598-4e3e-ae19-5c9f7522aedb\\\", \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"020805123\\\"}\",\"id\":250570594207195975,\"ignoreInOrderClose\":false,\"marketingCode\":\"0\",\"marketingType\":0,\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"originalProductType\":7,\"parentProductId\":\"0\",\"photoUrl\":\"\",\"productCode\":\"020805123\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"229893933386351900\",\"productName\":\"鸡米花2份\",\"productPicUrl\":\"https://picture.sandload.cn/1642047071104.jpg\",\"productPrice\":1600.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":3,\"productSharePrice\":700.0,\"productSpec\":\"229893933386351900\",\"productSpecName\":\"鸡米花2份\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"salePrice\":900.0,\"saleScorePrice\":0,\"settlementPrice\":900.0,\"settlementScorePrice\":0,\"thirdProductId\":\"tj020805123\",\"userId\":\"\",\"weight\":0.00},{\"canRefund\":true,\"categoryId\":\"0\",\"categoryName\":\"0\",\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"isFixedProduct\\\": true, \\\"spuProductCode\\\": \\\"010200001\\\"}\",\"id\":250570594213487433,\"ignoreInOrderClose\":false,\"marketingCode\":\"0\",\"marketingType\":0,\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"originalProductType\":1,\"parentProductId\":\"229893933386351900_3\",\"photoUrl\":\"\",\"productCode\":\"010200001\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"205116588443264314\",\"productName\":\"鸡米花\",\"productPicUrl\":\"https://picture.sandload.cn/1618387408140.jpg\",\"productPrice\":800.0,\"productProperty\":\"\",\"productQuantity\":2,\"productScorePrice\":0,\"productSeq\":0,\"productSharePrice\":350.0,\"productSpec\":\"205116588443264314\",\"productSpecName\":\"鸡米花\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"salePrice\":450.0,\"saleScorePrice\":0,\"settlementPrice\":900.0,\"settlementScorePrice\":0,\"thirdProductId\":\"tj010200001\",\"userId\":\"\",\"weight\":0.00},{\"canRefund\":true,\"categoryId\":\"0\",\"categoryName\":\"0\",\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isSendGoods\\\": false, \\\"cartGoodsUid\\\": \\\"11dea04f-9dbc-4f7e-b277-5e6cf387f5cc\\\", \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"020805079\\\"}\",\"id\":250570594219778891,\"ignoreInOrderClose\":false,\"marketingCode\":\"0\",\"marketingType\":0,\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"originalProductType\":7,\"parentProductId\":\"0\",\"photoUrl\":\"\",\"productCode\":\"020805079\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"229924916440378431\",\"productName\":\"香辣鸡腿堡2份\",\"productPicUrl\":\"https://picture.sandload.cn/1642076939042.jpg\",\"productPrice\":2200.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":4,\"productSharePrice\":1000.0,\"productSpec\":\"229924916440378431\",\"productSpecName\":\"香辣鸡腿堡2份\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"salePrice\":1200.0,\"saleScorePrice\":0,\"settlementPrice\":1200.0,\"settlementScorePrice\":0,\"thirdProductId\":\"tj020805079\",\"userId\":\"\",\"weight\":0.00},{\"canRefund\":true,\"categoryId\":\"0\",\"categoryName\":\"0\",\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"isFixedProduct\\\": true, \\\"spuProductCode\\\": \\\"010100001\\\"}\",\"id\":250570594228167501,\"ignoreInOrderClose\":false,\"marketingCode\":\"0\",\"marketingType\":0,\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"originalProductType\":1,\"parentProductId\":\"229924916440378431_4\",\"photoUrl\":\"\",\"productCode\":\"010100001\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"205061623490055194\",\"productName\":\"香辣鸡腿堡\",\"productPicUrl\":\"https://picture.sandload.cn/1618365464768.jpg\",\"productPrice\":1100.0,\"productProperty\":\"\",\"productQuantity\":2,\"productScorePrice\":0,\"productSeq\":0,\"productSharePrice\":500.0,\"productSpec\":\"205061623490055194\",\"productSpecName\":\"香辣鸡腿堡\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"salePrice\":600.0,\"saleScorePrice\":0,\"settlementPrice\":1200.0,\"settlementScorePrice\":0,\"thirdProductId\":\"tj010100001\",\"userId\":\"\",\"weight\":0.00}],\"orderPayItemCreateReqList\":[{\"cardCode\":\"\",\"fmTradeNo\":\"8802581250570594402293008\",\"id\":250570594891893814,\"operator\":\"\",\"orderCode\":\"25057059417364153500004\",\"orderId\":250570594173641535,\"outOrderNo\":\"\",\"partnerId\":\"2581\",\"payAmount\":1080.0,\"payChannelName\":\"支付宝\",\"payChannelType\":\"2\",\"payState\":3,\"storeId\":\"999999_01056\",\"transId\":\"461599682057850883\"},{\"cardCode\":\"\",\"fmTradeNo\":\"\",\"id\":250570594892942391,\"operator\":\"\",\"orderCode\":\"25057059417364153500004\",\"orderId\":250570594173641535,\"outOrderNo\":\"\",\"partnerId\":\"2581\",\"payAmount\":2710.0,\"payChannelName\":\"储值卡\",\"payChannelType\":\"3\",\"payState\":3,\"storeId\":\"999999_01056\",\"transId\":\"461599682057850881\"}],\"orderSendCouponRespList\":[],\"orderSettlementDetailList\":[{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"MEHG2022062014460062935\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"加价购\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"0\",\"productSeq\":0,\"prospectiveAmount\":0.0,\"settlementAmount\":-1000.0,\"settlementType\":46,\"shopAmount\":0.0,\"shopDiscountAmount\":-1000.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"MEHG2022062014460062935\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"加价购\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"205873819584334365\",\"productSeq\":1,\"prospectiveAmount\":0.0,\"settlementAmount\":1000.0,\"settlementType\":46,\"shopAmount\":0.0,\"shopDiscountAmount\":1000.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"setMeal\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"套餐商品优惠\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"0\",\"productSeq\":0,\"prospectiveAmount\":0.0,\"settlementAmount\":-2910.0,\"settlementType\":211,\"shopAmount\":0.0,\"shopDiscountAmount\":-2910.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"setMeal\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"套餐商品优惠\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"226650306125091606\",\"productSeq\":2,\"prospectiveAmount\":0.0,\"settlementAmount\":1210.0,\"settlementType\":211,\"shopAmount\":0.0,\"shopDiscountAmount\":1210.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"setMeal\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"套餐商品优惠\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"229893933386351900\",\"productSeq\":3,\"prospectiveAmount\":0.0,\"settlementAmount\":700.0,\"settlementType\":211,\"shopAmount\":0.0,\"shopDiscountAmount\":700.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"setMeal\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"套餐商品优惠\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"229924916440378431\",\"productSeq\":4,\"prospectiveAmount\":0.0,\"settlementAmount\":1000.0,\"settlementType\":211,\"shopAmount\":0.0,\"shopDiscountAmount\":1000.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"205873819584334365\",\"productSeq\":1,\"prospectiveAmount\":0.0,\"settlementAmount\":1000.0,\"settlementType\":0,\"shopAmount\":0.0,\"shopDiscountAmount\":1000.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"226650306125091606\",\"productSeq\":2,\"prospectiveAmount\":0.0,\"settlementAmount\":1210.0,\"settlementType\":0,\"shopAmount\":0.0,\"shopDiscountAmount\":1210.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":6,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"226650195045241630\",\"productSeq\":0,\"prospectiveAmount\":0.0,\"settlementAmount\":1210.0,\"settlementType\":0,\"shopAmount\":0.0,\"shopDiscountAmount\":1210.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"229893933386351900\",\"productSeq\":3,\"prospectiveAmount\":0.0,\"settlementAmount\":700.0,\"settlementType\":0,\"shopAmount\":0.0,\"shopDiscountAmount\":700.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":2,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"205116588443264314\",\"productSeq\":0,\"prospectiveAmount\":0.0,\"settlementAmount\":700.0,\"settlementType\":0,\"shopAmount\":0.0,\"shopDiscountAmount\":700.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"229924916440378431\",\"productSeq\":4,\"prospectiveAmount\":0.0,\"settlementAmount\":1000.0,\"settlementType\":0,\"shopAmount\":0.0,\"shopDiscountAmount\":1000.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":2,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"205061623490055194\",\"productSeq\":0,\"prospectiveAmount\":0.0,\"settlementAmount\":1000.0,\"settlementType\":0,\"shopAmount\":0.0,\"shopDiscountAmount\":1000.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"优惠总金额\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":0,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"0\",\"productSeq\":0,\"prospectiveAmount\":0.0,\"settlementAmount\":3790.0,\"settlementType\":205,\"shopAmount\":0.0,\"shopDiscountAmount\":3910.0}],\"orderState\":3,\"orderSubState\":0,\"orderType\":5,\"orderVersion\":1,\"originalAmount\":7700.0,\"originalScoreAmount\":0,\"parentCode\":\"0\",\"partnerId\":\"2581\",\"partnerName\":\"\",\"payChannel\":\"10212\",\"payChannelName\":\"混合支付\",\"payChannelType\":4,\"payRequestNo\":\"8802581250570594402293008\",\"payState\":2,\"payTime\":1659004349000,\"payType\":1,\"physicalGoodsFlag\":0,\"pickUpGoodsNo\":\"5772\",\"posCode\":\"\",\"posTableKey\":\"\",\"printNum\":0,\"settlementAmount\":3790.0,\"settlementScoreAmount\":0,\"sourceType\":0,\"storeId\":\"999999_01056\",\"storeName\":\"华莱士（果园北道店）\",\"storeUnifyId\":\"0\",\"suspendDesc\":\"售中取消挂起\",\"suspendState\":3,\"thirdOrderCode\":\"25057059417364153500004\",\"thirdStoreId\":\"999999_01056\",\"toStoreId\":\"0\",\"updateTime\":1659004492000,\"userId\":\"3624007194908712536\",\"userMobile\":\"\",\"userName\":\"\",\"weight\":0.00}",
                new TypeReference<OrderInfoReqs>() {})

        def orderBean = orderCenterSdkAdapter.convent2NEWOrderInfo(orderInfo)


        def listBaseResponse = JSON.parseObject("{\"code\":\"100\",\"message\":\"成功\",\"result\":[{\"actualAmount\":3790.0,\"actualScoreAmount\":0,\"adultRemark\":\"\",\"afterSalesApplyClient\":0,\"afterSalesCode\":\"25057073866525960500004\",\"afterSalesImages\":[],\"afterSalesOptHistoryList\":[{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"id\":250570738679939678,\"operationClient\":0,\"operationCode\":1,\"operationDesc\":\"发起售后申请\",\"operator\":\"\",\"orderCode\":\"25057059417364153500004\",\"partnerId\":\"2581\",\"targetAfterSalesState\":1,\"timeout\":0,\"updateTime\":1659004477000},{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004492000,\"id\":250570754282785835,\"operationClient\":1,\"operationCode\":4,\"operationDesc\":\"退货完成\",\"operator\":\"pos\",\"orderCode\":\"25057059417364153500004\",\"partnerId\":\"2581\",\"targetAfterSalesState\":4,\"timeout\":0,\"updateTime\":1659004492000}],\"afterSalesOrderItems\":[{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isSendGoods\\\": false, \\\"cartGoodsUid\\\": \\\"353ee7b7-98ac-4a06-942b-11995eb401fe\\\", \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"021503897\\\"}\",\"id\":250570738667356758,\"orderCode\":\"25057059417364153500004\",\"orderItemId\":250570594194613059,\"parentProductId\":\"0\",\"partnerId\":\"2581\",\"productId\":\"226650306125091606\",\"productName\":\"六个香辣小鸡腿\",\"productPicUrl\":\"https://picture.sandload.cn/1639359965618.png\",\"productPrice\":1190.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":2,\"productSpec\":\"226650306125091606\",\"productSpecName\":\"六个香辣小鸡腿\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"thirdProductId\":\"tj021503897\",\"updateTime\":1659004477000,\"weight\":0.00},{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"extInfo\":\"{\\\"tax\\\": 0, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"010300040\\\"}\",\"id\":250570738669453911,\"orderCode\":\"25057059417364153500004\",\"orderItemId\":250570594188321601,\"parentProductId\":\"0\",\"partnerId\":\"2581\",\"productId\":\"205873819584334365\",\"productName\":\"韩式炸鸡桶\",\"productPicUrl\":\"https://picture.sandload.cn/1623721168081.jpg\",\"productPrice\":500.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":1,\"productSpec\":\"205873819584334365\",\"productSpecName\":\"韩式炸鸡桶\",\"productType\":1,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"thirdProductId\":\"tj010300040\",\"updateTime\":1659004477000,\"weight\":0.00},{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"isFixedProduct\\\": true, \\\"spuProductCode\\\": \\\"010200118\\\"}\",\"id\":250570738670502488,\"orderCode\":\"25057059417364153500004\",\"orderItemId\":250570594200904517,\"parentProductId\":\"226650306125091606_2\",\"partnerId\":\"2581\",\"productId\":\"226650195045241630\",\"productName\":\"小鸡腿\",\"productPicUrl\":\"https://picture.sandload.cn/1639010644221.png\",\"productPrice\":198.0,\"productProperty\":\"\",\"productQuantity\":6,\"productScorePrice\":0,\"productSeq\":0,\"productSpec\":\"226650195045241630\",\"productSpecName\":\"小鸡腿\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"thirdProductId\":\"tj010200118\",\"updateTime\":1659004477000,\"weight\":0.00},{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isSendGoods\\\": false, \\\"cartGoodsUid\\\": \\\"f6279826-d598-4e3e-ae19-5c9f7522aedb\\\", \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"020805123\\\"}\",\"id\":250570738671551065,\"orderCode\":\"25057059417364153500004\",\"orderItemId\":250570594207195975,\"parentProductId\":\"0\",\"partnerId\":\"2581\",\"productId\":\"229893933386351900\",\"productName\":\"鸡米花2份\",\"productPicUrl\":\"https://picture.sandload.cn/1642047071104.jpg\",\"productPrice\":900.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":3,\"productSpec\":\"229893933386351900\",\"productSpecName\":\"鸡米花2份\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"thirdProductId\":\"tj020805123\",\"updateTime\":1659004477000,\"weight\":0.00},{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"isFixedProduct\\\": true, \\\"spuProductCode\\\": \\\"010100001\\\"}\",\"id\":250570738672599642,\"orderCode\":\"25057059417364153500004\",\"orderItemId\":250570594228167501,\"parentProductId\":\"229924916440378431_4\",\"partnerId\":\"2581\",\"productId\":\"205061623490055194\",\"productName\":\"香辣鸡腿堡\",\"productPicUrl\":\"https://picture.sandload.cn/1618365464768.jpg\",\"productPrice\":600.0,\"productProperty\":\"\",\"productQuantity\":2,\"productScorePrice\":0,\"productSeq\":0,\"productSpec\":\"205061623490055194\",\"productSpecName\":\"香辣鸡腿堡\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"thirdProductId\":\"tj010100001\",\"updateTime\":1659004477000,\"weight\":0.00},{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"isFixedProduct\\\": true, \\\"spuProductCode\\\": \\\"010200001\\\"}\",\"id\":250570738673648219,\"orderCode\":\"25057059417364153500004\",\"orderItemId\":250570594213487433,\"parentProductId\":\"229893933386351900_3\",\"partnerId\":\"2581\",\"productId\":\"205116588443264314\",\"productName\":\"鸡米花\",\"productPicUrl\":\"https://picture.sandload.cn/1618387408140.jpg\",\"productPrice\":450.0,\"productProperty\":\"\",\"productQuantity\":2,\"productScorePrice\":0,\"productSeq\":0,\"productSpec\":\"205116588443264314\",\"productSpecName\":\"鸡米花\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"thirdProductId\":\"tj010200001\",\"updateTime\":1659004477000,\"weight\":0.00},{\"afterSalesCode\":\"25057073866525960500004\",\"createTime\":1659004477000,\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isSendGoods\\\": false, \\\"cartGoodsUid\\\": \\\"11dea04f-9dbc-4f7e-b277-5e6cf387f5cc\\\", \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"020805079\\\"}\",\"id\":250570738674696796,\"orderCode\":\"25057059417364153500004\",\"orderItemId\":250570594219778891,\"parentProductId\":\"0\",\"partnerId\":\"2581\",\"productId\":\"229924916440378431\",\"productName\":\"香辣鸡腿堡2份\",\"productPicUrl\":\"https://picture.sandload.cn/1642076939042.jpg\",\"productPrice\":1200.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":4,\"productSpec\":\"229924916440378431\",\"productSpecName\":\"香辣鸡腿堡2份\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"thirdProductId\":\"tj020805079\",\"updateTime\":1659004477000,\"weight\":0.00}],\"afterSalesReason\":\"下错单\",\"afterSalesStatus\":4,\"afterSalesType\":2,\"createTime\":1659004477000,\"deliveryAmount\":0.0,\"deliveryContactInfo\":[],\"expressChannelCode\":\"\",\"expressChannelName\":\"\",\"expressNo\":\"\",\"extInfo\":\"{\\\"lastOrderStatus\\\": 3}\",\"hasCargo\":false,\"isAllItemAfterSales\":true,\"operator\":\"pos\",\"orderCode\":\"25057059417364153500004\",\"orderInfo\":{\"abnormalDesc\":\"\",\"abnormalState\":0,\"acceptTime\":1659004361000,\"actualPayAmount\":1080.0,\"appId\":\"2021002109662866\",\"barCounter\":\"\",\"bizType\":1,\"businessDay\":1658937600000,\"canRefund\":true,\"cancelReason\":\"下错单\",\"companySelfCode\":\"\",\"createTime\":1659004340000,\"daySeq\":32,\"deliveryContactInfoList\":[{\"addressDetail\":\"天津市北辰区果园北道与商业局东路交口\",\"city\":\"\",\"contactsName\":\"\",\"expressNo\":\"0\",\"extInfo\":\"{}\",\"infoType\":1,\"latitude\":0E-7,\"longitude\":0E-7,\"mobile\":\"15222622053\",\"province\":\"\",\"region\":\"\",\"relateObjectType\":1,\"street\":\"\",\"telephone\":\"\",\"thirdDeliveryId\":\"0\",\"tripDist\":0}],\"deliveryPromise\":0,\"deliveryState\":-2,\"dinersNumber\":0,\"downstreamPosCode\":\"0\",\"downstreamThirdOrderCode\":\"0\",\"evaluationState\":0,\"expressChannelCode\":\"\",\"expressChannelName\":\"\",\"expressNo\":\"\",\"expressType\":0,\"extInfo\":\"{\\\"fmId\\\": \\\"8802581250570594402293008\\\", \\\"appid\\\": \\\"2021002109662866\\\", \\\"formId\\\": \\\"MjA4ODgxMjUxMzc2MTU1NF8xNjU5MDA0MzM5NjQ5XzA1OQ==\\\", \\\"openid\\\": \\\"2088812513761554\\\", \\\"payDate\\\": \\\"2022-07-28 18:32:28\\\", \\\"version\\\": \\\"2.0.651\\\", \\\"prepayId\\\": \\\"2022072822001461551417120994\\\", \\\"fromAppId\\\": \\\"2021002109662866\\\", \\\"sessionId\\\": \\\"02268690d5cf6efa2a3f9a1dc08c569a359c45f2\\\", \\\"endTransId\\\": \\\"10024066479262207281832206428006\\\", \\\"paidMember\\\": false, \\\"payTransId\\\": \\\"8802581250570594402293008\\\", \\\"sessionKey\\\": \\\"\\\", \\\"totalScore\\\": 0, \\\"memberLevel\\\": \\\"\\\", \\\"serviceTime\\\": 50, \\\"dispatchType\\\": \\\"0\\\", \\\"pushOrderTime\\\": 0, \\\"dispatchTimeout\\\": 0, \\\"deliveryHoursDayEnd\\\": \\\"\\\", \\\"deliveryHoursDayStart\\\": \\\"\\\", \\\"packageAmountCollectType\\\": 1}\",\"immediately\":true,\"isParent\":false,\"localTableKey\":\"\",\"logisticsAccessChannel\":0,\"logisticsList\":[],\"marketingCode\":\"\",\"marketingType\":0,\"needInvoice\":false,\"note\":\"\",\"operator\":\"\",\"orderArea\":\"0\",\"orderClient\":3,\"orderCode\":\"25057059417364153500004\",\"orderCostDetailList\":[],\"orderExtended\":{\"agentPayerId\":\"\",\"agentPayerName\":\"\",\"createTime\":1659004340000,\"id\":250570594173641535,\"isDeleted\":false,\"orderClientGroup\":\"督导林爽\",\"orderClientGroupCode\":\"210204\",\"orderCode\":\"25057059417364153500004\",\"orderId\":250570594173641535,\"partnerId\":\"2581\",\"sendWord\":\"\",\"spellGroupCode\":\"\",\"storeId\":\"999999_01056\",\"storeNameEn\":\"\",\"updateTime\":1659004340000,\"userPhone\":\"\",\"version\":0},\"orderInvoice\":{\"address\":\"\",\"bankCardNo\":\"\",\"content\":\"\",\"invoiceBank\":\"\",\"invoiceNo\":\"\",\"invoiceUrl\":\"\",\"itemId\":\"\",\"partnerId\":\"\",\"phoneNo\":\"\",\"pickUpNo\":\"\",\"taxNo\":\"\",\"title\":\"\",\"userId\":\"\"},\"orderItemList\":[{\"canRefund\":true,\"categoryId\":\"0\",\"categoryName\":\"0\",\"extInfo\":\"{\\\"tax\\\": 0, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"010300040\\\"}\",\"id\":250570594188321601,\"ignoreInOrderClose\":false,\"marketingCode\":\"0\",\"marketingType\":0,\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"originalProductType\":1,\"parentProductId\":\"0\",\"photoUrl\":\"\",\"productCode\":\"010300040\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"205873819584334365\",\"productName\":\"韩式炸鸡桶\",\"productPicUrl\":\"https://picture.sandload.cn/1623721168081.jpg\",\"productPrice\":1500.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":1,\"productSharePrice\":1000.0,\"productSpec\":\"205873819584334365\",\"productSpecName\":\"韩式炸鸡桶\",\"productType\":1,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"salePrice\":500.0,\"saleScorePrice\":0,\"settlementPrice\":500.0,\"settlementScorePrice\":0,\"thirdProductId\":\"tj010300040\",\"userId\":\"\",\"weight\":0.00},{\"canRefund\":true,\"categoryId\":\"0\",\"categoryName\":\"0\",\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isSendGoods\\\": false, \\\"cartGoodsUid\\\": \\\"353ee7b7-98ac-4a06-942b-11995eb401fe\\\", \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"021503897\\\"}\",\"id\":250570594194613059,\"ignoreInOrderClose\":false,\"marketingCode\":\"0\",\"marketingType\":0,\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"originalProductType\":7,\"parentProductId\":\"0\",\"photoUrl\":\"\",\"productCode\":\"021503897\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"226650306125091606\",\"productName\":\"六个香辣小鸡腿\",\"productPicUrl\":\"https://picture.sandload.cn/1639359965618.png\",\"productPrice\":2400.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":2,\"productSharePrice\":1210.0,\"productSpec\":\"226650306125091606\",\"productSpecName\":\"六个香辣小鸡腿\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"salePrice\":1190.0,\"saleScorePrice\":0,\"settlementPrice\":1190.0,\"settlementScorePrice\":0,\"thirdProductId\":\"tj021503897\",\"userId\":\"\",\"weight\":0.00},{\"canRefund\":true,\"categoryId\":\"0\",\"categoryName\":\"0\",\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"isFixedProduct\\\": true, \\\"spuProductCode\\\": \\\"010200118\\\"}\",\"id\":250570594200904517,\"ignoreInOrderClose\":false,\"marketingCode\":\"0\",\"marketingType\":0,\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"originalProductType\":1,\"parentProductId\":\"226650306125091606_2\",\"photoUrl\":\"\",\"productCode\":\"010200118\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"226650195045241630\",\"productName\":\"小鸡腿\",\"productPicUrl\":\"https://picture.sandload.cn/1639010644221.png\",\"productPrice\":400.0,\"productProperty\":\"\",\"productQuantity\":6,\"productScorePrice\":0,\"productSeq\":0,\"productSharePrice\":201.0,\"productSpec\":\"226650195045241630\",\"productSpecName\":\"小鸡腿\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"salePrice\":198.0,\"saleScorePrice\":0,\"settlementPrice\":1190.0,\"settlementScorePrice\":0,\"thirdProductId\":\"tj010200118\",\"userId\":\"\",\"weight\":0.00},{\"canRefund\":true,\"categoryId\":\"0\",\"categoryName\":\"0\",\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isSendGoods\\\": false, \\\"cartGoodsUid\\\": \\\"f6279826-d598-4e3e-ae19-5c9f7522aedb\\\", \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"020805123\\\"}\",\"id\":250570594207195975,\"ignoreInOrderClose\":false,\"marketingCode\":\"0\",\"marketingType\":0,\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"originalProductType\":7,\"parentProductId\":\"0\",\"photoUrl\":\"\",\"productCode\":\"020805123\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"229893933386351900\",\"productName\":\"鸡米花2份\",\"productPicUrl\":\"https://picture.sandload.cn/1642047071104.jpg\",\"productPrice\":1600.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":3,\"productSharePrice\":700.0,\"productSpec\":\"229893933386351900\",\"productSpecName\":\"鸡米花2份\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"salePrice\":900.0,\"saleScorePrice\":0,\"settlementPrice\":900.0,\"settlementScorePrice\":0,\"thirdProductId\":\"tj020805123\",\"userId\":\"\",\"weight\":0.00},{\"canRefund\":true,\"categoryId\":\"0\",\"categoryName\":\"0\",\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"isFixedProduct\\\": true, \\\"spuProductCode\\\": \\\"010200001\\\"}\",\"id\":250570594213487433,\"ignoreInOrderClose\":false,\"marketingCode\":\"0\",\"marketingType\":0,\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"originalProductType\":1,\"parentProductId\":\"229893933386351900_3\",\"photoUrl\":\"\",\"productCode\":\"010200001\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"205116588443264314\",\"productName\":\"鸡米花\",\"productPicUrl\":\"https://picture.sandload.cn/1618387408140.jpg\",\"productPrice\":800.0,\"productProperty\":\"\",\"productQuantity\":2,\"productScorePrice\":0,\"productSeq\":0,\"productSharePrice\":350.0,\"productSpec\":\"205116588443264314\",\"productSpecName\":\"鸡米花\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"salePrice\":450.0,\"saleScorePrice\":0,\"settlementPrice\":900.0,\"settlementScorePrice\":0,\"thirdProductId\":\"tj010200001\",\"userId\":\"\",\"weight\":0.00},{\"canRefund\":true,\"categoryId\":\"0\",\"categoryName\":\"0\",\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isSendGoods\\\": false, \\\"cartGoodsUid\\\": \\\"11dea04f-9dbc-4f7e-b277-5e6cf387f5cc\\\", \\\"isB3S1Coupon\\\": 0, \\\"spuProductCode\\\": \\\"020805079\\\"}\",\"id\":250570594219778891,\"ignoreInOrderClose\":false,\"marketingCode\":\"0\",\"marketingType\":0,\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"originalProductType\":7,\"parentProductId\":\"0\",\"photoUrl\":\"\",\"productCode\":\"020805079\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"229924916440378431\",\"productName\":\"香辣鸡腿堡2份\",\"productPicUrl\":\"https://picture.sandload.cn/1642076939042.jpg\",\"productPrice\":2200.0,\"productProperty\":\"\",\"productQuantity\":1,\"productScorePrice\":0,\"productSeq\":4,\"productSharePrice\":1000.0,\"productSpec\":\"229924916440378431\",\"productSpecName\":\"香辣鸡腿堡2份\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"salePrice\":1200.0,\"saleScorePrice\":0,\"settlementPrice\":1200.0,\"settlementScorePrice\":0,\"thirdProductId\":\"tj020805079\",\"userId\":\"\",\"weight\":0.00},{\"canRefund\":true,\"categoryId\":\"0\",\"categoryName\":\"0\",\"extInfo\":\"{\\\"tax\\\": 0.01, \\\"stapleFood\\\": 0, \\\"isMonthCard\\\": 0, \\\"isB3S1Coupon\\\": 0, \\\"isFixedProduct\\\": true, \\\"spuProductCode\\\": \\\"010100001\\\"}\",\"id\":250570594228167501,\"ignoreInOrderClose\":false,\"marketingCode\":\"0\",\"marketingType\":0,\"nickName\":\"\",\"note\":\"\",\"openId\":\"\",\"originalProductType\":1,\"parentProductId\":\"229924916440378431_4\",\"photoUrl\":\"\",\"productCode\":\"010100001\",\"productForeignName\":\"\",\"productForeignProperty\":\"\",\"productForeignSpecName\":\"\",\"productId\":\"205061623490055194\",\"productName\":\"香辣鸡腿堡\",\"productPicUrl\":\"https://picture.sandload.cn/1618365464768.jpg\",\"productPrice\":1100.0,\"productProperty\":\"\",\"productQuantity\":2,\"productScorePrice\":0,\"productSeq\":0,\"productSharePrice\":500.0,\"productSpec\":\"205061623490055194\",\"productSpecName\":\"香辣鸡腿堡\",\"productType\":6,\"productUnit\":\"\",\"productUpc\":\"\",\"productWeightUnit\":0,\"salePrice\":600.0,\"saleScorePrice\":0,\"settlementPrice\":1200.0,\"settlementScorePrice\":0,\"thirdProductId\":\"tj010100001\",\"userId\":\"\",\"weight\":0.00}],\"orderPayItemCreateReqList\":[{\"cardCode\":\"\",\"fmTradeNo\":\"8802581250570594402293008\",\"id\":250570594891893814,\"operator\":\"\",\"orderCode\":\"25057059417364153500004\",\"orderId\":250570594173641535,\"outOrderNo\":\"\",\"partnerId\":\"2581\",\"payAmount\":1080.0,\"payChannelName\":\"支付宝\",\"payChannelType\":\"2\",\"payState\":3,\"storeId\":\"999999_01056\",\"transId\":\"461599682057850883\"},{\"cardCode\":\"\",\"fmTradeNo\":\"\",\"id\":250570594892942391,\"operator\":\"\",\"orderCode\":\"25057059417364153500004\",\"orderId\":250570594173641535,\"outOrderNo\":\"\",\"partnerId\":\"2581\",\"payAmount\":2710.0,\"payChannelName\":\"储值卡\",\"payChannelType\":\"3\",\"payState\":3,\"storeId\":\"999999_01056\",\"transId\":\"461599682057850881\"}],\"orderSendCouponRespList\":[],\"orderSettlementDetailList\":[{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"MEHG2022062014460062935\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"加价购\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"0\",\"productSeq\":0,\"prospectiveAmount\":0.0,\"settlementAmount\":-1000.0,\"settlementType\":46,\"shopAmount\":0.0,\"shopDiscountAmount\":-1000.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"MEHG2022062014460062935\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"加价购\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"205873819584334365\",\"productSeq\":1,\"prospectiveAmount\":0.0,\"settlementAmount\":1000.0,\"settlementType\":46,\"shopAmount\":0.0,\"shopDiscountAmount\":1000.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"setMeal\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"套餐商品优惠\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"0\",\"productSeq\":0,\"prospectiveAmount\":0.0,\"settlementAmount\":-2910.0,\"settlementType\":211,\"shopAmount\":0.0,\"shopDiscountAmount\":-2910.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"setMeal\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"套餐商品优惠\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"226650306125091606\",\"productSeq\":2,\"prospectiveAmount\":0.0,\"settlementAmount\":1210.0,\"settlementType\":211,\"shopAmount\":0.0,\"shopDiscountAmount\":1210.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"setMeal\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"套餐商品优惠\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"229893933386351900\",\"productSeq\":3,\"prospectiveAmount\":0.0,\"settlementAmount\":700.0,\"settlementType\":211,\"shopAmount\":0.0,\"shopDiscountAmount\":700.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"setMeal\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"套餐商品优惠\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"229924916440378431\",\"productSeq\":4,\"prospectiveAmount\":0.0,\"settlementAmount\":1000.0,\"settlementType\":211,\"shopAmount\":0.0,\"shopDiscountAmount\":1000.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"205873819584334365\",\"productSeq\":1,\"prospectiveAmount\":0.0,\"settlementAmount\":1000.0,\"settlementType\":0,\"shopAmount\":0.0,\"shopDiscountAmount\":1000.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"226650306125091606\",\"productSeq\":2,\"prospectiveAmount\":0.0,\"settlementAmount\":1210.0,\"settlementType\":0,\"shopAmount\":0.0,\"shopDiscountAmount\":1210.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":6,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"226650195045241630\",\"productSeq\":0,\"prospectiveAmount\":0.0,\"settlementAmount\":1210.0,\"settlementType\":0,\"shopAmount\":0.0,\"shopDiscountAmount\":1210.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"229893933386351900\",\"productSeq\":3,\"prospectiveAmount\":0.0,\"settlementAmount\":700.0,\"settlementType\":0,\"shopAmount\":0.0,\"shopDiscountAmount\":700.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":2,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"205116588443264314\",\"productSeq\":0,\"prospectiveAmount\":0.0,\"settlementAmount\":700.0,\"settlementType\":0,\"shopAmount\":0.0,\"shopDiscountAmount\":700.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":1,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"229924916440378431\",\"productSeq\":4,\"prospectiveAmount\":0.0,\"settlementAmount\":1000.0,\"settlementType\":0,\"shopAmount\":0.0,\"shopDiscountAmount\":1000.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":2,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"205061623490055194\",\"productSeq\":0,\"prospectiveAmount\":0.0,\"settlementAmount\":1000.0,\"settlementType\":0,\"shopAmount\":0.0,\"shopDiscountAmount\":1000.0},{\"agentDiscountAmount\":0.0,\"carrierDiscountAmount\":0.0,\"extInfo\":\"\",\"externalObjectId\":\"\",\"externalObjectName\":\"优惠总金额\",\"externalObjectSubId\":\"\",\"ignoreInDiscountAmount\":false,\"isOnline\":true,\"note\":\"\",\"number\":0,\"platformDiscountAmount\":0.0,\"platformServiceAmount\":0.0,\"productId\":\"0\",\"productSeq\":0,\"prospectiveAmount\":0.0,\"settlementAmount\":3790.0,\"settlementType\":205,\"shopAmount\":0.0,\"shopDiscountAmount\":3910.0}],\"orderState\":3,\"orderSubState\":0,\"orderType\":5,\"orderVersion\":1,\"originalAmount\":7700.0,\"originalScoreAmount\":0,\"parentCode\":\"0\",\"partnerId\":\"2581\",\"partnerName\":\"\",\"payChannel\":\"10212\",\"payChannelName\":\"混合支付\",\"payChannelType\":4,\"payRequestNo\":\"8802581250570594402293008\",\"payState\":2,\"payTime\":1659004349000,\"payType\":1,\"physicalGoodsFlag\":0,\"pickUpGoodsNo\":\"5772\",\"posCode\":\"\",\"posTableKey\":\"\",\"printNum\":0,\"settlementAmount\":3790.0,\"settlementScoreAmount\":0,\"sourceType\":0,\"storeId\":\"999999_01056\",\"storeName\":\"华莱士（果园北道店）\",\"storeUnifyId\":\"0\",\"suspendDesc\":\"售中取消挂起\",\"suspendState\":3,\"thirdOrderCode\":\"25057059417364153500004\",\"thirdStoreId\":\"999999_01056\",\"toStoreId\":\"0\",\"updateTime\":1659004492000,\"userId\":\"3624007194908712536\",\"userMobile\":\"\",\"userName\":\"\",\"weight\":0.00},\"originalShippingFee\":0.0,\"partnerId\":\"2581\",\"partnerRefundCode\":\"\",\"refundFailReason\":\"\",\"refundState\":2,\"reqAmount\":3790.0,\"reqRemark\":\"Hh \",\"reqScoreAmount\":0,\"settlementShippingFee\":0.0,\"thirdRefundCode\":\"\",\"updateTime\":1659004492000,\"weight\":0.00}],\"ver\":\"1\"}",
                new TypeReference<OrderBaseResp<List<AfterSalesOrderResp>>>() {})

        def payQueryOrderResponse = JSON.parseObject("{\"code\":\"8200309\",\"message\":\"query order exception, order does not exist\"}",
                new TypeReference<BaseResponse<PaymentQueryOrderResponseDto>>() {})

        def wxAppStore = new AssortmentOpenPlatformIappWxappStore()

        def refundNewResponse = JSON.parseObject("{\"code\":10030,\"msg\":\"退款失败\"}",
                new TypeReference<BaseResponse<PayRefundData>>() {})

        /**
         * 混合支付
         */
        def multiOrderRefundResponse = JSON.parseObject("{\"code\":10030,\"msg\":\"退款失败\"}",
                new TypeReference<MultiOrderRefundResponse>() {})


        and: "调三方反馈参数 为自己的参数对象 "
        orderBaseService.getByOrderCode(_) >> orderBean
        redisCache.hashGet(_, _) >> ""
        orderBeanFactory.getOrderManagerService(_) >> saasOrderManagerServiceImpl
        paymentNewClient.payQueryOrder(_) >> payQueryOrderResponse
        assortmentOpenPlatformIappWxappStoreManager.selectWxappStoreByWxAppIdAndStoreId(_, _, _) >> wxAppStore
        paymentNewClient.payRefund(_) >> refundNewResponse
        orderSdkService.queryAfterSaleByOrderCode(_, _) >> listBaseResponse
        mulitiPaymentClient.paymentApplicationRefund(_, _) >> multiOrderRefundResponse
        when: "调用方法逻辑"
        orderManagerController.statusOperate(requestVo)
        then: "验证 返回结果"

    }
}
