package cn.freemud.service.adapter;

import cn.freemud.entities.bo.CreateOrderBONew;
import cn.freemud.entities.dto.StoreResponseDto;
import cn.freemud.entities.dto.store.BusinessInfoDto;
import cn.freemud.entities.dto.store.StoreMixResponseDto;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.enums.CreateOrderType;

import java.util.Objects;

/**
 * 外卖订单检查
 */
public class TakeOutOrderCheck extends AbstractOrderCheck {

    @Override
    public boolean support(int orderType) {
        return CreateOrderType.TAKE_OUT.getCode() == orderType;
    }


    @Override
    public void check(CreateOrderVo vo, StoreMixResponseDto storeMixResponseDto) {
        StoreResponseDto storeInfo = storeMixResponseDto.getStoreInfo();
        BusinessInfoDto businessInfo = storeMixResponseDto.getBusinessInfo();
        // 关闭预约单
        if (Objects.equals(businessInfo.getDeliveryAppoint(), 0)) {
            super.doStoreStateCheck(storeInfo);
        }
    }

    @Override
    public void check(CreateOrderBONew createOrderBONew) {
        StoreMixResponseDto storeMixResponseDto = createOrderBONew.getStoreMixResponseDto();
        StoreResponseDto storeInfo = storeMixResponseDto.getStoreInfo();
        BusinessInfoDto businessInfo = storeMixResponseDto.getBusinessInfo();
        // 关闭预约单
        if (Objects.equals(businessInfo.getDeliveryAppoint(), 0)) {
            super.doStoreStateCheck(storeInfo);
        }
    }

}
