package cn.freemud.entities.dto.promotion;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 活动限制商品list
 */
@ApiModel(description = "活动限制商品")
public class ActivityGoodsVO {
    private Long activityId;

    @ApiModelProperty(value = "商品id", name = "goodsId", example = "bingtangxueli")
    private String goodsId;

    @ApiModelProperty(value = "商品名", name = "goodsName", example = "冰糖雪梨")
    private String goodsName;

    @ApiModelProperty(value="商品CODE", name="goodsCode")
    private String goodsCode;

    @ApiModelProperty(value="spu商品名", name="goodsCodeName")
    private String goodsCodeName;

    @ApiModelProperty(value="商品UPC编码", name="goodsUpc")
    private String goodsUpc;

    @ApiModelProperty(value = "原价", name = "originalPrice", example = "2000")
    private Integer originalPrice;

    @ApiModelProperty(value = "现价（单品特价时：现价；N件减M元时 ,表示M元）", name = "nowPrice", example = "1800")
    private Integer nowPrice;

    @ApiModelProperty(value = "每单限购数量", name = "quantityLimit", example = "4")
    private Integer quantityLimit = 0;

    @ApiModelProperty(value = "满赠积分活动商品需满足的数量，eg：买M", name = "number", example = "3")
    private Integer number;

    @ApiModelProperty(value = "折扣率（百分制）", name = "rebate", example = "80")
    private Integer rebate;

    @ApiModelProperty(value = "是否可用", name = "isCanUse", example = "1")
    private Integer isCanUse;

    private Integer isShared;

    @ApiModelProperty(value = "一级分类", name = "firstCategory", example = "yinliao")
    private String firstCategory;

    @ApiModelProperty(value = "一级分类名", name = "firstCategoryName", example = "yinliao")
    private String firstCategoryName;

    @ApiModelProperty(value = "二级分类", name = "category", example = "yinliao")
    private String category;

    @ApiModelProperty(value = "二级分类名", name = "categoryName", example = "饮料")
    private String categoryName;

    @ApiModelProperty(value = "品牌", name = "brand", example = "tongyi")
    private String brand;

    @ApiModelProperty(value = "品牌名", name = "brandName", example = "统一")
    private String brandName;

    private Integer stock;

    @ApiModelProperty(value = "立减金额", name = "discountPrice", example = "500")
    private Integer discountPrice;

    @ApiModelProperty(value = "赠送积分", name = "integral", example = "10")
    private Integer integral;

    @ApiModelProperty(value = "满赠积分活动商品需满足的金额（分）", name = "amount", example = "1000")
    private Integer amount;

    @ApiModelProperty(value = "商品类型（0或null为计件商品，1为称重商品）", name = "goodsType", example = "1")
    private Short goodsType;

    @ApiModelProperty(value = "排序", name = "serialNumber", example = "99")
    private Integer serialNumber;

    @ApiModelProperty(value = "共享/不同享活动号")
    private List<String> shareActivityCodes;

    @ApiModelProperty(value = "共享/不同享活动类型")
    private List<Integer> shareActivityTypes;

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(String goodsId) {
        this.goodsId = goodsId;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public String getGoodsCode() {
        return goodsCode;
    }

    public void setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
    }

    public String getGoodsUpc() {
        return goodsUpc;
    }

    public void setGoodsUpc(String goodsUpc) {
        this.goodsUpc = goodsUpc;
    }

    public Integer getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(Integer originalPrice) {
        this.originalPrice = originalPrice;
    }

    public Integer getNowPrice() {
        return nowPrice;
    }

    public void setNowPrice(Integer nowPrice) {
        this.nowPrice = nowPrice;
    }

    public Integer getQuantityLimit() {
        return quantityLimit;
    }

    public void setQuantityLimit(Integer quantityLimit) {
        this.quantityLimit = quantityLimit;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public Integer getRebate() {
        return rebate;
    }

    public void setRebate(Integer rebate) {
        this.rebate = rebate;
    }

    public Integer getIsCanUse() {
        return isCanUse;
    }

    public void setIsCanUse(Integer isCanUse) {
        this.isCanUse = isCanUse;
    }

    public Integer getIsShared() {
        return isShared;
    }

    public void setIsShared(Integer isShared) {
        this.isShared = isShared;
    }

    public String getFirstCategory() {
        return firstCategory;
    }

    public void setFirstCategory(String firstCategory) {
        this.firstCategory = firstCategory;
    }

    public String getFirstCategoryName() {
        return firstCategoryName;
    }

    public void setFirstCategoryName(String firstCategoryName) {
        this.firstCategoryName = firstCategoryName;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Integer getStock() {
        return stock;
    }

    public void setStock(Integer stock) {
        this.stock = stock;
    }

    public Integer getDiscountPrice() {
        return discountPrice;
    }

    public void setDiscountPrice(Integer discountPrice) {
        this.discountPrice = discountPrice;
    }

    public Integer getIntegral() {
        return integral;
    }

    public void setIntegral(Integer integral) {
        this.integral = integral;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public Short getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(Short goodsType) {
        this.goodsType = goodsType;
    }

    public List<String> getShareActivityCodes() {
        return shareActivityCodes;
    }

    public void setShareActivityCodes(List<String> shareActivityCodes) {
        this.shareActivityCodes = shareActivityCodes;
    }

    public List<Integer> getShareActivityTypes() {
        return shareActivityTypes;
    }

    public void setShareActivityTypes(List<Integer> shareActivityTypes) {
        this.shareActivityTypes = shareActivityTypes;
    }

    public void setSerialNumber(Integer serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Integer getSerialNumber() {
        return serialNumber;
    }

    public String getGoodsCodeName() {
        return goodsCodeName;
    }

    public void setGoodsCodeName(String goodsCodeName) {
        this.goodsCodeName = goodsCodeName;
    }
}