package cn.freemud.service.thirdparty;


import cn.freemud.annotations.IgnoreFeignLogAnnotation;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.GetCouponDetailResponseDto;
import cn.freemud.entities.dto.coupon.CouponResponseDTO;
import cn.freemud.entities.dto.coupon.FastBatchQueryTemplateInfoRequest;
import cn.freemud.entities.dto.coupon.FastTemplateInfoResponseVO;
import cn.freemud.interceptor.FormSupportConfig;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

@FeignClient(name = "OPEN-STORE-ONLINE-COUPON-SERVICE", url = "${saas.coupononlineclient.feign.url}", configuration = FormSupportConfig.class)
public interface CouponOnlineClient {
    /**
     * 查询券详情  黑白名单接口
     */
    @IgnoreFeignLogAnnotation(logMessage = "getCouponDetails",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping(value = "/code_v4", produces = MediaType.APPLICATION_JSON_UTF8_VALUE,
            consumes = {MediaType.APPLICATION_FORM_URLENCODED_VALUE}
    )
    GetCouponDetailResponseDto getCouponDetails(@RequestParam Map<String, ?> map);

    /**
     *  新版 根据券模板查询 券基础信息数据
     * @param request
     * @return
     */
    @IgnoreFeignLogAnnotation(logMessage="fastBatchQueryTemplateInfo",messageFieldName= ResponseCodeKeyConstant.MSG,
            statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping(value = "/fastBatchQueryTemplateInfo")
    CouponResponseDTO<List<FastTemplateInfoResponseVO>> fastBatchQueryTemplateInfo(@RequestBody FastBatchQueryTemplateInfoRequest request);

}
