package com.freemud.application.sdk.api.ordercenter.enums.orderv1;

public enum RefundStatusV1 {

    //售后单状态 1:待处理 2:退货中 3:拒绝退款 4:已退货 5:完成 6:取消
    //退款状态  1 申请退款 2 同意退款 3 已退货 4 退款完成 5 拒绝退款

//    APPLY_REFUND(1, "申请退款"),
//    AGREE_REFUND(2, "同意退款"),
//    ALREADY_REFUND(3, "已退货"),
//    COMPLETE_REFUND(4, "退款完成"),
//    REFUSE_REFUND(5, "拒绝退款");


    PENDING(1,1,"待处理"),
    RETURNING(2,2,"退货中"),
    REJECTED( 3,5,"拒绝退款"),
    GOODS_RETURNED( 4,3,"已退货"),
    COMPLETE( 5,4,"完成"),
    CANCEL( 6,6,"取消");


    //售后单状态 1:待处理 2:退货中 3:拒绝退款 4:已退货 5:完成 6:取消
    //退款状态  1 申请退款 2 同意退款 3 已退货 4 退款完成 5 拒绝退款

    private Integer codeV2;
    private Integer codeV1;
    private String desc;

    RefundStatusV1(Integer codeV2, Integer codeV1, String desc) {
        this.codeV2 = codeV2;
        this.codeV1 = codeV1;
        this.desc = desc;
    }

    public static RefundStatusV1 getNewCodeByCodeV1(Integer codeV1) {
        for (RefundStatusV1 status : values()) {
            if (status.getCodeV1().equals(codeV1)) {
                return status;
            }
        }
        return null;
    }

    public static Integer getOldCodeByCodeV2(Integer codeV2) {
        Integer codeV1 = codeV2;
        for (RefundStatusV1 status : values()) {
            if (status.getCodeV2().equals(codeV2)) {
                codeV1 =  status.codeV1;
            }
        }
        return codeV1;
    }

    public Integer getCodeV2() {
        return codeV2;
    }

    public void setCodeV2(Integer codeV2) {
        this.codeV2 = codeV2;
    }

    public Integer getCodeV1() {
        return codeV1;
    }

    public void setCodeV1(Integer codeV1) {
        this.codeV1 = codeV1;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}
