/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ProductInfo
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: ping.wu
 * @date: 2019/11/26 13:13
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto.product;

import cn.freemud.entities.dto.ProductComboListDto;
import com.freemud.sdk.api.assortment.order.request.order.ProductBindingCouponType;
import lombok.Data;

import java.util.List;

@Data
public class ProductInfo {

    private String barcode;
    private String brandId;
    private String brandName;
    private String category;
    private String categoryName;
    private String companyId;
    private String customerCode;
    /**
     * 最终价格 单位分
     */
    private Long finalPrice;
    /**
     * 是否是SKU商品  1是0否
     */
    private Integer isSkuProduct;
    private String name;
    /**
     * 原始价格 单位分
     */
    private Long originalPrice;
    /**
     * 包装费 单位分
     */
    private Long packPrice;
    private String picture;
    private String pid;
    private Integer pknumber;
    private String productionLocation;
    private String remark;
    private Integer saleCount;
    private String sellTimeName;
    private Integer sequence;
    private String sourceChannel;
    private String specification;
    private String productCode;
    private Integer status;
    private Integer stock;
    private Integer stockLimit;
    /**
     * type=10 多规格  type=1 单规格
     */
    private int type;
    private String unit;
    private int updateStatus;
    private boolean valid;
    private int version;
    private List<ProductLabel> labelNames;
    private List<ProductAttributeGroup> productAttributeGroupList;
    private List<ProductGroup> productGroupList;
    private List<ProductComboListDto> productComboList;
    private List<ProductPicture> productPictureList;
    private List<?> productSpecification;
    private List<?> sellTimeList;
    private List<?> specificationList;
    //SKU
    private List<SkuProduct> skuList;
    //规格信息
    private List<SpecificationGroup> specificationGroupList;
    //Sku 规格 如果 当前是sku 则有值
    private List<SkuSpecValue> skuSpecValues;

    //用于标识虚拟商品是否限制购买数量,0-否、1-是
    private Integer isLimitNumProduct;

    //虚拟商品的券信息集合
    private List<ProductBindingCouponType> productBindingCouponTypes;

}
