package cn.freemud.adapter;

import cn.freemud.entities.dto.AddProductEvaluationReqDto;
import cn.freemud.entities.vo.AddUserOrderEvaluationNewRequestVo;
import cn.freemud.utils.EmojiUtil;
import cn.freemud.utils.UnicodeUtil;
import com.freemud.api.assortment.datamanager.entity.dto.InsertOrderEvaluationReqDto;
import com.freemud.api.assortment.datamanager.entity.dto.InsertProductEvaluationReqDto;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * All rights Reserved, Designed By www.freemud.com
 *
 * @version V1.0
 * @Title:
 * @Package: cn.freemud.adapter
 * @Descripttion:
 * @author: shuhu.hou
 * @date: 2019/8/12
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目.
 */
@Component
public class EvaluationAdapter {

    public InsertOrderEvaluationReqDto convent2InsertOrderEvaluationReqDto(AddUserOrderEvaluationNewRequestVo reqVo, OrderBeanV1 orderBean) {
        InsertOrderEvaluationReqDto request = new InsertOrderEvaluationReqDto();
        request.setCustomer_name(EmojiUtil.filterEmoji(orderBean.getUserName(),""));
        request.setCustomer_mobile(orderBean.getPhone());
        request.setCustomer_photo_url(reqVo.getCustomerPhotoUrl());
        request.setTaste(getDefaultValue(reqVo.getTaste()));
        request.setHealth(getDefaultValue(reqVo.getHealth()));
        request.setService(getDefaultValue(reqVo.getService()));
        request.setDelivery_speed(getDefaultValue(reqVo.getDeliverySpeed()));
        request.setSurroundings(getDefaultValue(reqVo.getSurroundings()));
        request.setEvaluation_content(UnicodeUtil.filterSpecialChars(reqVo.getEvaluationContent()));
        request.setCreate_order_time(new Date(orderBean.getGmtCreate()));
        request.setModify_time(new Date());
        request.setCreate_time(new Date());
        request.setPartner_id(reqVo.getPartnerId());
        request.setStore_id(orderBean.getShopId());
        request.setStore_name(orderBean.getShopName());
        request.setOrder_id(reqVo.getOrderId());
        request.setOrder_type(orderBean.getOrderType());
        return request;
    }

    private Integer getDefaultValue(Integer value) {
        if (value == null) {
            return 5;
        }
        return value;
    }

    public InsertProductEvaluationReqDto convent2InsertProductEvaluationReqDto(AddUserOrderEvaluationNewRequestVo reqVo, AddProductEvaluationReqDto addProductEvaluationReqDto) {
        InsertProductEvaluationReqDto request = new InsertProductEvaluationReqDto();
        request.setIsCall(addProductEvaluationReqDto.getIsCall() == null ? 0 : addProductEvaluationReqDto.getIsCall());
        request.setOrderId(reqVo.getOrderId());
        request.setPartnerId(reqVo.getPartnerId());
        request.setProductId(addProductEvaluationReqDto.getProductId());
        request.setProductName(addProductEvaluationReqDto.getProductName());
        request.setProductQty(addProductEvaluationReqDto.getProductQty());
        return request;
    }
}
