package cn.freemud.service.impl;

import cn.freemud.amp.config.DlPaymentMqConfig;
import cn.freemud.amqp.Header;
import cn.freemud.amqp.MQAction;
import cn.freemud.amqp.MQMessage;
import cn.freemud.amqp.MQService;
import cn.freemud.entities.dto.OrderPrintDto;
import cn.freemud.entities.dto.pay.PaymentMqMessageDto;
import cn.freemud.utils.AppLogUtil;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.config.TopicExchangeConfig;
import com.freemud.sdk.api.assortment.order.request.order.OrderStatusChangeRequestDto;
import org.apache.commons.lang.StringUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OrderQueueService {

    @Autowired
    private MQService mqService;


    // TODO: 21-9-17 定义常量
    @Value("${program.backorders_change_order_status_consumer_queue}")
    private String backOrdersChangeOrderStatusConsumerQueue;
    @Value("${program.backorders_notify_activity_exchange}")
    private String backOrdersNotifyActivityExchange;

    @Value("${mq.queue.cloud_print_queue}")
    private String cloudPrintQueue;
    @Value("${mq.cloud_print_exchange}")
    private String cloud_print_exchange;

    /**
     * 失败订单冲正 mq
     */
    public void backOrdersStatusChange(String oid, Integer orderStatus, Integer payStatus) {
        if (StringUtils.isEmpty(oid)) {
            return;
        }
        AppLogUtil.infoLog("backOrdersStatusChange oid:{} orderStatus:{}", oid, String.valueOf(orderStatus));
        OrderStatusChangeRequestDto requestDto = new OrderStatusChangeRequestDto();
        requestDto.setOid(oid);
        requestDto.setPayStatus(payStatus);
        requestDto.setOrderStatus(orderStatus);

        try {
            Header header = new Header(MQAction.INSERT.getAction(), "backOrdersStatusChange", oid, backOrdersChangeOrderStatusConsumerQueue);
            MQMessage<OrderStatusChangeRequestDto> message = new MQMessage<>(header, requestDto);
            mqService.convertAndSend(backOrdersNotifyActivityExchange, backOrdersChangeOrderStatusConsumerQueue, message);
        } catch (Exception e) {
            AppLogUtil.errorLog("ActivityReverse", JSON.toJSONString(requestDto), "", e);
        }
    }


    public void backOrdersStatusChange(String oid, Integer orderStatus) {
        if (StringUtils.isEmpty(oid)) {
            return;
        }
        AppLogUtil.infoLog("backOrdersStatusChange oid:{} orderStatus:{}", oid, String.valueOf(orderStatus));
        OrderStatusChangeRequestDto requestDto = new OrderStatusChangeRequestDto();
        requestDto.setOid(oid);
        requestDto.setOrderStatus(orderStatus);

        try {
            Header header = new Header(MQAction.INSERT.getAction(), "backOrdersStatusChange", oid, backOrdersChangeOrderStatusConsumerQueue);
            MQMessage<OrderStatusChangeRequestDto> message = new MQMessage<>(header, requestDto);
            mqService.convertAndSend(backOrdersNotifyActivityExchange, backOrdersChangeOrderStatusConsumerQueue, message);
        } catch (Exception e) {
            AppLogUtil.errorLog("ActivityReverse", JSON.toJSONString(requestDto), "", e);
        }
    }


    /**
     * 发MQ去打印
     *
     */
    public void asynchronousPrint(OrderPrintDto request) {
//        AppLogUtil.debugLog("OrderPrintDto", JSONObject.toJSONString(request), null);
        Header header = new Header(MQAction.INSERT.getAction(), "asynchronous-print-api", request.getOid() + "", cloudPrintQueue);
        MQMessage<OrderPrintDto> message = new MQMessage<>(header, request);
        mqService.convertAndSend(cloud_print_exchange, cloudPrintQueue, message);
    }

    /**
     * 发支付补偿mq，查询支付结果回调支付成功接口
     */
    public void paymentCallback(PaymentMqMessageDto dto) {
        MQMessage<PaymentMqMessageDto> mqMessage = new MQMessage<PaymentMqMessageDto>();
        mqMessage.setBody(dto);
        Integer ttl = 20 * 1000;
        Header header = new Header();
        header.setKey("1");
        mqMessage.setHeader(header);
        byte[] notifyMsgBytes = JSON.toJSONString(mqMessage).getBytes();
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.setExpiration(ttl.toString());
        messageProperties.setContentType(MessageProperties.CONTENT_TYPE_JSON);
        Message delmessage = new Message(notifyMsgBytes, messageProperties);
        mqService.convertAndSend(TopicExchangeConfig.EXCHANGE_NAME, DlPaymentMqConfig.OPEN_STORE_PAYMENT_QUERY_DL_KEY, delmessage);
    }
}
