package cn.freemud.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum InvoiceTypeCodeEnum {

    SPECIAL_INVOICE(4, "004", "增值税专用发票"),
    COMMON_INVOICE(7, "007", "增值税普通发票"),
    ELECTRONIC_INVOICE(26, "026", "增值税电子发票"),
    ROLL_INVOICE(25, "025", "增值税卷式发票"),
    SPECIAL_ELECTRONIC_INVOICE(28, "028", "增值税专用电子发票"),


    ;

    /**
     * 非码类型
     */
    private Integer fmType;

    /**
     * 百望类型
     */
    private String bwType;
    private String desc;

}
