/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: QueryOrderVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/22 17:35
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

@Data
public class QueryOrderVo {

    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;
    /**
     * 操作类型  1.详情  2.围餐桌号订单信息
     */
    private Integer operation;
    /**
     * 商户ID
     */
    private String partnerId;
    /**
     * 订单ID
     */
    private String oid;
    /**
     * 订单状态 enum queryOrderStatus   全部订单 1 待取餐 2 已完成 3 全部   4.退款,5 待支付 ,6 已取消  7未支付取消 8待使用（美业）
     */
    private Integer queryOrderStatus;
    /**
     * 订单支付状态 enum queryOrderStatus   全部订单 1 未支付 2 已支付 3 已退款   4. 部分退款
     */
    private Integer queryPayStatus;
    /**
     * 查询订单状态 1 外卖  4 门店自提
     */
    private Integer queryOrderType;
    /**
     *  每页显示几条数据
     */
    private Integer pageSize;
    /**
     * 第几页
     */
    private Integer pageNumber;

    private String startDate;

    private String endDate;

    /**
     * 渠道信息 saas; img; iwc; saasmall
     *  查询收银订单列表传 cashier
     */
    private String channelType;

    /**
     * 优惠券code
     */
    private String couponCode;
    /**
     * 优惠券对应的活动号
     */
    private String activityCode;

    /**
     * 是否使用用户积分
     * 1=不显示积分
     * 2=显示积分但不扣减
     * 3=显示积分且扣减
     */
    private Integer useCustomerScore;

    /**
     * svc 卡支付使用
     */
    private String cardCode;

    /**
     * 支付有礼 版本号 20210105新增字段
     */
    private Integer payGiftVer;

    /**
     * 订单特殊类型 1:普通订单 2:拼团订单 3:秒杀订单 4:拼单订单
     */
    private Integer marketingType;

    /**
     * 是否已开发票，false查询可开票订单，true查询其他订单（包含已开票/已退款订单）,查询实际支付金额大于0的
     */
    private Boolean needInvoice;

}
