package cn.freemud.service;

import cn.freemud.ShoppingCartApplication;
import cn.freemud.entities.dto.CheckSpqInfoRequestDto;
import cn.freemud.entities.dto.CheckSpqInfoResponseDto;
import cn.freemud.entities.dto.GetCouponDetailResponseDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.StoreItemStatus;
import cn.freemud.service.impl.calculate.CalculationCommonService;
import cn.freemud.service.impl.calculate.CalculationSharingEquallyService;
import cn.freemud.service.impl.calculate.promotion.AdditionSharingService;
import cn.freemud.service.impl.calculate.promotion.FullSharingService;
import cn.freemud.service.impl.calculate.promotion.GiftSharingService;
import cn.freemud.utils.FileUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title:
 * @Package: com.freemud.card.sdk
 * @Description:
 * @author: genyou.cui
 * @date: 2018/12/17 16:34
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = ShoppingCartApplication.class)
public class CartTest {

    private static final Logger logger = LoggerFactory.getLogger(CartTest.class);
    @Autowired
    private GiftSharingService giftSharingService;
    @Autowired
    private CalculationCommonService calculationCommonService;
    @Autowired
    private FullSharingService fullSharingService;
    @Autowired
    private AdditionSharingService additionSharingService;

    @Autowired
    private CalculationSharingEquallyService calculationSharingEquallyService;


    @Test
    public void cartTest() {
        ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo = new ShoppingCartGoodsResponseVo();
        /**
         * json string
         */
        String cartGoodsListStr = "[{\"spuName\":\"咖喱鸡套餐\",\"originalPrice\":4300,\"goodsId\":\"186791599886416647\",\"productMaterialList\":[],\"customerCode\":\"20200924001\",\"finalPrice\":200,\"createTimeMili\":1603262065331,\"pic\":\"https://picture.sandload.cn/1600916765127.png\",\"productComboList\":[{\"spuName\":\"桔子单品08\",\"originalPrice\":900,\"goodsId\":\"186550397524170796\",\"customerCode\":\"20200921008\",\"finalPrice\":900,\"pic\":\"https://picture.sandload.cn/1600683267756.png\",\"extra\":[],\"skuId\":\"186550397524170796\",\"amount\":900,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"斤\",\"originalAmount\":900,\"taxId\":\"\",\"qty\":1,\"name\":\"桔子单品08\"},{\"spuName\":\"桔子单品09\",\"originalPrice\":1000,\"goodsId\":\"186550397560870958\",\"customerCode\":\"20200921009\",\"finalPrice\":1000,\"pic\":\"https://picture.sandload.cn/1600683289350.png\",\"extra\":[],\"skuId\":\"186550397560870958\",\"amount\":1000,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"斤\",\"originalAmount\":1000,\"taxId\":\"\",\"qty\":1,\"name\":\"桔子单品09\"}],\"categoryName\":\"套餐\",\"originalMaterialAmount\":0,\"packPrice\":0,\"skuName\":\"咖喱鸡套餐\",\"riseSell\":1,\"classificationName\":\"肉\",\"productGroupList\":[{\"spuName\":\"桔子单品05\",\"originalPrice\":600,\"goodsId\":\"186550397401487398\",\"productGroupId\":186791000549735219,\"customerCode\":\"20200921005\",\"finalPrice\":100,\"pic\":\"https://picture.sandload.cn/1600682885597.png\",\"extra\":[],\"skuId\":\"186550397401487398\",\"amount\":400,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"斤\",\"originalAmount\":2400,\"taxId\":\"\",\"qty\":4,\"name\":\"桔子单品05\"}],\"memberDiscount\":100,\"skuId\":\"186791599886416647\",\"amount\":4300,\"cartGoodsUid\":\"5b1acd69-dcce-4037-b8a1-22c02931df4d\",\"stockLimit\":false,\"weight\":0.0,\"tax\":1.01,\"classificationId\":\"meat\",\"goodsType\":3,\"weightType\":false,\"unit\":\"\",\"originalAmount\":4300,\"subName\":\"\",\"taxId\":\"11111\",\"qty\":1,\"name\":\"咖喱鸡套餐\",\"materialAmount\":0,\"spuId\":\"186791599886416647\"}]";
        List<CartGoods> cartGoodsList = JSONObject.parseObject(cartGoodsListStr, new TypeReference<List<CartGoods>>() {
        });

        String discountResultStr = "{\"couponDiscounts\":[],\"originalTotalAmount\":2300,\"totalDiscountAmount\":1900,\"deliveryAmount\":0,\"distributionFee\":0,\"goods\":[{\"gift\":false,\"smallMaterial\":[{\"realAmount\":266,\"discounts\":[{\"activityCode\":\"88607489357455572654\",\"goodsId\":\"186550397401487398\",\"activityName\":\"2元代金券da\",\"actualGoodsNumber\":0,\"discount\":134,\"type\":3,\"activityDesc\":\"2元代金券da\"}],\"originalPrice\":100,\"goodsId\":\"186550397401487398\",\"discountAmount\":134,\"goodsQuantity\":4,\"type\":2}],\"groupCombox\":[{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"186550397524170796\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":799,\"type\":310,\"activityDesc\":\"套餐活动优惠\"},{\"goodsId\":\"186550397524170796\",\"activityName\":\"2元代金券da\",\"actualGoodsNumber\":0,\"discount\":31,\"type\":3}],\"originalPrice\":900,\"goodsId\":\"186550397524170796\",\"discountAmount\":830,\"goodsQuantity\":1},{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"186550397560870958\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":901,\"type\":310,\"activityDesc\":\"套餐活动优惠\"},{\"goodsId\":\"186550397560870958\",\"activityName\":\"2元代金券da\",\"actualGoodsNumber\":0,\"discount\":34,\"type\":3}],\"originalPrice\":1000,\"goodsId\":\"186550397560870958\",\"discountAmount\":935,\"goodsQuantity\":1}],\"cartGoodsUid\":\"5b1acd69-dcce-4037-b8a1-22c02931df4d\",\"originalPrice\":1900,\"goodsId\":\"186791599886416647\",\"actualGoodsNumber\":1,\"discountAmount\":1766,\"meal\":true,\"realAmount\":134,\"nowPrice\":200,\"discounts\":[{\"activityCode\":\"88607489357455572654\",\"goodsId\":\"186791599886416647\",\"activityName\":\"2元代金券da\",\"actualGoodsNumber\":1,\"discount\":66,\"type\":3},{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"186791599886416647\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":1700,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"goodsQuantity\":1,\"cartGoodType\":0}],\"apportionGoods\":[],\"stocks\":[],\"totalAmount\":400,\"discounts\":[{\"activityCode\":\"88607489357455572654\",\"activityName\":\"2元代金券da\",\"discount\":200,\"type\":3},{\"activityCode\":\"TCYH0000000001\",\"activityName\":\"套餐活动优惠\",\"discount\":1700,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"validCouponMap\":{}}";
        CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult = JSONObject.parseObject(discountResultStr, new TypeReference<CalculationSharingDiscountResponseDto.CalculationDiscountResult>() {
        });

        calculationSharingEquallyService.setShoppingCartGoodsDtoActivityDiscounts(discountResult, null);
        /**
         * 用促销价格初始化购物车行记录成交价
         */
        calculationCommonService.initShoppingCart(discountResult, cartGoodsList, shoppingCartGoodsResponseVo);
        /**
         * 满减处理
         */
        //fullSharingService.fullResponse(discountResult, cartGoodsList, shoppingCartGoodsResponseVo, null);
        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> goods = discountResult.getGoods();
        /**
         * 利用促销赋值totalDiscountAmount
         */
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> cartGoodsDetailDtoList = new ArrayList<>();
        shoppingCartGoodsResponseVo.setProducts(cartGoodsList);
        for (CartGoods product : shoppingCartGoodsResponseVo.getProducts()) {
            CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods find = goods.stream().filter((k) -> k.getCartGoodsUid().equals(product.getCartGoodsUid())).findFirst().get();
            ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = calculationCommonService.convertCartGoods2DetailGoodsList(find, product);
            cartGoodsDetailDtoList.add(cartGoodsDetailDto);
        }
    }


    @Test
    public void cartTest2() {
        ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo = new ShoppingCartGoodsResponseVo();
        /**
         * json string
         */
        String cartGoodsListStr = "[{\"spuName\":\"咖喱鸡套餐\",\"originalPrice\":4300,\"goodsId\":\"186791599886416647\",\"productMaterialList\":[],\"customerCode\":\"20200924001\",\"finalPrice\":200,\"createTimeMili\":1603262065331,\"pic\":\"https://picture.sandload.cn/1600916765127.png\",\"productComboList\":[{\"spuName\":\"桔子单品08\",\"originalPrice\":900,\"goodsId\":\"186550397524170796\",\"customerCode\":\"20200921008\",\"finalPrice\":900,\"pic\":\"https://picture.sandload.cn/1600683267756.png\",\"extra\":[],\"skuId\":\"186550397524170796\",\"amount\":900,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"斤\",\"originalAmount\":900,\"taxId\":\"\",\"qty\":1,\"name\":\"桔子单品08\"},{\"spuName\":\"桔子单品09\",\"originalPrice\":1000,\"goodsId\":\"186550397560870958\",\"customerCode\":\"20200921009\",\"finalPrice\":1000,\"pic\":\"https://picture.sandload.cn/1600683289350.png\",\"extra\":[],\"skuId\":\"186550397560870958\",\"amount\":1000,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"斤\",\"originalAmount\":1000,\"taxId\":\"\",\"qty\":1,\"name\":\"桔子单品09\"}],\"categoryName\":\"套餐\",\"originalMaterialAmount\":0,\"packPrice\":0,\"skuName\":\"咖喱鸡套餐\",\"riseSell\":1,\"classificationName\":\"肉\",\"productGroupList\":[{\"spuName\":\"桔子单品05\",\"originalPrice\":600,\"goodsId\":\"186550397401487398\",\"productGroupId\":186791000549735219,\"customerCode\":\"20200921005\",\"finalPrice\":100,\"pic\":\"https://picture.sandload.cn/1600682885597.png\",\"extra\":[],\"skuId\":\"186550397401487398\",\"amount\":400,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"斤\",\"originalAmount\":2400,\"taxId\":\"\",\"qty\":4,\"name\":\"桔子单品05\"}],\"memberDiscount\":100,\"skuId\":\"186791599886416647\",\"amount\":4300,\"cartGoodsUid\":\"5b1acd69-dcce-4037-b8a1-22c02931df4d\",\"stockLimit\":false,\"weight\":0.0,\"tax\":1.01,\"classificationId\":\"meat\",\"goodsType\":3,\"weightType\":false,\"unit\":\"\",\"originalAmount\":4300,\"subName\":\"\",\"taxId\":\"11111\",\"qty\":1,\"name\":\"咖喱鸡套餐\",\"materialAmount\":0,\"spuId\":\"186791599886416647\"}]";
        List<CartGoods> cartGoodsList = JSONObject.parseObject(cartGoodsListStr, new TypeReference<List<CartGoods>>() {
        });

        String discountResultStr = "{\"couponDiscounts\":[],\"originalTotalAmount\":2300,\"totalDiscountAmount\":1900,\"deliveryAmount\":0,\"distributionFee\":0,\"goods\":[{\"gift\":false,\"smallMaterial\":[{\"realAmount\":266,\"discounts\":[{\"activityCode\":\"88607489357455572654\",\"goodsId\":\"186550397401487398\",\"activityName\":\"2元代金券da\",\"actualGoodsNumber\":0,\"discount\":134,\"type\":3,\"activityDesc\":\"2元代金券da\"}],\"originalPrice\":100,\"goodsId\":\"186550397401487398\",\"discountAmount\":134,\"goodsQuantity\":4,\"type\":2}],\"groupCombox\":[{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"186550397524170796\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":799,\"type\":310,\"activityDesc\":\"套餐活动优惠\"},{\"goodsId\":\"186550397524170796\",\"activityName\":\"2元代金券da\",\"actualGoodsNumber\":0,\"discount\":31,\"type\":3}],\"originalPrice\":900,\"goodsId\":\"186550397524170796\",\"discountAmount\":830,\"goodsQuantity\":1},{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"186550397560870958\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":901,\"type\":310,\"activityDesc\":\"套餐活动优惠\"},{\"goodsId\":\"186550397560870958\",\"activityName\":\"2元代金券da\",\"actualGoodsNumber\":0,\"discount\":34,\"type\":3}],\"originalPrice\":1000,\"goodsId\":\"186550397560870958\",\"discountAmount\":935,\"goodsQuantity\":1}],\"cartGoodsUid\":\"5b1acd69-dcce-4037-b8a1-22c02931df4d\",\"originalPrice\":1900,\"goodsId\":\"186791599886416647\",\"actualGoodsNumber\":1,\"discountAmount\":1766,\"meal\":true,\"realAmount\":134,\"nowPrice\":200,\"discounts\":[{\"activityCode\":\"88607489357455572654\",\"goodsId\":\"186791599886416647\",\"activityName\":\"2元代金券da\",\"actualGoodsNumber\":1,\"discount\":66,\"type\":3},{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"186791599886416647\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":1700,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"goodsQuantity\":1,\"cartGoodType\":0}],\"apportionGoods\":[],\"stocks\":[],\"totalAmount\":400,\"discounts\":[{\"activityCode\":\"88607489357455572654\",\"activityName\":\"2元代金券da\",\"discount\":200,\"type\":3},{\"activityCode\":\"TCYH0000000001\",\"activityName\":\"套餐活动优惠\",\"discount\":1700,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"validCouponMap\":{}}";
        CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult = JSONObject.parseObject(discountResultStr, new TypeReference<CalculationSharingDiscountResponseDto.CalculationDiscountResult>() {
        });
        ShoppingCartGoodsDto shoppingCartGoodsDto = new ShoppingCartGoodsDto();
        calculationSharingEquallyService.setShoppingCartGoodsDtoActivityDiscounts(discountResult, shoppingCartGoodsDto);
        /**
         * 用促销价格初始化购物车行记录成交价
         */
        calculationCommonService.initShoppingCart(discountResult, cartGoodsList, shoppingCartGoodsResponseVo);
        /**
         * 满减处理
         */
        fullSharingService.fullResponse(discountResult, cartGoodsList, shoppingCartGoodsResponseVo, null);
        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> goods = discountResult.getGoods();
        /**
         * 利用促销赋值totalDiscountAmount
         */
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> cartGoodsDetailDtoList = new ArrayList<>();
        shoppingCartGoodsResponseVo.setProducts(cartGoodsList);
        for (CartGoods product : shoppingCartGoodsResponseVo.getProducts()) {
            CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods find = goods.stream().filter((k) -> k.getCartGoodsUid().equals(product.getCartGoodsUid())).findFirst().get();
            ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = calculationCommonService.convertCartGoods2DetailGoodsList(find, product);
            cartGoodsDetailDtoList.add(cartGoodsDetailDto);
        }
        //ShoppingCartInfoRequestVo
        String shoppingCartInfoRequestVoStr = "{\"premiumExchangeActivity\":{\"activityCode\":\"MEHG2020092914160146595\",\"activityName\":\"丹妮加价购活动\",\"products\":[{\"attributes\":[],\"originalPrice\":1300,\"qty\":1,\"skuId\":\"186550397673068596\",\"skuName\":\"桔子单品12\",\"spuId\":\"186550397673068596\"}]},\"shoppingCartInfoRequestVo\":{\"flag\":0,\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"2399\",\"reachStoreType\":4,\"receiveId\":\"3584084950985469155\",\"sessionId\":\"146e3ced5884092de0ba3d0369cf7dc338b515c8\",\"shopId\":\"716001\",\"useCustomerScore\":2,\"version\":\"2.0.1\"}}";
        GetShoppingCartGoodsApportionRequestVo getShoppingCartGoodsApportionRequestVo = JSONObject.parseObject(shoppingCartInfoRequestVoStr, new TypeReference<GetShoppingCartGoodsApportionRequestVo>() {
        });
        /**
         * 加价购商品
         */
        additionSharingService.equally(getShoppingCartGoodsApportionRequestVo.getShoppingCartInfoRequestVo(), null, discountResult, getShoppingCartGoodsApportionRequestVo.getPremiumExchangeActivity());
    }

    @Test
    public void gift() {
        ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo = new ShoppingCartGoodsResponseVo();
        /**
         * json string
         */
        String cartGoodsListStr = "[{\"spuName\":\"棒棒鸡001测试下它的名称有多长呀\",\"originalPrice\":80,\"goodsId\":\"178866782811063078\",\"productMaterialList\":[],\"customerCode\":\"W784564616546461\",\"finalPrice\":80,\"createTimeMili\":1603174607026,\"pic\":\"https://picture.sandload.cn/1601446435601.jpg\",\"productComboList\":[],\"categoryName\":\"买赠赠小样\",\"originalMaterialAmount\":0,\"packPrice\":100,\"skuName\":\"棒棒鸡001测试下它的名称有多长呀\",\"riseSell\":1,\"classificationName\":\"面\",\"productGroupList\":[],\"memberDiscount\":78,\"skuId\":\"\",\"amount\":80,\"cartGoodsUid\":\"843d540c-0056-4a32-a02b-8798c886345c\",\"stockLimit\":true,\"weight\":0.01,\"tax\":0.01,\"classificationId\":\"noodlenoodlenoodleno\",\"goodsType\":5,\"weightType\":false,\"unit\":\"杯\",\"originalAmount\":80,\"subName\":\"\",\"taxId\":\"\",\"qty\":1,\"name\":\"棒棒鸡001测试下它的名称有多长呀\",\"materialAmount\":0,\"spuId\":\"178866782811063078\"}]";
        List<CartGoods> cartGoodsList = JSONObject.parseObject(cartGoodsListStr, new TypeReference<List<CartGoods>>() {
        });

        String discountResultStr = "{\"couponDiscounts\":[],\"originalTotalAmount\":120,\"totalDiscountAmount\":57,\"deliveryAmount\":0,\"distributionFee\":0,\"goods\":[{\"gift\":false,\"smallMaterial\":[],\"cartGoodsUid\":\"843d540c-0056-4a32-a02b-8798c886345c\",\"originalPrice\":80,\"goodsId\":\"178866782811063078\",\"actualGoodsNumber\":1,\"discountAmount\":17,\"meal\":false,\"realAmount\":63,\"nowPrice\":63,\"discounts\":[{\"activityCode\":\"SPHYJ0000000001\",\"goodsId\":\"178866782811063078\",\"activityName\":\"商品会员价\",\"actualGoodsNumber\":1,\"discount\":17,\"type\":320}],\"goodsQuantity\":1,\"cartGoodType\":0},{\"gift\":false,\"originalPrice\":20,\"goodsId\":\"146135281451628826\",\"discountAmount\":40,\"meal\":false,\"realAmount\":0,\"nowPrice\":0,\"discounts\":[{\"activityCode\":\"BNSP2020092717540005004\",\"goodsId\":\"146135281451628826\",\"activityName\":\"柚子的买赠\",\"actualGoodsNumber\":2,\"discount\":40,\"type\":62}],\"goodsQuantity\":2,\"cartGoodType\":1}],\"apportionGoods\":[],\"sendGoods\":[],\"stocks\":[],\"totalAmount\":63,\"discounts\":[{\"activityCode\":\"SPHYJ0000000001\",\"activityName\":\"商品会员价\",\"discount\":17,\"type\":320,\"activityDesc\":\"商品会员价\"},{\"activityCode\":\"BNSP2020092717540005004\",\"activityName\":\"柚子的买赠\",\"discount\":40,\"type\":62,\"activityDesc\":\"\"}],\"validCouponMap\":{}}";
        CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult = JSONObject.parseObject(discountResultStr, new TypeReference<CalculationSharingDiscountResponseDto.CalculationDiscountResult>() {
        });
        /**
         * 用促销价格初始化购物车行记录成交价
         */
        calculationCommonService.initShoppingCart(discountResult, cartGoodsList, shoppingCartGoodsResponseVo);
        /**
         * 利用促销赋值totalDiscountAmount
         */
        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> goods = discountResult.getGoods();
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> cartGoodsDetailDtoList = new ArrayList<>();
        shoppingCartGoodsResponseVo.setProducts(cartGoodsList);
        shoppingCartGoodsResponseVo.setProducts(cartGoodsList);
        for (CartGoods product : shoppingCartGoodsResponseVo.getProducts()) {
            CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods find = goods.stream().filter((k) -> k.getCartGoodsUid().equals(product.getCartGoodsUid())).findFirst().get();
            ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = calculationCommonService.convertCartGoods2DetailGoodsList(find, product);
            cartGoodsDetailDtoList.add(cartGoodsDetailDto);
        }
        /**
         * 赠品
         */
        giftSharingService.equally(discountResult, cartGoodsDetailDtoList, null, "saas");
    }

    @Test
    public void product() {
        String productStr = "{\"additionalGroupList\":[],\"barcode\":\"\",\"brandId\":\"\",\"brandName\":\"\",\"businessNo\":\"\",\"businessType\":\"\",\"category\":\"\",\"categoryName\":\"\",\"companyId\":\"2399\",\"completeFlag\":0,\"customerCode\":\"170796389234812474\",\"customerName\":\"\",\"detailImages\":[],\"detailText\":\"\",\"finalPrice\":2,\"isDishware\":0,\"isSkuProduct\":1,\"labelNames\":[],\"maxLimitNumber\":0,\"maxRestrictionQty\":0,\"memberDiscount\":0,\"minLimitNumber\":0,\"minRestrictionQty\":0,\"name\":\"柚子的多规格螃蟹/大杯\",\"openMemberDiscount\":0,\"options\":\"\",\"originalPrice\":2,\"otherDesc\":\"\",\"packPrice\":0,\"picture\":\"https://img10.sandload.cn/柚子的多规格螃蟹.jpg?timestamp=1594117985325\",\"pid\":\"170796389234812474\",\"pknumber\":0,\"priceSource\":1,\"productAttributeGroupList\":[],\"productBindingCouponTypes\":[],\"productCategoryDetailList\":[],\"productCode\":\"\",\"productComboList\":[],\"productGroupList\":[],\"productPictureList\":[{\"sequence\":0,\"type\":\"default\",\"url\":\"https://img10.sandload.cn/柚子的多规格螃蟹.jpg?timestamp=1594117985325\"}],\"productSpecification\":[],\"productionLocation\":\"\",\"rawMaterial\":\"\",\"remark\":\"\",\"riseSell\":1,\"saleCount\":0,\"salesChannel\":\"\",\"sellTimeList\":[],\"sellTimeMonthList\":[],\"sellTimeRangeList\":[],\"sellTimeValid\":true,\"sequence\":0,\"shopLongTermSalesVolume\":0,\"shopShortTermSalesVolume\":0,\"skuList\":[],\"skuSpecValues\":[{\"productId\":\"170796389234812474\",\"sequence\":2,\"specAttrValues\":[],\"specCustomerCode\":\"hyjbx\",\"specId\":\"170796304154404393\",\"specName\":\"韩月季_杯型\",\"specValue\":\"大杯\",\"specValueCustomerCode\":\"33\",\"specValueId\":\"170796324362561068\"}],\"sourceChannel\":\"\",\"specProductId\":\"\",\"specification\":\"\",\"specificationGroupList\":[],\"specificationList\":[],\"standardGoodsFlag\":0,\"status\":1,\"stock\":9999,\"stockLimit\":2,\"storeCondition\":\"\",\"storeProductName\":\"\",\"tax\":0,\"taxId\":\"\",\"type\":1,\"unit\":\"g\",\"valid\":false,\"version\":0,\"weight\":2,\"weightType\":0}";
        GetProductsVo getProductsVo = JSONObject.parseObject(productStr, new TypeReference<GetProductsVo>() {
        });
        if (null == getProductsVo || !Objects.equals(getProductsVo.getStatus(), StoreItemStatus.PUT_ON_SALE.getCode())) {
            return;
        }
    }
}
