package cn.freemud.service.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.entities.vo.CreatePrepayVo;
import cn.freemud.entities.vo.encircle.CreateReserveOrderVo;
import cn.freemud.enums.OrderChannelType;
import cn.freemud.enums.ResponseResult;
import cn.freemud.enums.UserLoginChannelEnum;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.*;
import cn.freemud.utils.ResponseUtil;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.api.assortment.datamanager.enums.IappIdType;
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: OrderAdapterServiceImpl
 * @Description: 订单业务适配
 * @author: qin.zhou
 * @date: 2019/9/818:22
 * @Copyright: ${DATE.YARE} www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class OrderAdapterServiceImpl implements OrderAdapterService {

    @Autowired
    private EncircleOrderService encircleOrderService;
    @Autowired
    private Orderservice orderservice;
    @Autowired
    private AssortmentCustomerInfoManager assortmentCustomerInfoManager;
    @Autowired
    private MallOrderService mallOrderService;
    @Autowired
    private AppOrderService appOrderService;

    @Override
    public BaseResponse createOrderNew(CreateOrderVo createOrderVo) {
        AssortmentCustomerInfoVo assortmentCustomerInfoVo = assortmentCustomerInfoManager.getCustomerInfoByObject(createOrderVo.getSessionId());
        if (assortmentCustomerInfoVo == null || StringUtils.isEmpty(assortmentCustomerInfoVo.getMemberId())) {
            return ResponseUtil.error(ResponseResult.NOT_LOGIN);
        }
        // 扩展字段中存储 sessionKey
        createOrderVo.setSessionKey(assortmentCustomerInfoVo.getSessionKey());
        if(IappIdType.WC_XCX.getCode().equals(assortmentCustomerInfoVo.getIappId())){  //i围餐
            BaseResponse baseResponse = null;
            CreateReserveOrderVo createReserveOrderVo = new CreateReserveOrderVo();
            createReserveOrderVo.setCarVer(createOrderVo.getCarVer());
            createReserveOrderVo.setRepastNumber(createOrderVo.getPeopleNumber());
            createReserveOrderVo.setSessionId(createOrderVo.getSessionId());
            createReserveOrderVo.setOrderUpdateVer(createOrderVo.getOrderUpdateVer());
            createReserveOrderVo.setCouponCode(createOrderVo.getCouponCode());
            if(createOrderVo.getOperation() == null) throw new ServiceException(ResponseResult.ORDER_CREATE_OPERATION_ERROR);
            switch (createOrderVo.getOperation()){
                case 2:// 开台
                    baseResponse = encircleOrderService.createReserveOrder(createOrderVo);
                    break;
                case 3:// 下单
                    baseResponse = encircleOrderService.updateReserveOrder(createReserveOrderVo);
                    break;
                case 4:// 创建预支付订单
                    baseResponse = encircleOrderService.createPrepaymentOrder(createReserveOrderVo);
                    break;
                    default:
                        throw new ServiceException(ResponseResult.ORDER_CREATE_OPERATION_ERROR);
            }
            return baseResponse;
        }

        /**
         * 商城订单
         */
        if(OrderChannelType.SAASMALL.getCode().equals(createOrderVo.getChannelType())) {
            return mallOrderService.createOrder(createOrderVo);
        }

        /**
         * APP下单
         */
        if (UserLoginChannelEnum.APP.getCode().equals(assortmentCustomerInfoVo.getChannel())) {
            return appOrderService.createOrderFlow(createOrderVo);
        }

        //原标准点餐程序逻辑处理
        BaseResponse baseResponse = this.checkStandardParamInfo(createOrderVo);
        if(ObjectUtils.notEqual(baseResponse.getCode(),ResponseResult.SUCCESS.getCode())){
            return baseResponse;
        }
        return orderservice.createOrderNew(createOrderVo);
    }

    @Override
    public BaseResponse createPrepay(CreatePrepayVo createPrepayVo) {
        AssortmentCustomerInfoVo assortmentCustomerInfoVo = assortmentCustomerInfoManager.getCustomerInfoByObject(createPrepayVo.getSessionId());
        if (assortmentCustomerInfoVo == null || StringUtils.isEmpty(assortmentCustomerInfoVo.getMemberId())) {
            return ResponseUtil.error(ResponseResult.NOT_LOGIN);
        }
        if (UserLoginChannelEnum.APP.getCode().equals(assortmentCustomerInfoVo.getChannel())) {
            return appOrderService.createPrepay(createPrepayVo);
        }
        throw new UnsupportedOperationException("暂不支持渠道："+assortmentCustomerInfoVo.getChannel());
    }

    /**
     * 标准点餐参数校验
     * @param createOrderVo
     * @return
     */
    private BaseResponse checkStandardParamInfo(CreateOrderVo createOrderVo){
        if(StringUtils.isEmpty(createOrderVo.getSessionId())){
            return ResponseUtil.error(ResponseResult.CREATE_ORDER_CHECK_SESSION_ERROR);
        }
        if(StringUtils.isEmpty(createOrderVo.getShopId())){
            return ResponseUtil.error(ResponseResult.CREATE_ORDER_CHECK_STORE_ERROR);
        }
        if(createOrderVo.getOrderType() == null){
            return ResponseUtil.error(ResponseResult.CREATE_ORDER_CHECK_ORDERTYPE_ERROR);
        }
        return ResponseUtil.success();
    }
}
