package cn.freemud.service.impl;

import cn.freemud.entities.dto.promotion.*;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.service.IPromotionService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class FullPromotionService implements IPromotionService {

    @Override
    public void updateDiscountApportion(ShoppingCartGoodsResponse shoppingCartGoodsResponse, OrderBeanRequest request, CalculationDiscountResultDto calculationDiscountResult, CouponPromotionDto couponPromotionDto) {
        List<CalculationGoodsActivityDto> discountList = (calculationDiscountResult == null || calculationDiscountResult.getDiscounts() == null) ? new ArrayList<>() : calculationDiscountResult.getDiscounts();
        if(CollectionUtils.isEmpty(discountList)){
            return;
        }
        //过滤出参与的满减(目前只有每满减和阶梯满减)
        List<CalculationGoodsActivityDto> fullDiscountsList = discountList
                .stream().filter(discount -> ActivityTypeEnum.TYPE_11.getCode().equals(discount.getType()) || ActivityTypeEnum.TYPE_12.getCode().equals(discount.getType()))
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(fullDiscountsList)) {
            return;
        }
        //总的满减优惠金额
        long fullDiscount = 0L;
        for (CalculationGoodsActivityDto fullDiscounts : fullDiscountsList) {
            fullDiscount = fullDiscount + (fullDiscounts.getDiscount() == null ? 0 : fullDiscounts.getDiscount());
        }
        shoppingCartGoodsResponse.setFullDiscount(fullDiscount);
    }
}
