package cn.freemud.service.impl;

import cn.freemud.entities.dto.promotion.*;
import cn.freemud.entities.dto.shoppingCart.ActivityDiscountsDto;
import cn.freemud.entities.vo.ActivityClassifyCouponBean;
import cn.freemud.entities.vo.ActivityDiscountsVo;
import cn.freemud.enums.CouponFlag;
import cn.freemud.service.CouponService;
import cn.freemud.service.IPromotionService;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class CouponPromotionService implements IPromotionService {
    @Autowired
    private CouponService couponService;
    @Override
    public void updateDiscountApportion(ShoppingCartGoodsResponse shoppingCartGoodsResponse, OrderBeanRequest request, CalculationDiscountResultDto calculationDiscountResult, CouponPromotionDto couponPromotionDto) {
        // 用户选择了查询优惠券信息
        if (couponPromotionDto != null && ObjectUtils.equals(CouponFlag.YES.getCode(), couponPromotionDto.getFlg())) {
            // 是否存在商品券
            boolean hasGoodsCoupon = false;
            // 构建可用不可用优惠券
            ActivityClassifyCouponBean activityClassifyCouponBean = couponService.availableCoupon(shoppingCartGoodsResponse.getProducts(), couponPromotionDto.getPartnerId()
                    , couponPromotionDto.getUserId(), couponPromotionDto.getStoreId(), couponPromotionDto.getCouponCode(), hasGoodsCoupon, couponPromotionDto.getOrderType());
            if (Objects.equals(activityClassifyCouponBean, null)) {
                // 构建一个空得订单券信息
                activityClassifyCouponBean = createEmptyActivityCouponBean();
            }
            shoppingCartGoodsResponse.setAvailableCoupon(activityClassifyCouponBean);
        } else {
            // 构建一个空得订单券信息
            ActivityClassifyCouponBean activityClassifyCouponBean = createEmptyActivityCouponBean();
            shoppingCartGoodsResponse.setAvailableCoupon(activityClassifyCouponBean);
        }

        List<CalculationApportionGoodsDto> apportionGoods = (calculationDiscountResult == null || calculationDiscountResult.getApportionGoods() == null) ? new ArrayList<>() : calculationDiscountResult.getApportionGoods();
        List<CouponCalculationResultDto> couponResultsList = (calculationDiscountResult == null || calculationDiscountResult.getCouponDiscounts() == null) ? new ArrayList<>() : calculationDiscountResult.getCouponDiscounts();
        // 当couponCode不为空时，需计算优惠价格
        long couponDiscount = 0;
        if (couponPromotionDto != null && StringUtils.isNotEmpty(couponPromotionDto.getCouponCode())
                && calculationDiscountResult != null) {
            if (CollectionUtils.isNotEmpty(couponResultsList)) {
                for (CouponCalculationResultDto couponResults : couponResultsList) {
                    couponDiscount = couponDiscount + (couponResults.getDiscountAmount() == null ? 0 : couponResults.getDiscountAmount());
                }
            }
        }
        shoppingCartGoodsResponse.setCouponDiscount(couponDiscount);

        List<ActivityDiscountsDto> activityDiscountsDtos = shoppingCartGoodsResponse.getActivityDiscountsDtos() == null ? new ArrayList<>() : shoppingCartGoodsResponse.getActivityDiscountsDtos();
        if (CollectionUtils.isNotEmpty(couponResultsList)) {
            for (CouponCalculationResultDto couponResults : couponResultsList) {
                ActivityDiscountsDto activityDiscountDto = getActivityDiscountDto(apportionGoods, couponResults);
                if (activityDiscountDto != null) {
                    activityDiscountsDtos.add(activityDiscountDto);
                }
            }
        }
        shoppingCartGoodsResponse.setActivityDiscountsDtos(activityDiscountsDtos);
    }


    private ActivityDiscountsDto getActivityDiscountDto(List<CalculationApportionGoodsDto> apportionGoods, CouponCalculationResultDto couponDiscount) {
        String couponCode = couponDiscount.getCouponCode();
        if(CollectionUtils.isNotEmpty(apportionGoods)) {
            for (CalculationApportionGoodsDto apportionGood : apportionGoods) {
                List<CalculationApportionDetailDto> list = apportionGood.getApportionDetails().stream().filter(detail -> ObjectUtils.equals(couponCode, detail.getActivityCode())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(list)) {
                    CalculationApportionDetailDto apportionDetails = list.get(0);
                    ActivityDiscountsDto activityDiscountsDto = new ActivityDiscountsDto();
                    activityDiscountsDto.setActivityCode(apportionDetails.getActivityCode());
                    activityDiscountsDto.setActivityName(apportionDetails.getActivityName());
                    activityDiscountsDto.setActivityType(apportionDetails.getActivityType());
                    activityDiscountsDto.setDiscountAmount(0 - couponDiscount.getDiscountAmount());
                    return activityDiscountsDto;
                }
            }
        }
        return null;
    }

    public ActivityClassifyCouponBean createEmptyActivityCouponBean() {
        ActivityClassifyCouponBean activityClassifyCouponBean = new ActivityClassifyCouponBean();
        activityClassifyCouponBean.setCouponNum(0);
        activityClassifyCouponBean.setDisableCouponNum(0);
        activityClassifyCouponBean.setUsableCouponNum(0);
        activityClassifyCouponBean.setDisableCoupons(Lists.newArrayList());
        activityClassifyCouponBean.setUsableCoupons(Lists.newArrayList());
        return activityClassifyCouponBean;
    }

}
