package cn.freemud.entities.dto.promotion;

import cn.freemud.entities.dto.shoppingCart.ActivityDiscountsDto;
import cn.freemud.entities.vo.ActivityClassifyCouponBean;
import cn.freemud.entities.vo.ActivityDiscountsVo;
import cn.freemud.entities.vo.ActivityTip;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;


@Data
public class ShoppingCartGoodsResponse {

    /**
     * 购物车实际选择商品，包含加价购商品
     */
    List<CartGoodsDetailDto> products;
    /**
     * 购物车原总价
     */
    private Long originalTotalAmount;
    /**
     * 购物车现总价
     */
    private Long totalAmount;
    /**
     * 购物车总折扣价(优惠价)
     */
    private Long totalDiscountAmount;
    /**
     * 购物车总包装费
     */
    private Long packageAmount;
    /**
     * 积分扣减金额
     */
    private Long scoreReduceAmount;
    /**
     * 抵用积分
     */
    private Long reduceScore;

    /**
     * 第一次使用会员卡需多支付的金额 单位为分
     */
    private Integer memberCardAmount;

    /**
     * 会员卡原价
     */
    private Integer cardOriginalAmount;

    /**
     * 会员卡优惠金额
     */
    private Integer cardDiscountAmount;

    /**
     * 订单享受的促销活动
     */
    List<ActivityDiscountsDto> activityDiscountsDtos;
    /**
     * 可用优惠券列表
     */
    private ActivityClassifyCouponBean availableCoupon;
    /**
     * 扣减库存
     */
    private List<SubtractStockVO> stocks;
    /**
     * 优惠券折扣
     */
    private Long couponDiscount;
    /**
     * 满减折扣
     */
    private Long fullDiscount;
    /**
     * 前端用来提示的信息
     */
    private String toastMsg;


    @Data
    public static class CartGoodsDetailDto {
        /**
         * spuId
         */
        private String productId;

        /**
         * 商品行原始价格  --单价
         */
        private Long originalPrice;

        /**
         * 商品的数量
         */
        private Integer qty;
        /**
         * 商品行优惠总金额=数量*单个商品优惠金额
         */
        private Integer totalDiscountAmount;
        /**
         * 商品排序
         */
        private Integer sequence;

        /**
         * 重量
         */
        private BigDecimal weight;
        
        /**
         * 商品类型 
         */
        private Integer productType;

        /**
         * 商品总原价
         */
        private Long originalTotalAmount;

        private Long settlementPrice;

        private Long finalPrice;
        
        /**
         * 套餐子商品
         */
        private List<CartGoodsDetailDto> comboList;

        /**
         * 订单享受的促销活动
         */
        List<ActivityDiscountsDto> activityDiscountsDtos;

    }

}
