package cn.freemud.management.service.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.enums.ResponseResult;
import cn.freemud.management.intercept.OrderServiceException;
import cn.freemud.management.util.ResponseUtil;
import com.freemud.sdk.api.assortment.order.adapter.OrderSdkAdapter;
import com.freemud.sdk.api.assortment.order.request.order.BaseQueryOrderRequest;
import com.freemud.sdk.api.assortment.order.response.order.BaseOrderResponse;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import com.freemud.sdk.api.assortment.order.service.OrderCenterSdkService;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: SaasOrderService
 * @Package cn.freemud.management.service.impl
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/4/23 11:30
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class SaasOrderService {
    @Autowired
    private OrderSdkAdapter orderSdkAdapter;
    @Autowired
    private OrderCenterSdkService orderCenterSdkService;

    /**
     * 订单制作完成
     * @param request
     * @param orderBean
     * @return
     */
    public BaseResponse orderDone(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean){
        BaseQueryOrderRequest orderDoneRequest = orderSdkAdapter.getOrderConfirmRequest(request.getOperator(), orderBean);
        BaseOrderResponse baseOrderResponse = orderCenterSdkService.orderDone(orderDoneRequest);
        if (baseOrderResponse==null || ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(),baseOrderResponse.getErrcode().toString())){
            throw new OrderServiceException(ResponseResult.DONE_ORDER_FAIL);
        }
        return ResponseUtil.success();
    }

    /**
     * 订单配送
     * @param request
     * @param orderBean
     * @return
     */
    public BaseResponse orderDelivery(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean){
        BaseQueryOrderRequest orderDeliveryRequest = orderSdkAdapter.getOrderDeliveryRequest(request.getOperator(), orderBean);
        BaseOrderResponse baseOrderResponse = orderCenterSdkService.orderSend(orderDeliveryRequest);
        if (baseOrderResponse==null || ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(),baseOrderResponse.getErrcode().toString())){
            throw new OrderServiceException(ResponseResult.DELIVERY_FAIL);
        }
        return ResponseUtil.success();
    }

    /**
     * 订单完成
     * @param request
     * @param orderBean
     * @return
     */
    public BaseResponse orderAffirm(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean){
        BaseQueryOrderRequest orderAffirmRequest = orderSdkAdapter.getOrderDeliveryRequest(request.getOperator(), orderBean);
        BaseOrderResponse baseOrderResponse = orderCenterSdkService.orderAffirm(orderAffirmRequest);
        if (baseOrderResponse==null || ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(),baseOrderResponse.getErrcode().toString())){
            throw new OrderServiceException(ResponseResult.AFFIRM_ORDER_FAIL);
        }
        return ResponseUtil.success();
    }
}
