package cn.freemud.service;

import cn.freemud.utils.SpringBeanUtil;
import com.freemud.application.sdk.api.base.BaseResponse;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.storecenter.request.vo.GetOrgTreeListRequest;
import com.freemud.application.sdk.api.storecenter.response.vo.GetOrgTreeListResponse;
import com.freemud.application.sdk.api.storecenter.service.StoreCenterService;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public interface CommonService {

    /**
     * 获取organizationId集合
     * @return
     */
    default List<String> getOrgIds(String partnerId, String storeCode) {
        GetOrgTreeListRequest request = new GetOrgTreeListRequest();
        request.setPartnerId(partnerId);
        request.setStoreCode(storeCode);
        StoreCenterService storeCenterService = SpringBeanUtil.getBean(StoreCenterService.class);
        BaseResponse<GetOrgTreeListResponse> response  = storeCenterService.getOrgTreeList(request, LogThreadLocal.getTrackingNo());
        if (Objects.equals("100", response.getCode()) && response.getData() != null) {
            List<GetOrgTreeListResponse.OrgList> orgList = ((GetOrgTreeListResponse)response.getData()).getOrgList();
            if (org.springframework.util.CollectionUtils.isEmpty(orgList)) {
                return null;
            } else {
                List<String> orgIds = (List)orgList.stream().map(GetOrgTreeListResponse.OrgList::getOrganizationId).collect(Collectors.toList());
                return orgIds;
            }
        } else {
            return null;
        }
    }
}
